/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SaslUtil {
    public static final String SASL_DEFAULT_REALM = "default";
    public static final Map<String, String> SASL_PROPS = new TreeMap<String, String>();
    public static final int SWITCH_TO_SIMPLE_AUTH = -88;

    public static String[] splitKerberosName(String fullName) {
        return fullName.split("[/@]");
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier));
    }

    static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64((byte[])identifier.getBytes());
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password)).toCharArray();
    }

    static void initSaslProperties(String rpcProtection) {
        QualityOfProtection saslQOP = QualityOfProtection.AUTHENTICATION;
        if (QualityOfProtection.INTEGRITY.name().toLowerCase().equals(rpcProtection)) {
            saslQOP = QualityOfProtection.INTEGRITY;
        } else if (QualityOfProtection.PRIVACY.name().toLowerCase().equals(rpcProtection)) {
            saslQOP = QualityOfProtection.PRIVACY;
        }
        SASL_PROPS.put("javax.security.sasl.qop", saslQOP.getSaslQop());
        SASL_PROPS.put("javax.security.sasl.server.authentication", "true");
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        public final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }
    }
}

