/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.codec.Codec;

@InterfaceAudience.Private
public abstract class BaseDecoder
implements Codec.Decoder {
    protected static final Log LOG = LogFactory.getLog(BaseDecoder.class);
    protected final InputStream in;
    private boolean hasNext = true;
    private Cell current = null;

    public BaseDecoder(InputStream in) {
        this.in = in;
    }

    @Override
    public boolean advance() throws IOException {
        if (!this.hasNext) {
            return this.hasNext;
        }
        if (this.in.available() == 0) {
            this.hasNext = false;
            return this.hasNext;
        }
        try {
            this.current = this.parseCell();
        }
        catch (IOException ioEx) {
            this.rethrowEofException(ioEx);
        }
        return this.hasNext;
    }

    private void rethrowEofException(IOException ioEx) throws IOException {
        boolean isEof = false;
        try {
            isEof = this.in.available() == 0;
        }
        catch (Throwable t) {
            LOG.trace((Object)"Error getting available for error message - ignoring", t);
        }
        if (!isEof) {
            throw ioEx;
        }
        LOG.error((Object)("Partial cell read caused by EOF: " + ioEx));
        EOFException eofEx = new EOFException("Partial cell read");
        eofEx.initCause(ioEx);
        throw eofEx;
    }

    protected abstract Cell parseCell() throws IOException;

    @Override
    public Cell current() {
        return this.current;
    }
}

