/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class JobUtil {
    private static final Log LOG = LogFactory.getLog(JobUtil.class);

    protected JobUtil() {
    }

    public static Path getStagingDir(Configuration conf) throws IOException, InterruptedException {
        Path stagingDirPath = null;
        try {
            stagingDirPath = JobUtil.getStagingDirFromMR1(conf);
        }
        catch (NoSuchMethodException e) {
            stagingDirPath = JobUtil.getStagingDirFromMR2(conf);
        }
        if (stagingDirPath != null) {
            LOG.debug((Object)("Staging dir of the job is: " + stagingDirPath));
        }
        return stagingDirPath;
    }

    private static Path getStagingDirFromMR1(Configuration conf) throws IOException, NoSuchMethodException, InterruptedException {
        Path stagingDirPath;
        JobClient jobClient = new JobClient(new JobConf(conf));
        Method getStagingDirMethod = JobSubmissionFiles.class.getMethod("getStagingDir", jobClient.getClass(), conf.getClass());
        try {
            stagingDirPath = (Path)getStagingDirMethod.invoke(null, jobClient, conf);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException(iae);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite);
        }
        return stagingDirPath;
    }

    private static Path getStagingDirFromMR2(Configuration conf) {
        Path stagingDirPath = null;
        try {
            Class<?> clusterClass = Class.forName("org.apache.hadoop.mapreduce.Cluster");
            Method getStagingDirMethod = JobSubmissionFiles.class.getMethod("getStagingDir", clusterClass, conf.getClass());
            Constructor<?> ctr = clusterClass.getConstructor(conf.getClass());
            Object clusterInstance = ctr.newInstance(conf);
            stagingDirPath = (Path)getStagingDirMethod.invoke(null, clusterInstance, conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (SecurityException se) {
            throw new IllegalStateException(se);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException(iae);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite);
        }
        return stagingDirPath;
    }
}

