/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class SmartChineseAnalyzer
extends Analyzer {
    private final CharArraySet stopWords;
    private static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORD_FILE_COMMENT = "//";
    private final Version matchVersion;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SmartChineseAnalyzer(Version matchVersion) {
        this(matchVersion, true);
    }

    public SmartChineseAnalyzer(Version matchVersion, boolean useDefaultStopWords) {
        this.stopWords = useDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : CharArraySet.EMPTY_SET;
        this.matchVersion = matchVersion;
    }

    public SmartChineseAnalyzer(Version matchVersion, CharArraySet stopWords) {
        this.stopWords = stopWords == null ? CharArraySet.EMPTY_SET : stopWords;
        this.matchVersion = matchVersion;
    }

    public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        SentenceTokenizer tokenizer = new SentenceTokenizer(reader);
        WordTokenFilter result = new WordTokenFilter((TokenStream)tokenizer);
        result = new PorterStemFilter((TokenStream)result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static CharArraySet loadDefaultStopWordSet() throws IOException {
            return CharArraySet.unmodifiableSet((CharArraySet)WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader(SmartChineseAnalyzer.class, (String)SmartChineseAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)IOUtils.CHARSET_UTF_8), (String)SmartChineseAnalyzer.STOPWORD_FILE_COMMENT, (Version)Version.LUCENE_CURRENT));
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

