/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.lucene.spatial.tier.DistanceFilter;

@Deprecated
public class LatLongDistanceFilter
extends DistanceFilter {
    private static final long serialVersionUID = 1L;
    double lat;
    double lng;
    String latField;
    String lngField;
    int nextOffset = 0;

    public LatLongDistanceFilter(Filter startingFilter, double lat, double lng, double miles, String latField, String lngField) {
        super(startingFilter, miles);
        this.lat = lat;
        this.lng = lng;
        this.latField = latField;
        this.lngField = lngField;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final double[] latIndex = FieldCache.DEFAULT.getDoubles(reader, this.latField);
        final double[] lngIndex = FieldCache.DEFAULT.getDoubles(reader, this.lngField);
        final int docBase = this.nextDocBase;
        this.nextDocBase += reader.maxDoc();
        return new FilteredDocIdSet(this.startingFilter.getDocIdSet(reader)){

            protected boolean match(int doc) {
                double d;
                double x = latIndex[doc];
                double y = lngIndex[doc];
                String ck = Double.toString(x) + "," + Double.toString(y);
                Double cachedDistance = (Double)LatLongDistanceFilter.this.distanceLookupCache.get(ck);
                if (cachedDistance != null) {
                    d = cachedDistance;
                } else {
                    d = DistanceUtils.getDistanceMi(LatLongDistanceFilter.this.lat, LatLongDistanceFilter.this.lng, x, y);
                    LatLongDistanceFilter.this.distanceLookupCache.put(ck, d);
                }
                if (d < LatLongDistanceFilter.this.distance) {
                    LatLongDistanceFilter.this.distances.put(doc + docBase, d);
                    return true;
                }
                return false;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLongDistanceFilter)) {
            return false;
        }
        LatLongDistanceFilter other = (LatLongDistanceFilter)((Object)o);
        return this.startingFilter.equals(other.startingFilter) && this.distance == other.distance && this.lat == other.lat && this.lng == other.lng && this.latField.equals(other.latField) && this.lngField.equals(other.lngField);
    }

    public int hashCode() {
        int h = Double.valueOf(this.distance).hashCode();
        h ^= this.startingFilter.hashCode();
        h ^= Double.valueOf(this.lat).hashCode();
        h ^= Double.valueOf(this.lng).hashCode();
        h ^= this.latField.hashCode();
        return h ^= this.lngField.hashCode();
    }
}

