/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.function;

import org.apache.mahout.math.function.BinaryFunction;

public final class PlusMult
implements BinaryFunction {
    private double multiplicator;

    public PlusMult(double multiplicator) {
        this.multiplicator = multiplicator;
    }

    public double apply(double a, double b) {
        return a + b * this.multiplicator;
    }

    public static PlusMult minusDiv(double constant) {
        return new PlusMult(-1.0 / constant);
    }

    public static PlusMult minusMult(double constant) {
        return new PlusMult(-constant);
    }

    public static PlusMult plusDiv(double constant) {
        return new PlusMult(1.0 / constant);
    }

    public static PlusMult plusMult(double constant) {
        return new PlusMult(constant);
    }

    public double getMultiplicator() {
        return this.multiplicator;
    }

    public void setMultiplicator(double multiplicator) {
        this.multiplicator = multiplicator;
    }
}

