/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat.quantile;

import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.jet.stat.quantile.BufferSet;
import org.apache.mahout.math.jet.stat.quantile.DoubleBuffer;

class DoubleBufferSet
extends BufferSet {
    protected DoubleBuffer[] buffers;
    private boolean nextTriggerCalculationState;

    DoubleBufferSet(int b, int k) {
        this.buffers = new DoubleBuffer[b];
        this.clear(k);
    }

    public DoubleBuffer _getFirstEmptyBuffer() {
        DoubleBuffer emptyBuffer = null;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isEmpty()) continue;
            if (this.buffers[i].isAllocated()) {
                return this.buffers[i];
            }
            emptyBuffer = this.buffers[i];
        }
        return emptyBuffer;
    }

    public DoubleBuffer[] _getFullOrPartialBuffers() {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty()) continue;
            ++count;
        }
        DoubleBuffer[] collectedBuffers = new DoubleBuffer[count];
        int j = 0;
        int i2 = this.buffers.length;
        while (--i2 >= 0) {
            if (this.buffers[i2].isEmpty()) continue;
            collectedBuffers[j++] = this.buffers[i2];
        }
        return collectedBuffers;
    }

    public DoubleBuffer[] _getFullOrPartialBuffersWithLevel(int level) {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty() || this.buffers[i].level() != level) continue;
            ++count;
        }
        DoubleBuffer[] collectedBuffers = new DoubleBuffer[count];
        int j = 0;
        int i2 = this.buffers.length;
        while (--i2 >= 0) {
            if (this.buffers[i2].isEmpty() || this.buffers[i2].level() != level) continue;
            collectedBuffers[j++] = this.buffers[i2];
        }
        return collectedBuffers;
    }

    public int _getMinLevelOfFullOrPartialBuffers() {
        int b = this.b();
        int minLevel = Integer.MAX_VALUE;
        for (int i = 0; i < b; ++i) {
            DoubleBuffer buffer = this.buffers[i];
            if (buffer.isEmpty() || buffer.level() >= minLevel) continue;
            minLevel = buffer.level();
        }
        return minLevel;
    }

    public int _getNumberOfEmptyBuffers() {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public DoubleBuffer _getPartialBuffer() {
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isPartial()) continue;
            return this.buffers[i];
        }
        return null;
    }

    public int b() {
        return this.buffers.length;
    }

    public void clear() {
        this.clear(this.k());
    }

    protected void clear(int k) {
        int i = this.b();
        while (--i >= 0) {
            this.buffers[i] = new DoubleBuffer(k);
        }
        this.nextTriggerCalculationState = true;
    }

    public Object clone() {
        DoubleBufferSet copy = (DoubleBufferSet)((Object)super.clone());
        copy.buffers = (DoubleBuffer[])copy.buffers.clone();
        int i = this.buffers.length;
        while (--i >= 0) {
            copy.buffers[i] = (DoubleBuffer)((Object)copy.buffers[i].clone());
        }
        return copy;
    }

    public DoubleBuffer collapse(DoubleBuffer[] buffers) {
        int W = 0;
        for (DoubleBuffer buffer : buffers) {
            W += buffer.weight();
        }
        int k = this.k();
        long[] triggerPositions = new long[k];
        for (int j = 0; j < k; ++j) {
            triggerPositions[j] = this.nextTriggerPosition(j, W);
        }
        double[] outputValues = DoubleBufferSet.getValuesAtPositions(buffers, triggerPositions);
        for (int b = 1; b < buffers.length; ++b) {
            buffers[b].clear();
        }
        DoubleBuffer outputBuffer = buffers[0];
        outputBuffer.values.elements(outputValues);
        outputBuffer.weight(W);
        return outputBuffer;
    }

    public boolean contains(double element) {
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty() || !this.buffers[i].contains(element)) continue;
            return true;
        }
        return false;
    }

    public boolean forEach(DoubleProcedure procedure) {
        int i = this.buffers.length;
        while (--i >= 0) {
            int w = this.buffers[i].weight();
            while (--w >= 0) {
                if (this.buffers[i].values.forEach(procedure)) continue;
                return false;
            }
        }
        return true;
    }

    protected static double[] getValuesAtPositions(DoubleBuffer[] buffers, long[] triggerPositions) {
        int i = buffers.length;
        while (--i >= 0) {
            buffers[i].sort();
        }
        int[] bufferSizes = new int[buffers.length];
        double[][] bufferValues = new double[buffers.length][];
        int totalBuffersSize = 0;
        int i2 = buffers.length;
        while (--i2 >= 0) {
            bufferSizes[i2] = buffers[i2].size();
            bufferValues[i2] = buffers[i2].values.elements();
            totalBuffersSize += bufferSizes[i2];
        }
        int buffersSize = buffers.length;
        int triggerPositionsLength = triggerPositions.length;
        int j = 0;
        int[] cursors = new int[buffers.length];
        long nextHit = triggerPositions[j];
        double[] outputValues = new double[triggerPositionsLength];
        if (totalBuffersSize == 0) {
            for (int i3 = 0; i3 < triggerPositions.length; ++i3) {
                outputValues[i3] = Double.NaN;
            }
            return outputValues;
        }
        long counter = 0L;
        while (j < triggerPositionsLength) {
            double minValue = Double.POSITIVE_INFINITY;
            int minBufferIndex = -1;
            int b = buffersSize;
            while (--b >= 0) {
                double value;
                if (cursors[b] >= bufferSizes[b] || !((value = bufferValues[b][cursors[b]]) <= minValue)) continue;
                minValue = value;
                minBufferIndex = b;
            }
            DoubleBuffer minBuffer = buffers[minBufferIndex];
            counter += (long)minBuffer.weight();
            while (counter > nextHit && j < triggerPositionsLength) {
                outputValues[j++] = minValue;
                if (j >= triggerPositionsLength) continue;
                nextHit = triggerPositions[j];
            }
            int n = minBufferIndex;
            cursors[n] = cursors[n] + 1;
        }
        return outputValues;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long memory = 0L;
        int i = this.buffers.length;
        while (--i >= 0) {
            memory += (long)this.buffers[i].memory();
        }
        return memory;
    }

    protected long nextTriggerPosition(int j, long W) {
        long nextTriggerPosition = W % 2L != 0L ? (long)j * W + (W + 1L) / 2L : (this.nextTriggerCalculationState ? (long)j * W + W / 2L : (long)j * W + (W + 2L) / 2L);
        return nextTriggerPosition;
    }

    public double phi(double element) {
        double elementsLessThanOrEqualToElement = 0.0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty()) continue;
            elementsLessThanOrEqualToElement += (double)this.buffers[i].weight * this.buffers[i].rank(element);
        }
        return elementsLessThanOrEqualToElement / (double)this.totalSize();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int b = 0; b < this.b(); ++b) {
            if (this.buffers[b].isEmpty()) continue;
            buf.append("buffer#").append(b).append(" = ");
            buf.append(this.buffers[b].toString()).append('\n');
        }
        return buf.toString();
    }

    public long totalSize() {
        DoubleBuffer[] fullBuffers = this._getFullOrPartialBuffers();
        long totalSize = 0L;
        int i = fullBuffers.length;
        while (--i >= 0) {
            totalSize += (long)(fullBuffers[i].size() * fullBuffers[i].weight());
        }
        return totalSize;
    }
}

