/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.matrix.impl.AbstractMatrix;
import org.apache.mahout.math.matrix.impl.AbstractMatrix1D;
import org.apache.mahout.math.matrix.impl.AbstractMatrix2D;
import org.apache.mahout.math.matrix.impl.AbstractMatrix3D;
import org.apache.mahout.math.matrix.impl.Former;
import org.apache.mahout.math.matrix.impl.FormerFactory;

@Deprecated
public abstract class AbstractFormatter
extends PersistentObject {
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String DECIMAL = "decimal";
    private static final int DEFAULT_MIN_COLUMN_WIDTH = 1;
    private static final String DEFAULT_COLUMN_SEPARATOR = " ";
    private static final String DEFAULT_ROW_SEPARATOR = "\n";
    private static final String DEFAULT_SLICE_SEPARATOR = "\n\n";
    protected String alignment = "left";
    protected String format = "%G";
    private int minColumnWidth = 1;
    private String columnSeparator = " ";
    protected String rowSeparator = "\n";
    protected String sliceSeparator = "\n\n";
    protected boolean printShape = true;
    private static String[] blanksCache;
    private static final FormerFactory factory;

    protected AbstractFormatter() {
    }

    protected void align(String[][] strings) {
        int rows = strings.length;
        int columns = 0;
        if (rows > 0) {
            columns = strings[0].length;
        }
        int[] maxColWidth = new int[columns];
        int[] maxColLead = null;
        boolean isDecimal = this.alignment.equals(DECIMAL);
        if (isDecimal) {
            maxColLead = new int[columns];
        }
        for (int column = 0; column < columns; ++column) {
            int maxWidth = this.minColumnWidth;
            int maxLead = Integer.MIN_VALUE;
            for (int row = 0; row < rows; ++row) {
                String s = strings[row][column];
                maxWidth = Math.max(maxWidth, s.length());
                if (!isDecimal) continue;
                maxLead = Math.max(maxLead, this.lead(s));
            }
            maxColWidth[column] = maxWidth;
            if (!isDecimal) continue;
            maxColLead[column] = maxLead;
        }
        for (int row = 0; row < rows; ++row) {
            this.alignRow(strings[row], maxColWidth, maxColLead);
        }
    }

    protected static int alignmentCode(String alignment) {
        if (alignment.equals(LEFT)) {
            return -1;
        }
        if (alignment.equals(CENTER)) {
            return 0;
        }
        if (alignment.equals(RIGHT)) {
            return 1;
        }
        if (alignment.equals(DECIMAL)) {
            return 2;
        }
        throw new IllegalArgumentException("unknown alignment: " + alignment);
    }

    protected void alignRow(String[] row, int[] maxColWidth, int[] maxColLead) {
        StringBuilder s = new StringBuilder();
        int columns = row.length;
        for (int column = 0; column < columns; ++column) {
            s.setLength(0);
            String c = row[column];
            if (this.alignment.equals(RIGHT)) {
                s.append(AbstractFormatter.blanks(maxColWidth[column] - s.length()));
                s.append(c);
            } else if (this.alignment.equals(DECIMAL)) {
                s.append(AbstractFormatter.blanks(maxColLead[column] - this.lead(c)));
                s.append(c);
                s.append(AbstractFormatter.blanks(maxColWidth[column] - s.length()));
            } else if (this.alignment.equals(CENTER)) {
                s.append(AbstractFormatter.blanks((maxColWidth[column] - c.length()) / 2));
                s.append(c);
                s.append(AbstractFormatter.blanks(maxColWidth[column] - s.length()));
            } else if (this.alignment.equals(LEFT)) {
                s.append(c);
                s.append(AbstractFormatter.blanks(maxColWidth[column] - s.length()));
            } else {
                throw new InternalError();
            }
            row[column] = s.toString();
        }
    }

    protected static String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        if (length < blanksCache.length) {
            return blanksCache[length];
        }
        StringBuilder buf = new StringBuilder(length);
        for (int k = 0; k < length; ++k) {
            buf.append(' ');
        }
        return buf.toString();
    }

    protected abstract String form(AbstractMatrix1D var1, int var2, Former var3);

    protected abstract String[][] format(AbstractMatrix2D var1);

    protected String[] formatRow(AbstractMatrix1D vector) {
        Former formatter = factory.create(this.format);
        int s = vector.size();
        String[] strings = new String[s];
        for (int i = 0; i < s; ++i) {
            strings[i] = this.form(vector, i, formatter);
        }
        return strings;
    }

    protected int lead(String s) {
        return s.length();
    }

    protected String repeat(char character, int length) {
        if (character == ' ') {
            return AbstractFormatter.blanks(length);
        }
        if (length < 0) {
            length = 0;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int k = 0; k < length; ++k) {
            buf.append(character);
        }
        return buf.toString();
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setMinColumnWidth(int minColumnWidth) {
        if (minColumnWidth < 0) {
            throw new IllegalArgumentException();
        }
        this.minColumnWidth = minColumnWidth;
    }

    public void setPrintShape(boolean printShape) {
        this.printShape = printShape;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public void setSliceSeparator(String sliceSeparator) {
        this.sliceSeparator = sliceSeparator;
    }

    private static void setupBlanksCache() {
        int size = 40;
        blanksCache = new String[size];
        StringBuilder buf = new StringBuilder(size);
        int i = size;
        while (--i >= 0) {
            buf.append(' ');
        }
        String str = buf.toString();
        int i2 = size;
        while (--i2 >= 0) {
            AbstractFormatter.blanksCache[i2] = str.substring(0, i2);
        }
    }

    public static String shape(AbstractMatrix matrix) {
        return matrix.size() + " matrix";
    }

    public static String shape(AbstractMatrix2D matrix) {
        return matrix.rows() + " x " + matrix.columns() + " matrix";
    }

    public static String shape(AbstractMatrix3D matrix) {
        return matrix.slices() + " x " + matrix.rows() + " x " + matrix.columns() + " matrix";
    }

    protected String toString(String[][] strings) {
        int rows = strings.length;
        int columns = strings.length <= 0 ? 0 : strings[0].length;
        StringBuilder total = new StringBuilder();
        StringBuilder s = new StringBuilder();
        for (int row = 0; row < rows; ++row) {
            s.setLength(0);
            for (int column = 0; column < columns; ++column) {
                s.append(strings[row][column]);
                if (column >= columns - 1) continue;
                s.append(this.columnSeparator);
            }
            total.append((CharSequence)s);
            if (row >= rows - 1) continue;
            total.append(this.rowSeparator);
        }
        return total.toString();
    }

    protected String toString(AbstractMatrix2D matrix) {
        String[][] strings = this.format(matrix);
        this.align(strings);
        StringBuilder total = new StringBuilder(this.toString(strings));
        if (this.printShape) {
            total.insert(0, AbstractFormatter.shape(matrix) + '\n');
        }
        return total.toString();
    }

    static {
        factory = new FormerFactory();
        AbstractFormatter.setupBlanksCache();
    }
}

