/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonTags;
import org.apache.oozie.client.rest.JsonToBean;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OozieClient {
    public static final long WS_PROTOCOL_VERSION_0 = 0L;
    public static final long WS_PROTOCOL_VERSION = 1L;
    public static final String USER_NAME = "user.name";
    @Deprecated
    public static final String GROUP_NAME = "group.name";
    public static final String JOB_ACL = "oozie.job.acl";
    public static final String APP_PATH = "oozie.wf.application.path";
    public static final String COORDINATOR_APP_PATH = "oozie.coord.application.path";
    public static final String BUNDLE_APP_PATH = "oozie.bundle.application.path";
    public static final String BUNDLE_ID = "oozie.bundle.id";
    public static final String EXTERNAL_ID = "oozie.wf.external.id";
    public static final String WORKFLOW_NOTIFICATION_URL = "oozie.wf.workflow.notification.url";
    public static final String ACTION_NOTIFICATION_URL = "oozie.wf.action.notification.url";
    public static final String COORD_ACTION_NOTIFICATION_URL = "oozie.coord.action.notification.url";
    public static final String RERUN_SKIP_NODES = "oozie.wf.rerun.skip.nodes";
    public static final String RERUN_FAIL_NODES = "oozie.wf.rerun.failnodes";
    public static final String LOG_TOKEN = "oozie.wf.log.token";
    public static final String ACTION_MAX_RETRIES = "oozie.wf.action.max.retries";
    public static final String ACTION_RETRY_INTERVAL = "oozie.wf.action.retry.interval";
    public static final String FILTER_USER = "user";
    public static final String FILTER_GROUP = "group";
    public static final String FILTER_NAME = "name";
    public static final String FILTER_STATUS = "status";
    public static final String FILTER_FREQUENCY = "frequency";
    public static final String FILTER_ID = "id";
    public static final String FILTER_UNIT = "unit";
    public static final String CHANGE_VALUE_ENDTIME = "endtime";
    public static final String CHANGE_VALUE_PAUSETIME = "pausetime";
    public static final String CHANGE_VALUE_CONCURRENCY = "concurrency";
    public static final String LIBPATH = "oozie.libpath";
    public static final String USE_SYSTEM_LIBPATH = "oozie.use.system.libpath";
    public int debugMode = 0;
    private String baseUrl;
    private String protocolUrl;
    private boolean validatedVersion = false;
    private final Map<String, String> headers = new HashMap<String, String>();
    private static ThreadLocal<String> USER_NAME_TL = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(String userName, Callable<T> callable) throws Exception {
        OozieClient.notEmpty(userName, "userName");
        OozieClient.notNull(callable, "callable");
        try {
            USER_NAME_TL.set(userName);
            T t = callable.call();
            return t;
        }
        finally {
            USER_NAME_TL.remove();
        }
    }

    protected OozieClient() {
    }

    public OozieClient(String oozieUrl) {
        this.baseUrl = OozieClient.notEmpty(oozieUrl, "oozieUrl");
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public String getOozieUrl() {
        return this.baseUrl;
    }

    public String getProtocolUrl() throws OozieClientException {
        this.validateWSVersion();
        return this.protocolUrl;
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(int debugMode) {
        this.debugMode = debugMode;
    }

    public synchronized void validateWSVersion() throws OozieClientException {
        if (!this.validatedVersion) {
            try {
                URL url = new URL(this.baseUrl + "versions");
                HttpURLConnection conn = this.createConnection(url, "GET");
                if (conn.getResponseCode() == 200) {
                    JSONArray array = (JSONArray)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                    if (array == null) {
                        throw new OozieClientException("HTTP error", "no response message");
                    }
                    if (!array.contains((Object)1L) && !array.contains((Object)0L)) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Supported version [").append(1L).append("] or less, Unsupported versions[");
                        String separator = "";
                        for (Object version : array) {
                            msg.append(separator).append(version);
                        }
                        msg.append("]");
                        throw new OozieClientException("UNSUPPORTED_VERSION", msg.toString());
                    }
                    if (array.contains((Object)1L)) {
                        this.protocolUrl = this.baseUrl + "v" + 1L + "/";
                    } else if (array.contains((Object)0L)) {
                        this.protocolUrl = this.baseUrl + "v" + 0L + "/";
                    }
                } else {
                    OozieClient.handleError(conn);
                }
            }
            catch (IOException ex) {
                throw new OozieClientException("IO_ERROR", ex);
            }
            this.validatedVersion = true;
        }
    }

    public Properties createConfiguration() {
        Properties conf = new Properties();
        String userName = USER_NAME_TL.get();
        if (userName == null) {
            userName = System.getProperty(USER_NAME);
        }
        conf.setProperty(USER_NAME, userName);
        return conf;
    }

    public void setHeader(String name, String value) {
        this.headers.put(OozieClient.notEmpty(name, FILTER_NAME), OozieClient.notNull(value, "value"));
    }

    public String getHeader(String name) {
        return this.headers.get(OozieClient.notEmpty(name, FILTER_NAME));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void removeHeader(String name) {
        this.headers.remove(OozieClient.notEmpty(name, FILTER_NAME));
    }

    public Iterator<String> getHeaderNames() {
        return Collections.unmodifiableMap(this.headers).keySet().iterator();
    }

    private URL createURL(String collection, String resource, Map<String, String> parameters) throws IOException, OozieClientException {
        this.validateWSVersion();
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocolUrl).append(collection);
        if (resource != null && resource.length() > 0) {
            sb.append("/").append(resource);
        }
        if (parameters.size() > 0) {
            String separator = "?";
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                if (param.getValue() == null) continue;
                sb.append(separator).append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                separator = "&";
            }
        }
        return new URL(sb.toString());
    }

    private boolean validateCommand(String url) {
        return !this.protocolUrl.contains(this.baseUrl + "v0") || !url.contains("dryrun") && !url.contains("jobtype=c") && !url.contains("systemmode");
    }

    protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        if (method.equals("POST") || method.equals("PUT")) {
            conn.setDoOutput(true);
        }
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    static void handleError(HttpURLConnection conn) throws IOException, OozieClientException {
        int status = conn.getResponseCode();
        String error = conn.getHeaderField("oozie-error-code");
        String message = conn.getHeaderField("oozie-error-message");
        if (error == null) {
            error = "HTTP error code: " + status;
        }
        if (message == null) {
            message = conn.getResponseMessage();
        }
        throw new OozieClientException(error, message);
    }

    static Map<String, String> prepareParams(String ... params) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            map.put(params[i], params[i + 1]);
        }
        String doAsUserName = USER_NAME_TL.get();
        if (doAsUserName != null) {
            map.put("doAs", doAsUserName);
        }
        return map;
    }

    public void writeToXml(Properties props, OutputStream out) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = props.get(name);
                if (!(object instanceof String)) continue;
                String value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement(FILTER_NAME);
                nameNode.appendChild(doc.createTextNode(name.trim()));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value.trim()));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String submit(Properties conf) throws OozieClientException {
        return (String)new JobSubmit(conf, false).call();
    }

    public String dryrun(Properties conf) throws OozieClientException {
        return (String)new JobSubmit(conf, "dryrun").call();
    }

    public void start(String jobId) throws OozieClientException {
        new JobAction(jobId, "start").call();
    }

    public String run(Properties conf) throws OozieClientException {
        return (String)new JobSubmit(conf, true).call();
    }

    public void reRun(String jobId, Properties conf) throws OozieClientException {
        new JobSubmit(jobId, conf).call();
    }

    public void suspend(String jobId) throws OozieClientException {
        new JobAction(jobId, "suspend").call();
    }

    public void resume(String jobId) throws OozieClientException {
        new JobAction(jobId, "resume").call();
    }

    public void kill(String jobId) throws OozieClientException {
        new JobAction(jobId, "kill").call();
    }

    public void change(String jobId, String changeValue) throws OozieClientException {
        new JobAction(jobId, "change", changeValue).call();
    }

    public WorkflowJob getJobInfo(String jobId) throws OozieClientException {
        return this.getJobInfo(jobId, 0, 0);
    }

    public WorkflowJob getJobInfo(String jobId, int start, int len) throws OozieClientException {
        return (WorkflowJob)new JobInfo(jobId, start, len).call();
    }

    public WorkflowAction getWorkflowActionInfo(String actionId) throws OozieClientException {
        return (WorkflowAction)new WorkflowActionInfo(actionId).call();
    }

    public String getJobLog(String jobId) throws OozieClientException {
        return (String)new JobLog(jobId).call();
    }

    public void getJobLog(String jobId, String logRetrievalType, String logRetrievalScope, PrintStream ps) throws OozieClientException {
        new JobLog(jobId, logRetrievalType, logRetrievalScope, ps).call();
    }

    public String getJobDefinition(String jobId) throws OozieClientException {
        return (String)new JobDefinition(jobId).call();
    }

    public BundleJob getBundleJobInfo(String jobId) throws OozieClientException {
        return (BundleJob)new BundleJobInfo(jobId).call();
    }

    public CoordinatorJob getCoordJobInfo(String jobId) throws OozieClientException {
        return (CoordinatorJob)new CoordJobInfo(jobId, null, 0, 0).call();
    }

    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len) throws OozieClientException {
        return (CoordinatorJob)new CoordJobInfo(jobId, filter, start, len).call();
    }

    public CoordinatorAction getCoordActionInfo(String actionId) throws OozieClientException {
        return (CoordinatorAction)new CoordActionInfo(actionId).call();
    }

    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return (List)new CoordRerun(jobId, rerunType, scope, refresh, noCleanup).call();
    }

    public Void reRunBundle(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return (Void)new BundleRerun(jobId, coordScope, dateScope, refresh, noCleanup).call();
    }

    public List<WorkflowJob> getJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new JobsStatus(filter, start, len).call();
    }

    public List<WorkflowJob> getJobsInfo(String filter) throws OozieClientException {
        return this.getJobsInfo(filter, 1, 50);
    }

    public void getSlaInfo(int start, int len) throws OozieClientException {
        new SlaInfo(start, len).call();
    }

    public String getJobId(String externalId) throws OozieClientException {
        return (String)new JobIdAction(externalId).call();
    }

    public void setSystemMode(SYSTEM_MODE status) throws OozieClientException {
        new SetSystemMode(status).call();
    }

    public SYSTEM_MODE getSystemMode() throws OozieClientException {
        return (SYSTEM_MODE)((Object)new GetSystemMode().call());
    }

    public String getServerBuildVersion() throws OozieClientException {
        return (String)new GetBuildVersion().call();
    }

    public String getClientBuildVersion() {
        return BuildInfo.getBuildInfo().getProperty("build.version");
    }

    public List<CoordinatorJob> getCoordJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new CoordJobsStatus(filter, start, len).call();
    }

    public List<BundleJob> getBundleJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new BundleJobsStatus(filter, start, len).call();
    }

    public List<String> getQueueDump() throws OozieClientException {
        return (List)new GetQueueDump().call();
    }

    public static String notEmpty(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return str;
    }

    public static <T> T notNull(T obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return obj;
    }

    private class GetQueueDump
    extends ClientCallable<List<String>> {
        GetQueueDump() {
            super("GET", "admin", "queue-dump", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected List<String> call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray queueDumpArray = (JSONArray)json.get((Object)"queueDump");
                ArrayList<String> list = new ArrayList<String>();
                list.add("[Server Queue Dump]:");
                for (Object o : queueDumpArray) {
                    JSONObject entry = (JSONObject)o;
                    if (entry.get((Object)"callableDump") == null) continue;
                    String value = (String)entry.get((Object)"callableDump");
                    list.add(value);
                }
                if (queueDumpArray.size() == 0) {
                    list.add("Queue dump is null!");
                }
                list.add("******************************************");
                list.add("[Server Uniqueness Map Dump]:");
                JSONArray uniqueDumpArray = (JSONArray)json.get((Object)"uniqueMapDump");
                for (Object o : uniqueDumpArray) {
                    JSONObject entry = (JSONObject)o;
                    if (entry.get((Object)"uniqueEntryDump") == null) continue;
                    String value = (String)entry.get((Object)"uniqueEntryDump");
                    list.add(value);
                }
                if (uniqueDumpArray.size() == 0) {
                    list.add("Uniqueness dump is null!");
                }
                return list;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class GetBuildVersion
    extends ClientCallable<String> {
        GetBuildVersion() {
            super("GET", "admin", "build-version", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)"buildVersion");
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class GetSystemMode
    extends ClientCallable<SYSTEM_MODE> {
        GetSystemMode() {
            super("GET", "admin", OozieClient.FILTER_STATUS, OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected SYSTEM_MODE call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return SYSTEM_MODE.valueOf((String)json.get((Object)"systemMode"));
            }
            OozieClient.handleError(conn);
            return SYSTEM_MODE.NORMAL;
        }
    }

    private class SetSystemMode
    extends ClientCallable<Void> {
        public SetSystemMode(SYSTEM_MODE status) {
            super("PUT", "admin", OozieClient.FILTER_STATUS, OozieClient.prepareParams("systemmode", (Object)((Object)status) + ""));
        }

        @Override
        public Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class JobIdAction
    extends ClientCallable<String> {
        JobIdAction(String externalId) {
            super("GET", "jobs", "", OozieClient.prepareParams("jobtype", "wf", "external-id", externalId));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)OozieClient.FILTER_ID);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class SlaInfo
    extends ClientCallable<Void> {
        SlaInfo(int start, int len) {
            super("GET", "sla", "", OozieClient.prepareParams("gt-sequence-id", Integer.toString(start), "max-events", Integer.toString(len)));
        }

        @Override
        protected Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            } else {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class BundleRerun
    extends ClientCallable<Void> {
        BundleRerun(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "bundle-rerun", "coord-scope", coordScope, "date-scope", dateScope, "refresh", Boolean.toString(refresh), "nocleanup", Boolean.toString(noCleanup)));
        }

        @Override
        protected Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                return null;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordRerun
    extends ClientCallable<List<CoordinatorAction>> {
        CoordRerun(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "coord-rerun", "type", rerunType, "scope", scope, "refresh", Boolean.toString(refresh), "nocleanup", Boolean.toString(noCleanup)));
        }

        @Override
        protected List<CoordinatorAction> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray coordActions = (JSONArray)json.get((Object)"actions");
                return JsonToBean.createCoordinatorActionList(coordActions);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class BundleJobsStatus
    extends ClientCallable<List<BundleJob>> {
        BundleJobsStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("filter", filter, "jobtype", "bundle", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<BundleJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray jobs = (JSONArray)json.get(JsonTags.BUNDLE_JOBS);
                if (jobs == null) {
                    jobs = new JSONArray();
                }
                return JsonToBean.createBundleJobList(jobs);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordJobsStatus
    extends ClientCallable<List<CoordinatorJob>> {
        CoordJobsStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("filter", filter, "jobtype", "coord", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<CoordinatorJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray jobs = (JSONArray)json.get(JsonTags.COORDINATOR_JOBS);
                if (jobs == null) {
                    jobs = new JSONArray();
                }
                return JsonToBean.createCoordinatorJobList(jobs);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobsStatus
    extends ClientCallable<List<WorkflowJob>> {
        JobsStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("filter", filter, "jobtype", "wf", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<WorkflowJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray workflows = (JSONArray)json.get((Object)"workflows");
                if (workflows == null) {
                    workflows = new JSONArray();
                }
                return JsonToBean.createWorkflowJobList(workflows);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordActionInfo
    extends ClientCallable<CoordinatorAction> {
        CoordActionInfo(String actionId) {
            super("GET", "job", OozieClient.notEmpty(actionId, OozieClient.FILTER_ID), OozieClient.prepareParams("show", "info"));
        }

        @Override
        protected CoordinatorAction call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createCoordinatorAction(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class BundleJobInfo
    extends ClientCallable<BundleJob> {
        BundleJobInfo(String jobId) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "info"));
        }

        @Override
        protected BundleJob call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createBundleJob(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordJobInfo
    extends ClientCallable<CoordinatorJob> {
        CoordJobInfo(String jobId, String filter, int start, int len) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "info", "filter", filter, "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected CoordinatorJob call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createCoordinatorJob(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobMetadata
    extends ClientCallable<String> {
        PrintStream printStream;

        JobMetadata(String jobId, String metaType) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", metaType));
        }

        JobMetadata(String jobId, String logRetrievalType, String logRetrievalScope, String metaType, PrintStream ps) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", metaType, "type", logRetrievalType, "scope", logRetrievalScope));
            this.printStream = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            String returnVal = null;
            if (conn.getResponseCode() == 200) {
                InputStream is = conn.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                try {
                    if (this.printStream != null) {
                        this.sendToOutputStream(isr, -1);
                    }
                    returnVal = this.getReaderAsString(isr, -1);
                }
                finally {
                    isr.close();
                }
            } else {
                OozieClient.handleError(conn);
            }
            return returnVal;
        }

        private void sendToOutputStream(Reader reader, int maxLen) throws IOException {
            int read;
            if (reader == null) {
                throw new IllegalArgumentException("reader cannot be null");
            }
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[2048];
            int count = 0;
            int noOfCharstoFlush = 1024;
            while ((read = reader.read(buffer)) > -1 && (maxLen <= -1 || (count += read) <= maxLen)) {
                sb.append(buffer, 0, read);
                if (sb.length() <= noOfCharstoFlush) continue;
                this.printStream.print(sb.toString());
                sb = new StringBuilder("");
            }
            this.printStream.print(sb.toString());
        }

        private String getReaderAsString(Reader reader, int maxLen) throws IOException {
            int read;
            if (reader == null) {
                throw new IllegalArgumentException("reader cannot be null");
            }
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[2048];
            int count = 0;
            while ((read = reader.read(buffer)) > -1 && (maxLen <= -1 || (count += read) <= maxLen)) {
                sb.append(buffer, 0, read);
            }
            reader.close();
            return sb.toString();
        }
    }

    private class JobDefinition
    extends JobMetadata {
        JobDefinition(String jobId) {
            super(jobId, "definition");
        }
    }

    private class JobLog
    extends JobMetadata {
        JobLog(String jobId) {
            super(jobId, "log");
        }

        JobLog(String jobId, String logRetrievalType, String logRetrievalScope, PrintStream ps) {
            super(jobId, logRetrievalType, logRetrievalScope, "log", ps);
        }
    }

    private class WorkflowActionInfo
    extends ClientCallable<WorkflowAction> {
        WorkflowActionInfo(String actionId) {
            super("GET", "job", OozieClient.notEmpty(actionId, OozieClient.FILTER_ID), OozieClient.prepareParams("show", "info"));
        }

        @Override
        protected WorkflowAction call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createWorkflowAction(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobInfo
    extends ClientCallable<WorkflowJob> {
        JobInfo(String jobId, int start, int len) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "info", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected WorkflowJob call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createWorkflowJob(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobAction
    extends ClientCallable<Void> {
        JobAction(String jobId, String action) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", action));
        }

        JobAction(String jobId, String action, String params) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", action, "value", params));
        }

        @Override
        protected Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class JobSubmit
    extends ClientCallable<String> {
        private final Properties conf;

        JobSubmit(Properties conf, boolean start) {
            super("POST", "jobs", "", start ? OozieClient.prepareParams("action", "start") : OozieClient.prepareParams(new String[0]));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        JobSubmit(String jobId, Properties conf) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "rerun"));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        public JobSubmit(Properties conf, String jobActionDryrun) {
            super("POST", "jobs", "", OozieClient.prepareParams("action", "dryrun"));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            OozieClient.this.writeToXml(this.conf, conn.getOutputStream());
            if (conn.getResponseCode() == 201) {
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                return (String)json.get((Object)OozieClient.FILTER_ID);
            }
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    protected abstract class ClientCallable<T>
    implements Callable<T> {
        private final String method;
        private final String collection;
        private final String resource;
        private final Map<String, String> params;

        public ClientCallable(String method, String collection, String resource, Map<String, String> params) {
            this.method = method;
            this.collection = collection;
            this.resource = resource;
            this.params = params;
        }

        @Override
        public T call() throws OozieClientException {
            try {
                URL url = OozieClient.this.createURL(this.collection, this.resource, this.params);
                if (OozieClient.this.validateCommand(url.toString())) {
                    if (OozieClient.this.getDebugMode() > 0) {
                        System.out.println("Connection URL:[" + url + "]");
                    }
                    HttpURLConnection conn = OozieClient.this.createConnection(url, this.method);
                    return this.call(conn);
                }
                System.out.println("Option not supported in target server. Supported only on Oozie-2.0 or greater. Use 'oozie help' for details");
                throw new OozieClientException("UNSUPPORTED_VERSION", new Exception());
            }
            catch (IOException ex) {
                throw new OozieClientException("IO_ERROR", ex);
            }
        }

        protected abstract T call(HttpURLConnection var1) throws IOException, OozieClientException;
    }

    public static enum SYSTEM_MODE {
        NORMAL,
        NOWEBSERVICE,
        SAFEMODE;

    }
}

