/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonToBean {
    private static final Map<String, Property> WF_JOB = new HashMap<String, Property>();
    private static final Map<String, Property> WF_ACTION = new HashMap<String, Property>();
    private static final Map<String, Property> COORD_JOB = new HashMap<String, Property>();
    private static final Map<String, Property> COORD_ACTION = new HashMap<String, Property>();
    private static final Map<String, Property> BUNDLE_JOB = new HashMap<String, Property>();

    public static WorkflowAction createWorkflowAction(JSONObject json) {
        return (WorkflowAction)Proxy.newProxyInstance(JsonToBean.class.getClassLoader(), new Class[]{WorkflowAction.class}, (InvocationHandler)new JsonInvocationHandler(WF_ACTION, json));
    }

    public static List<WorkflowAction> createWorkflowActionList(JSONArray json) {
        ArrayList<WorkflowAction> list = new ArrayList<WorkflowAction>();
        for (Object obj : json) {
            list.add(JsonToBean.createWorkflowAction((JSONObject)obj));
        }
        return list;
    }

    public static WorkflowJob createWorkflowJob(JSONObject json) {
        return (WorkflowJob)Proxy.newProxyInstance(JsonToBean.class.getClassLoader(), new Class[]{WorkflowJob.class}, (InvocationHandler)new JsonInvocationHandler(WF_JOB, json));
    }

    public static List<WorkflowJob> createWorkflowJobList(JSONArray json) {
        ArrayList<WorkflowJob> list = new ArrayList<WorkflowJob>();
        for (Object obj : json) {
            list.add(JsonToBean.createWorkflowJob((JSONObject)obj));
        }
        return list;
    }

    public static CoordinatorAction createCoordinatorAction(JSONObject json) {
        return (CoordinatorAction)Proxy.newProxyInstance(JsonToBean.class.getClassLoader(), new Class[]{CoordinatorAction.class}, (InvocationHandler)new JsonInvocationHandler(COORD_ACTION, json));
    }

    public static List<CoordinatorAction> createCoordinatorActionList(JSONArray json) {
        ArrayList<CoordinatorAction> list = new ArrayList<CoordinatorAction>();
        for (Object obj : json) {
            list.add(JsonToBean.createCoordinatorAction((JSONObject)obj));
        }
        return list;
    }

    public static CoordinatorJob createCoordinatorJob(JSONObject json) {
        return (CoordinatorJob)Proxy.newProxyInstance(JsonToBean.class.getClassLoader(), new Class[]{CoordinatorJob.class}, (InvocationHandler)new JsonInvocationHandler(COORD_JOB, json));
    }

    public static List<CoordinatorJob> createCoordinatorJobList(JSONArray json) {
        ArrayList<CoordinatorJob> list = new ArrayList<CoordinatorJob>();
        for (Object obj : json) {
            list.add(JsonToBean.createCoordinatorJob((JSONObject)obj));
        }
        return list;
    }

    public static BundleJob createBundleJob(JSONObject json) {
        return (BundleJob)Proxy.newProxyInstance(JsonToBean.class.getClassLoader(), new Class[]{BundleJob.class}, (InvocationHandler)new JsonInvocationHandler(BUNDLE_JOB, json));
    }

    public static List<BundleJob> createBundleJobList(JSONArray json) {
        ArrayList<BundleJob> list = new ArrayList<BundleJob>();
        for (Object obj : json) {
            list.add(JsonToBean.createBundleJob((JSONObject)obj));
        }
        return list;
    }

    static {
        WF_ACTION.put("getId", new Property("id", String.class));
        WF_ACTION.put("getName", new Property("name", String.class));
        WF_ACTION.put("getType", new Property("type", String.class));
        WF_ACTION.put("getConf", new Property("conf", String.class));
        WF_ACTION.put("getStatus", new Property("status", WorkflowAction.Status.class));
        WF_ACTION.put("getRetries", new Property("retries", Integer.TYPE));
        WF_ACTION.put("getStartTime", new Property("startTime", Date.class));
        WF_ACTION.put("getEndTime", new Property("endTime", Date.class));
        WF_ACTION.put("getTransition", new Property("transition", String.class));
        WF_ACTION.put("getData", new Property("data", String.class));
        WF_ACTION.put("getStats", new Property("stats", String.class));
        WF_ACTION.put("getExternalChildIDs", new Property("externalChildIDs", String.class));
        WF_ACTION.put("getExternalId", new Property("externalId", String.class));
        WF_ACTION.put("getExternalStatus", new Property("externalStatus", String.class));
        WF_ACTION.put("getTrackerUri", new Property("trackerUri", String.class));
        WF_ACTION.put("getConsoleUrl", new Property("consoleUrl", String.class));
        WF_ACTION.put("getErrorCode", new Property("errorCode", String.class));
        WF_ACTION.put("getErrorMessage", new Property("errorMessage", String.class));
        WF_ACTION.put("toString", new Property("toString", String.class));
        WF_JOB.put("getExternalId", new Property("externalId", String.class));
        WF_JOB.put("getAppPath", new Property("appPath", String.class));
        WF_JOB.put("getAppName", new Property("appName", String.class));
        WF_JOB.put("getId", new Property("id", String.class));
        WF_JOB.put("getConf", new Property("conf", String.class));
        WF_JOB.put("getStatus", new Property("status", WorkflowJob.Status.class));
        WF_JOB.put("getLastModifiedTime", new Property("lastModTime", Date.class));
        WF_JOB.put("getCreatedTime", new Property("createdTime", Date.class));
        WF_JOB.put("getStartTime", new Property("createdTime", Date.class));
        WF_JOB.put("getEndTime", new Property("endTime", Date.class));
        WF_JOB.put("getUser", new Property("user", String.class));
        WF_JOB.put("getGroup", new Property("group", String.class));
        WF_JOB.put("getAcl", new Property("acl", String.class));
        WF_JOB.put("getRun", new Property("run", Integer.TYPE));
        WF_JOB.put("getConsoleUrl", new Property("consoleUrl", String.class));
        WF_JOB.put("getActions", new Property("actions", WorkflowAction.class, true));
        WF_JOB.put("getParentId", new Property("parentId", String.class));
        WF_JOB.put("toString", new Property("toString", String.class));
        COORD_ACTION.put("getId", new Property("id", String.class));
        COORD_ACTION.put("getJobId", new Property("coordJobId", String.class));
        COORD_ACTION.put("getActionNumber", new Property("actionNumber", Integer.TYPE));
        COORD_ACTION.put("getCreatedConf", new Property("createdConf", String.class));
        COORD_ACTION.put("getCreatedTime", new Property("createdTime", Date.class));
        COORD_ACTION.put("getNominalTime", new Property("nominalTime", Date.class));
        COORD_ACTION.put("getExternalId", new Property("externalId", String.class));
        COORD_ACTION.put("getStatus", new Property("status", CoordinatorAction.Status.class));
        COORD_ACTION.put("getRunConf", new Property("runConf", String.class));
        COORD_ACTION.put("getLastModifiedTime", new Property("lastModifiedTime", Date.class));
        COORD_ACTION.put("getMissingDependencies", new Property("missingDependencies", String.class));
        COORD_ACTION.put("getExternalStatus", new Property("externalStatus", String.class));
        COORD_ACTION.put("getTrackerUri", new Property("trackerUri", String.class));
        COORD_ACTION.put("getConsoleUrl", new Property("consoleUrl", String.class));
        COORD_ACTION.put("getErrorCode", new Property("errorCode", String.class));
        COORD_ACTION.put("getErrorMessage", new Property("errorMessage", String.class));
        COORD_ACTION.put("toString", new Property("toString", String.class));
        COORD_JOB.put("getAppPath", new Property("coordJobPath", String.class));
        COORD_JOB.put("getAppName", new Property("coordJobName", String.class));
        COORD_JOB.put("getId", new Property("coordJobId", String.class));
        COORD_JOB.put("getConf", new Property("conf", String.class));
        COORD_JOB.put("getStatus", new Property("status", Job.Status.class));
        COORD_JOB.put("getExecutionOrder", new Property("executionPolicy", CoordinatorJob.Execution.class));
        COORD_JOB.put("getFrequency", new Property("frequency", Integer.TYPE));
        COORD_JOB.put("getTimeUnit", new Property("timeUnit", CoordinatorJob.Timeunit.class));
        COORD_JOB.put("getTimeZone", new Property("timeZone", String.class));
        COORD_JOB.put("getConcurrency", new Property("concurrency", Integer.TYPE));
        COORD_JOB.put("getTimeout", new Property("timeOut", Integer.TYPE));
        COORD_JOB.put("getLastActionTime", new Property("lastAction", Date.class));
        COORD_JOB.put("getNextMaterializedTime", new Property("nextMaterializedTime", Date.class));
        COORD_JOB.put("getStartTime", new Property("startTime", Date.class));
        COORD_JOB.put("getEndTime", new Property("endTime", Date.class));
        COORD_JOB.put("getPauseTime", new Property("pauseTime", Date.class));
        COORD_JOB.put("getUser", new Property("user", String.class));
        COORD_JOB.put("getGroup", new Property("group", String.class));
        COORD_JOB.put("getAcl", new Property("acl", String.class));
        COORD_JOB.put("getConsoleUrl", new Property("consoleUrl", String.class));
        COORD_JOB.put("getActions", new Property("actions", CoordinatorAction.class, true));
        COORD_JOB.put("toString", new Property("toString", String.class));
        BUNDLE_JOB.put("getActions", new Property("actions", CoordinatorAction.class, true));
        BUNDLE_JOB.put("getAppPath", new Property("bundleJobPath", String.class));
        BUNDLE_JOB.put("getAppName", new Property("bundleJobName", String.class));
        BUNDLE_JOB.put("getId", new Property("bundleJobId", String.class));
        BUNDLE_JOB.put("getExternalId", new Property("bundleExternalId", String.class));
        BUNDLE_JOB.put("getConf", new Property("conf", String.class));
        BUNDLE_JOB.put("getStatus", new Property("status", Job.Status.class));
        BUNDLE_JOB.put("getTimeUnit", new Property("timeUnit", BundleJob.Timeunit.class));
        BUNDLE_JOB.put("getTimeout", new Property("timeOut", Integer.TYPE));
        BUNDLE_JOB.put("getKickoffTime", new Property("kickoffTime", Date.class));
        BUNDLE_JOB.put("getStartTime", new Property("startTime", Date.class));
        BUNDLE_JOB.put("getEndTime", new Property("endTime", Date.class));
        BUNDLE_JOB.put("getPauseTime", new Property("pauseTime", Date.class));
        BUNDLE_JOB.put("getCreatedTime", new Property("createdTime", Date.class));
        BUNDLE_JOB.put("getUser", new Property("user", String.class));
        BUNDLE_JOB.put("getGroup", new Property("group", String.class));
        BUNDLE_JOB.put("getConsoleUrl", new Property("consoleUrl", String.class));
        BUNDLE_JOB.put("getCoordinators", new Property("bundleCoordJobs", CoordinatorJob.class, true));
        BUNDLE_JOB.put("toString", new Property("toString", String.class));
    }

    private static class JsonInvocationHandler
    implements InvocationHandler {
        private final Map<String, Property> mapping;
        private final JSONObject json;

        public JsonInvocationHandler(Map<String, Property> mapping, JSONObject json) {
            this.mapping = mapping;
            this.json = json;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Property prop = this.mapping.get(method.getName());
            if (prop == null) {
                throw new RuntimeException("Undefined method mapping: " + method.getName());
            }
            if (prop.isList) {
                if (prop.type == WorkflowAction.class) {
                    return JsonToBean.createWorkflowActionList((JSONArray)this.json.get((Object)prop.label));
                }
                if (prop.type == CoordinatorAction.class) {
                    return JsonToBean.createCoordinatorActionList((JSONArray)this.json.get((Object)prop.label));
                }
                if (prop.type == CoordinatorJob.class) {
                    return JsonToBean.createCoordinatorJobList((JSONArray)this.json.get((Object)prop.label));
                }
                throw new RuntimeException("Unsupported list type : " + prop.type.getSimpleName());
            }
            return this.parseType(prop.type, this.json.get((Object)prop.label));
        }

        private Object parseType(Class type, Object obj) {
            if (type == String.class) {
                return obj;
            }
            if (type == Integer.TYPE) {
                return obj != null ? new Integer(((Long)obj).intValue()) : new Integer(0);
            }
            if (type == Long.TYPE) {
                return obj != null ? obj : new Long(0L);
            }
            if (type == Date.class) {
                return JsonUtils.parseDateRfc822((String)obj);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, (String)obj);
            }
            if (type == WorkflowAction.class) {
                return JsonToBean.createWorkflowAction((JSONObject)obj);
            }
            throw new RuntimeException("Unsupported type : " + type.getSimpleName());
        }
    }

    private static class Property {
        String label;
        Class type;
        boolean isList;

        public Property(String label, Class type) {
            this(label, type, false);
        }

        public Property(String label, Class type, boolean isList) {
            this.label = label;
            this.type = type;
            this.isList = isList;
        }
    }
}

