/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.event.jms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.oozie.client.event.jms.JSONMessageDeserializer;
import org.apache.oozie.client.event.jms.MessageDeserializer;
import org.apache.oozie.client.event.message.EventMessage;

public class JMSMessagingUtils {
    private static final String DESERIALIZER_PROP = "oozie.msg.deserializer.";
    private static MessageDeserializer deserializer;
    private static Properties jmsDeserializerInfo;
    private static final String CLIENT_PROPERTIES = "oozie_client.properties";

    public static <T extends EventMessage> T getEventMessage(Message msg) throws IOException, JMSException {
        if (msg == null) {
            throw new IllegalArgumentException("Could not extract EventMessage as JMS message is null");
        }
        if (deserializer == null) {
            String msgFormat = msg.getStringProperty("msgFormat");
            deserializer = JMSMessagingUtils.getDeserializer(msgFormat);
        }
        return deserializer.getEventMessage(msg);
    }

    private static MessageDeserializer getDeserializer(String msgFormat) throws IOException {
        String deserializerString = (String)jmsDeserializerInfo.get(DESERIALIZER_PROP + msgFormat);
        if (deserializerString == null) {
            return new JSONMessageDeserializer();
        }
        try {
            MessageDeserializer msgDeserializer = (MessageDeserializer)Class.forName(deserializerString).newInstance();
            return msgDeserializer;
        }
        catch (Exception cnfe) {
            throw new IllegalArgumentException("Could not access class " + deserializerString, cnfe);
        }
    }

    static {
        InputStream is = JMSMessagingUtils.class.getClassLoader().getResourceAsStream(CLIENT_PROPERTIES);
        if (is == null) {
            System.out.println("Using default JSON Deserializer");
            deserializer = new JSONMessageDeserializer();
        } else {
            jmsDeserializerInfo = new Properties();
            try {
                jmsDeserializerInfo.load(is);
                is.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException("I/O error occured for oozie_client.properties", ioe);
            }
        }
    }
}

