/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.NameSet;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.meta.SourceTracker;

public class Table
extends NameSet
implements Comparable<Object>,
SourceTracker {
    private DBIdentifier _name = DBIdentifier.NULL;
    private DBIdentifier _schemaName = DBIdentifier.NULL;
    private Map<DBIdentifier, Column> _colMap = null;
    private Map<DBIdentifier, Index> _idxMap = null;
    private Collection<ForeignKey> _fkList = null;
    private Collection<Unique> _unqList = null;
    private Schema _schema = null;
    private PrimaryKey _pk = null;
    private File _source = null;
    private int _srcType = 0;
    private Column[] _cols = null;
    private Column[] _autoAssign = null;
    private Column[] _rels = null;
    private ForeignKey[] _fks = null;
    private Index[] _idxs = null;
    private Unique[] _unqs = null;
    private String _comment = null;
    private int _lineNum = 0;
    private int _colNum = 0;
    private boolean _isAssociation = false;
    private QualifiedDBIdentifier _fullPath = null;

    public Table() {
    }

    public Table(String name, Schema schema) {
        this(DBIdentifier.newTable(name), schema);
    }

    public Table(DBIdentifier name, Schema schema) {
        this.setIdentifier(name);
        this.addName(name, true);
        if (schema != null) {
            this.setSchemaIdentifier(schema.getIdentifier());
        }
        this._schema = schema;
    }

    public void setAssociation() {
        this._isAssociation = true;
    }

    public boolean isAssociation() {
        return this._isAssociation;
    }

    void remove() {
        ForeignKey[] fks = this.getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            this.removeForeignKey(fks[i]);
        }
        Index[] idxs = this.getIndexes();
        for (int i = 0; i < idxs.length; ++i) {
            this.removeIndex(idxs[i]);
        }
        Unique[] unqs = this.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            this.removeUnique(unqs[i]);
        }
        this.removePrimaryKey();
        Column[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this.removeColumn(cols[i]);
        }
        this._schema = null;
        this._schemaName = DBIdentifier.NULL;
        this._fullPath = null;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getSchemaName() {
        return this.getSchemaIdentifier().getName();
    }

    public DBIdentifier getSchemaIdentifier() {
        return this._schemaName == null ? DBIdentifier.NULL : this._schemaName;
    }

    public void setSchemaName(String name) {
        this.setSchemaIdentifier(DBIdentifier.newSchema(name));
    }

    public void setSchemaIdentifier(DBIdentifier name) {
        if (this.getSchema() != null) {
            throw new IllegalStateException();
        }
        this._schemaName = name;
        this._fullPath = null;
    }

    public String getName() {
        return this.getIdentifier().getName();
    }

    public DBIdentifier getIdentifier() {
        return this._name == null ? DBIdentifier.NULL : this._name;
    }

    public void setName(String name) {
        this.setIdentifier(DBIdentifier.newTable(name));
    }

    public void setIdentifier(DBIdentifier name) {
        if (this.getSchema() != null) {
            throw new IllegalStateException();
        }
        this._name = name;
        this._fullPath = null;
    }

    public String getFullName() {
        return this.getFullIdentifier().getName();
    }

    public QualifiedDBIdentifier getQualifiedPath() {
        if (this._fullPath == null) {
            this._fullPath = QualifiedDBIdentifier.newPath(this._schemaName, this._name);
        }
        return this._fullPath;
    }

    public DBIdentifier getFullIdentifier() {
        return this.getQualifiedPath().getIdentifier();
    }

    public File getSourceFile() {
        return this._source;
    }

    public Object getSourceScope() {
        return null;
    }

    public int getSourceType() {
        return this._srcType;
    }

    public void setSource(File source, int srcType) {
        this._source = source;
        this._srcType = srcType;
    }

    public String getResourceName() {
        return this.getFullIdentifier().getName();
    }

    public Column[] getColumns() {
        if (this._cols == null) {
            if (this._colMap == null) {
                this._cols = Schemas.EMPTY_COLUMNS;
            } else {
                Column[] cols = new Column[this._colMap.size()];
                Iterator<Column> itr = this._colMap.values().iterator();
                int i = 0;
                while (itr.hasNext()) {
                    cols[i] = itr.next();
                    cols[i].setIndex(i);
                    ++i;
                }
                this._cols = cols;
            }
        }
        return this._cols;
    }

    public Column[] getAutoAssignedColumns() {
        if (this._autoAssign == null) {
            if (this._colMap == null) {
                this._autoAssign = Schemas.EMPTY_COLUMNS;
            } else {
                ArrayList<Column> autos = null;
                Column[] cols = this.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (!cols[i].isAutoAssigned()) continue;
                    if (autos == null) {
                        autos = new ArrayList<Column>(3);
                    }
                    autos.add(cols[i]);
                }
                this._autoAssign = autos == null ? Schemas.EMPTY_COLUMNS : autos.toArray(new Column[autos.size()]);
            }
        }
        return this._autoAssign;
    }

    public Column[] getRelationIdColumns() {
        if (this._rels == null) {
            if (this._colMap == null) {
                this._rels = Schemas.EMPTY_COLUMNS;
            } else {
                ArrayList<Column> rels = null;
                Column[] cols = this.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (!cols[i].isRelationId()) continue;
                    if (rels == null) {
                        rels = new ArrayList<Column>(3);
                    }
                    rels.add(cols[i]);
                }
                this._rels = rels == null ? Schemas.EMPTY_COLUMNS : rels.toArray(new Column[rels.size()]);
            }
        }
        return this._rels;
    }

    public String[] getColumnNames() {
        if (this._colMap == null) {
            return new String[0];
        }
        DBIdentifier[] sNames = this._colMap.keySet().toArray(new DBIdentifier[this._colMap.size()]);
        return DBIdentifier.toStringArray(sNames);
    }

    public Column getColumn(String name) {
        return this.getColumn(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.COLUMN, true));
    }

    public Column getColumn(DBIdentifier name) {
        if (DBIdentifier.isNull(name) || this._colMap == null) {
            return null;
        }
        return this._colMap.get(DBIdentifier.toUpper(name));
    }

    public Column getColumn(DBIdentifier name, boolean create) {
        return this.getColumn(name);
    }

    public boolean containsColumn(String name) {
        return this.containsColumn(DBIdentifier.newColumn(name), null);
    }

    public boolean containsColumn(DBIdentifier name) {
        return this.containsColumn(name, null);
    }

    public boolean containsColumn(String name, DBDictionary dict) {
        if (name == null || this._colMap == null) {
            return false;
        }
        return this.containsColumn(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.COLUMN, true));
    }

    public boolean containsColumn(DBIdentifier name, DBDictionary dict) {
        if (DBIdentifier.isNull(name) || this._colMap == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        return this._colMap.containsKey(sName);
    }

    public boolean containsColumn(Column col) {
        DBIdentifier colName = col.getIdentifier();
        if (DBIdentifier.isNull(colName) || this._colMap == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(colName);
        Collection<Column> coll = this._colMap.values();
        for (Column column : coll) {
            if (!column.getIdentifier().equals(sName)) continue;
            return true;
        }
        return false;
    }

    public Column addColumn(String name) {
        return this.addColumn(DBIdentifier.newColumn(name));
    }

    public Column addColumn(DBIdentifier name) {
        this.addName(name, true);
        Schema schema = this.getSchema();
        Column col = schema != null && schema.getSchemaGroup() != null ? schema.getSchemaGroup().newColumn(name, this) : new Column(name, this);
        if (this._colMap == null) {
            this._colMap = new LinkedHashMap<DBIdentifier, Column>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._colMap.put(sName, col);
        this._cols = null;
        return col;
    }

    public Column addColumn(String name, String validName) {
        return this.addColumn(DBIdentifier.newColumn(name), DBIdentifier.newColumn(validName));
    }

    public Column addColumn(DBIdentifier name, DBIdentifier validName) {
        this.addName(name, true);
        Schema schema = this.getSchema();
        Column col = schema != null && schema.getSchemaGroup() != null ? schema.getSchemaGroup().newColumn(validName, this) : new Column(validName, this);
        if (this._colMap == null) {
            this._colMap = new LinkedHashMap<DBIdentifier, Column>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._colMap.put(sName, col);
        this._cols = null;
        return col;
    }

    public void addCorrectedColumnName(String name, boolean validate) {
        this.addName(DBIdentifier.newColumn(name), validate);
    }

    public void addCorrectedColumnName(DBIdentifier name, boolean validate) {
        this.addName(name, validate);
    }

    public boolean removeColumn(Column col) {
        if (col == null || this._colMap == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(col.getIdentifier());
        Column cur = this._colMap.get(sName);
        if (!col.equals(cur)) {
            return false;
        }
        this.removeName(sName);
        this._colMap.remove(sName);
        this._cols = null;
        if (col.isAutoAssigned()) {
            this._autoAssign = null;
        }
        if (col.isRelationId()) {
            this._rels = null;
        }
        col.remove();
        return true;
    }

    public Column importColumn(Column col) {
        if (col == null) {
            return null;
        }
        Column copy = this.addColumn(col.getIdentifier());
        copy.setType(col.getType());
        copy.setTypeIdentifier(col.getTypeIdentifier());
        copy.setJavaType(col.getJavaType());
        copy.setNotNull(col.isNotNull());
        copy.setDefaultString(col.getDefaultString());
        copy.setSize(col.getSize());
        copy.setDecimalDigits(col.getDecimalDigits());
        copy.setAutoAssigned(col.isAutoAssigned());
        copy.setXML(col.isXML());
        return copy;
    }

    public PrimaryKey getPrimaryKey() {
        return this._pk;
    }

    public PrimaryKey addPrimaryKey() {
        return this.addPrimaryKey(DBIdentifier.NULL);
    }

    public PrimaryKey addPrimaryKey(String name) {
        return this.addPrimaryKey(DBIdentifier.newConstraint(name));
    }

    public PrimaryKey addPrimaryKey(DBIdentifier name) {
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().addName(name, false);
            this._pk = schema.getSchemaGroup().newPrimaryKey(name, this);
        } else {
            this._pk = new PrimaryKey(name, this);
        }
        return this._pk;
    }

    public boolean removePrimaryKey() {
        boolean rem;
        boolean bl = rem = this._pk != null;
        if (rem) {
            Schema schema = this.getSchema();
            if (schema != null && schema.getSchemaGroup() != null) {
                schema.getSchemaGroup().removeName(this._pk.getIdentifier());
            }
            this._pk.remove();
        }
        this._pk = null;
        return rem;
    }

    public PrimaryKey importPrimaryKey(PrimaryKey pk) {
        if (pk == null) {
            return null;
        }
        PrimaryKey copy = this.addPrimaryKey(pk.getIdentifier());
        copy.setLogical(pk.isLogical());
        Column[] cols = pk.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            copy.addColumn(this.getColumn(cols[i].getIdentifier()));
        }
        return copy;
    }

    public ForeignKey getForeignKey(String name) {
        return this.getForeignKey(DBIdentifier.newForeignKey(name));
    }

    public ForeignKey getForeignKey(DBIdentifier name) {
        ForeignKey[] fks = this.getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            if (!name.equals(fks[i].getIdentifier())) continue;
            return fks[i];
        }
        return null;
    }

    public ForeignKey[] getForeignKeys() {
        if (this._fks == null) {
            if (this._fkList == null) {
                this._fks = Schemas.EMPTY_FOREIGN_KEYS;
            } else {
                ForeignKey[] fks = new ForeignKey[this._fkList.size()];
                Iterator<ForeignKey> itr = this._fkList.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    fks[i] = itr.next();
                    fks[i].setIndex(i);
                    ++i;
                }
                this._fks = fks;
            }
        }
        return this._fks;
    }

    public ForeignKey addForeignKey() {
        return this.addForeignKey(DBIdentifier.NULL);
    }

    public ForeignKey addForeignKey(String name) {
        return this.addForeignKey(DBIdentifier.newForeignKey(name));
    }

    public ForeignKey addForeignKey(DBIdentifier name) {
        ForeignKey fk;
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().addName(name, false);
            fk = schema.getSchemaGroup().newForeignKey(name, this);
        } else {
            fk = new ForeignKey(name, this);
        }
        if (this._fkList == null) {
            this._fkList = new ArrayList<ForeignKey>(3);
        }
        this._fkList.add(fk);
        this._fks = null;
        return fk;
    }

    public boolean removeForeignKey(ForeignKey fk) {
        if (fk == null || this._fkList == null) {
            return false;
        }
        if (!this._fkList.remove(fk)) {
            return false;
        }
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().removeName(fk.getIdentifier());
        }
        this._fks = null;
        fk.remove();
        return true;
    }

    public ForeignKey importForeignKey(ForeignKey fk) {
        if (fk == null) {
            return null;
        }
        ForeignKey copy = this.addForeignKey(fk.getIdentifier());
        copy.setDeleteAction(fk.getDeleteAction());
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            int i;
            Column[] pks = fk.getPrimaryKeyColumns();
            Table joined = null;
            if (pks.length > 0) {
                joined = schema.getSchemaGroup().findTable(pks[0].getTable());
            }
            Column[] cols = fk.getColumns();
            for (i = 0; i < cols.length; ++i) {
                copy.join(this.getColumn(cols[i].getIdentifier()), joined.getColumn(pks[i].getIdentifier()));
            }
            cols = fk.getConstantColumns();
            for (i = 0; i < cols.length; ++i) {
                copy.joinConstant(this.getColumn(cols[i].getIdentifier()), fk.getPrimaryKeyConstant(cols[i]));
            }
            pks = fk.getConstantPrimaryKeyColumns();
            if (joined == null && pks.length > 0) {
                joined = schema.getSchemaGroup().findTable(pks[0].getTable());
            }
            for (i = 0; i < pks.length; ++i) {
                copy.joinConstant(fk.getConstant(pks[i]), joined.getColumn(pks[i].getIdentifier()));
            }
        }
        return copy;
    }

    public Index[] getIndexes() {
        if (this._idxs == null || this._idxs.length == 0) {
            this._idxs = this._idxMap == null ? Schemas.EMPTY_INDEXES : this._idxMap.values().toArray(new Index[this._idxMap.size()]);
        }
        return this._idxs;
    }

    public Index getIndex(String name) {
        if (name == null || this._idxMap == null) {
            return null;
        }
        return this.getIndex(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.INDEX, true));
    }

    public Index getIndex(DBIdentifier name) {
        if (name == null || this._idxMap == null) {
            return null;
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        return this._idxMap.get(sName);
    }

    public Index addIndex(String name) {
        return this.addIndex(DBIdentifier.newIndex(name));
    }

    public Index addIndex(DBIdentifier name) {
        Index idx;
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().addName(name, true);
            idx = schema.getSchemaGroup().newIndex(name, this);
        } else {
            idx = new Index(name, this);
        }
        if (this._idxMap == null) {
            this._idxMap = new TreeMap<DBIdentifier, Index>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._idxMap.put(sName, idx);
        this._idxs = null;
        return idx;
    }

    public boolean removeIndex(Index idx) {
        if (idx == null || this._idxMap == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(idx.getIdentifier());
        Index cur = this._idxMap.get(sName);
        if (!idx.equals(cur)) {
            return false;
        }
        this._idxMap.remove(sName);
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().removeName(idx.getIdentifier());
        }
        idx.remove();
        this._idxs = null;
        return true;
    }

    public Index importIndex(Index idx) {
        if (idx == null) {
            return null;
        }
        Index copy = this.addIndex(idx.getIdentifier());
        copy.setUnique(idx.isUnique());
        Column[] cols = idx.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            copy.addColumn(this.getColumn(cols[i].getIdentifier()));
        }
        return copy;
    }

    public Unique[] getUniques() {
        if (this._unqs == null) {
            this._unqs = this._unqList == null ? Schemas.EMPTY_UNIQUES : this._unqList.toArray(new Unique[this._unqList.size()]);
        }
        return this._unqs;
    }

    public Unique getUnique(String name) {
        return this.getUnique(DBIdentifier.newConstraint(name));
    }

    public Unique getUnique(DBIdentifier name) {
        Unique[] unqs = this.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            if (!DBIdentifier.equal(name, unqs[i].getIdentifier())) continue;
            return unqs[i];
        }
        return null;
    }

    public Unique addUnique(String name) {
        return this.addUnique(DBIdentifier.newConstraint(name));
    }

    public Unique addUnique(DBIdentifier name) {
        Unique unq;
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().addName(name, false);
            unq = schema.getSchemaGroup().newUnique(name, this);
        } else {
            unq = new Unique(name, this);
        }
        if (this._unqList == null) {
            this._unqList = new ArrayList<Unique>(3);
        }
        this._unqList.add(unq);
        this._unqs = null;
        return unq;
    }

    public boolean removeUnique(Unique unq) {
        if (unq == null || this._unqList == null) {
            return false;
        }
        if (!this._unqList.remove(unq)) {
            return false;
        }
        Schema schema = this.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            schema.getSchemaGroup().removeName(unq.getIdentifier());
        }
        this._unqs = null;
        unq.remove();
        return true;
    }

    public Unique importUnique(Unique unq) {
        if (unq == null) {
            return null;
        }
        Unique copy = this.addUnique(unq.getIdentifier());
        copy.setDeferred(unq.isDeferred());
        Column[] cols = unq.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            copy.addColumn(this.getColumn(cols[i].getIdentifier()));
        }
        return copy;
    }

    void indexColumns() {
        this.getColumns();
    }

    void indexForeignKeys() {
        this.getForeignKeys();
    }

    void changeAutoAssigned(Column col) {
        this._autoAssign = null;
    }

    void changeRelationId(Column col) {
        this._rels = null;
    }

    @Override
    public int compareTo(Object other) {
        DBIdentifier name = this.getFullIdentifier();
        DBIdentifier otherName = ((Table)other).getFullIdentifier();
        if (DBIdentifier.isNull(name) && DBIdentifier.isNull(otherName)) {
            return 0;
        }
        if (DBIdentifier.isNull(name)) {
            return 1;
        }
        if (DBIdentifier.isNull(otherName)) {
            return -1;
        }
        return name.compareTo(otherName);
    }

    public String toString() {
        return this.getFullIdentifier().getName();
    }

    public boolean hasComment() {
        return this._comment != null && !this._comment.equalsIgnoreCase(this._name.getName());
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public int getLineNumber() {
        return this._lineNum;
    }

    public void setLineNumber(int lineNum) {
        this._lineNum = lineNum;
    }

    public int getColNumber() {
        return this._colNum;
    }

    public void setColNumber(int colNum) {
        this._colNum = colNum;
    }
}

