/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.lang.reflect.Constructor;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.openjpa.lib.jdbc.DelegatingCallableStatement;
import org.apache.openjpa.lib.jdbc.DelegatingDatabaseMetaData;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.jdbc.DelegatingStatement;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;

public abstract class DelegatingConnection
implements Connection,
Closeable {
    static final Constructor<DelegatingConnection> concreteImpl;
    private final Connection _conn;
    private final DelegatingConnection _del;

    public DelegatingConnection(Connection conn) {
        this._conn = conn;
        this._del = conn instanceof DelegatingConnection ? (DelegatingConnection)this._conn : null;
    }

    public static DelegatingConnection newInstance(Connection conn) {
        return ConcreteClassGenerator.newInstance(concreteImpl, conn);
    }

    protected abstract void enforceAbstract();

    public Connection getDelegate() {
        return this._conn;
    }

    public Connection getInnermostDelegate() {
        return this._del == null ? this._conn : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingConnection) {
            other = ((DelegatingConnection)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("conn ").append(this.hashCode());
        this.appendInfo(buf);
        return buf.toString();
    }

    protected void appendInfo(StringBuffer buf) {
        if (this._del != null) {
            this._del.appendInfo(buf);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(true);
    }

    protected Statement createStatement(boolean wrap) throws SQLException {
        Statement stmnt = this._del != null ? this._del.createStatement(false) : this._conn.createStatement();
        if (wrap) {
            stmnt = DelegatingStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public PreparedStatement prepareStatement(String str) throws SQLException {
        return this.prepareStatement(str, true);
    }

    protected PreparedStatement prepareStatement(String str, boolean wrap) throws SQLException {
        PreparedStatement stmnt = this._del != null ? this._del.prepareStatement(str, false) : this._conn.prepareStatement(str, 1003, 1007);
        if (wrap) {
            stmnt = DelegatingPreparedStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public CallableStatement prepareCall(String str) throws SQLException {
        return this.prepareCall(str, true);
    }

    protected CallableStatement prepareCall(String str, boolean wrap) throws SQLException {
        CallableStatement stmnt = this._del != null ? this._del.prepareCall(str, false) : this._conn.prepareCall(str);
        if (wrap) {
            stmnt = DelegatingCallableStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public String nativeSQL(String str) throws SQLException {
        return this._conn.nativeSQL(str);
    }

    @Override
    public void setAutoCommit(boolean bool) throws SQLException {
        this._conn.setAutoCommit(bool);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._conn.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this._conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this._conn.rollback();
    }

    @Override
    public void close() throws SQLException {
        this._conn.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._conn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getMetaData(true);
    }

    protected DatabaseMetaData getMetaData(boolean wrap) throws SQLException {
        DatabaseMetaData meta = this._del != null ? this._del.getMetaData(false) : this._conn.getMetaData();
        if (wrap) {
            meta = DelegatingDatabaseMetaData.newInstance(meta, this);
        }
        return meta;
    }

    @Override
    public void setReadOnly(boolean bool) throws SQLException {
        this._conn.setReadOnly(bool);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._conn.isReadOnly();
    }

    @Override
    public void setCatalog(String str) throws SQLException {
        this._conn.setCatalog(str);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int i) throws SQLException {
        this._conn.setTransactionIsolation(i);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._conn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._conn.clearWarnings();
    }

    @Override
    public Statement createStatement(int type, int concur) throws SQLException {
        return this.createStatement(type, concur, true);
    }

    protected Statement createStatement(int type, int concur, boolean wrap) throws SQLException {
        Statement stmnt = this._del != null ? this._del.createStatement(type, concur, false) : this._conn.createStatement(type, concur);
        if (wrap) {
            stmnt = DelegatingStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public PreparedStatement prepareStatement(String str, int type, int concur) throws SQLException {
        return this.prepareStatement(str, type, concur, true);
    }

    protected PreparedStatement prepareStatement(String str, int type, int concur, boolean wrap) throws SQLException {
        PreparedStatement stmnt = this._del != null ? this._del.prepareStatement(str, type, concur, false) : this._conn.prepareStatement(str, type, concur);
        if (wrap) {
            stmnt = DelegatingPreparedStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public CallableStatement prepareCall(String str, int type, int concur) throws SQLException {
        return this.prepareCall(str, type, concur, true);
    }

    protected CallableStatement prepareCall(String str, int type, int concur, boolean wrap) throws SQLException {
        CallableStatement stmnt = this._del != null ? this._del.prepareCall(str, type, concur, false) : this._conn.prepareCall(str, type, concur);
        if (wrap) {
            stmnt = DelegatingCallableStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this._conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this._conn.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this._conn.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String savepoint) throws SQLException {
        return this._conn.setSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this._conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability, true);
    }

    protected Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean wrap) throws SQLException {
        Statement stmnt = this._del != null ? this._del.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability, false) : this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (wrap) {
            stmnt = DelegatingStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
    }

    protected PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean wrap) throws SQLException {
        PreparedStatement stmnt = this._del != null ? this._del.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false) : this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (wrap) {
            stmnt = DelegatingPreparedStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
    }

    protected CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean wrap) throws SQLException {
        CallableStatement stmnt = this._del != null ? this._del.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false) : this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (wrap) {
            stmnt = DelegatingCallableStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, autoGeneratedKeys, true);
    }

    protected PreparedStatement prepareStatement(String sql, int autoGeneratedKeys, boolean wrap) throws SQLException {
        PreparedStatement stmnt = this._del != null ? this._del.prepareStatement(sql, autoGeneratedKeys) : this._conn.prepareStatement(sql, autoGeneratedKeys);
        if (wrap) {
            stmnt = DelegatingPreparedStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, columnIndexes, true);
    }

    protected PreparedStatement prepareStatement(String sql, int[] columnIndexes, boolean wrap) throws SQLException {
        PreparedStatement stmnt = this._del != null ? this._del.prepareStatement(sql, columnIndexes, wrap) : this._conn.prepareStatement(sql, columnIndexes);
        if (wrap) {
            stmnt = DelegatingPreparedStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, columnNames, true);
    }

    protected PreparedStatement prepareStatement(String sql, String[] columnNames, boolean wrap) throws SQLException {
        PreparedStatement stmnt = this._del != null ? this._del.prepareStatement(sql, columnNames, wrap) : this._conn.prepareStatement(sql, columnNames);
        if (wrap) {
            stmnt = DelegatingPreparedStatement.newInstance(stmnt, this);
        }
        return stmnt;
    }

    public boolean isWrapperFor(Class iface) {
        return iface.isAssignableFrom(this.getDelegate().getClass());
    }

    public Object unwrap(Class iface) {
        if (this.isWrapperFor(iface)) {
            return this.getDelegate();
        }
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this._conn.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this._conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this._conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this._conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this._conn.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this._conn.createStruct(typeName, attributes);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this._conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this._conn.getClientInfo(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this._conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._conn.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this._conn.setClientInfo(name, value);
    }

    static {
        try {
            concreteImpl = ConcreteClassGenerator.getConcreteConstructor(DelegatingConnection.class, Connection.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

