/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.solr.handler.dataimport.CachePropertyUtil;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMapBackedCache
implements DIHCache {
    private SortedMap<Object, List<Map<String, Object>>> theMap = null;
    private boolean isOpen = false;
    private boolean isReadOnly = false;
    String primaryKeyName = null;

    @Override
    public void add(Map<String, Object> rec) {
        ArrayList<Map<String, Object>> thisKeysRecs;
        Object pk;
        this.checkOpen(true);
        this.checkReadOnly();
        if (rec == null || rec.size() == 0) {
            return;
        }
        if (this.primaryKeyName == null) {
            this.primaryKeyName = rec.keySet().iterator().next();
        }
        if ((pk = rec.get(this.primaryKeyName)) instanceof Collection) {
            Collection c = (Collection)pk;
            if (c.size() != 1) {
                throw new RuntimeException("The primary key must have exactly 1 element.");
            }
            pk = c.iterator().next();
        }
        if ((thisKeysRecs = (ArrayList<Map<String, Object>>)this.theMap.get(pk)) == null) {
            thisKeysRecs = new ArrayList<Map<String, Object>>();
            this.theMap.put(pk, thisKeysRecs);
        }
        thisKeysRecs.add(rec);
    }

    private void checkOpen(boolean shouldItBe) {
        if (!this.isOpen && shouldItBe) {
            throw new IllegalStateException("Must call open() before using this cache.");
        }
        if (this.isOpen && !shouldItBe) {
            throw new IllegalStateException("The cache is already open.");
        }
    }

    private void checkReadOnly() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Cache is read-only.");
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public void delete(Object key) {
        this.checkOpen(true);
        this.checkReadOnly();
        this.theMap.remove(key);
    }

    @Override
    public void deleteAll() {
        this.deleteAll(false);
    }

    private void deleteAll(boolean readOnlyOk) {
        if (!readOnlyOk) {
            this.checkReadOnly();
        }
        if (this.theMap != null) {
            this.theMap.clear();
        }
    }

    @Override
    public void destroy() {
        this.deleteAll(true);
        this.theMap = null;
        this.isOpen = false;
    }

    @Override
    public void flush() {
        this.checkOpen(true);
        this.checkReadOnly();
    }

    @Override
    public Iterator<Map<String, Object>> iterator(Object key) {
        this.checkOpen(true);
        List val = (List)this.theMap.get(key);
        if (val == null) {
            return Collections.emptyList().iterator();
        }
        return val.iterator();
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return new Iterator<Map<String, Object>>(){
            private Iterator<Map.Entry<Object, List<Map<String, Object>>>> theMapIter = SortedMapBackedCache.access$000(SortedMapBackedCache.this).entrySet().iterator();
            private List<Map<String, Object>> currentKeyResult = null;
            private Iterator<Map<String, Object>> currentKeyResultIter = null;

            @Override
            public boolean hasNext() {
                if (this.currentKeyResultIter != null) {
                    if (this.currentKeyResultIter.hasNext()) {
                        return true;
                    }
                    this.currentKeyResult = null;
                    this.currentKeyResultIter = null;
                }
                Map.Entry<Object, List<Map<String, Object>>> next = null;
                if (this.theMapIter.hasNext()) {
                    next = this.theMapIter.next();
                    this.currentKeyResult = next.getValue();
                    this.currentKeyResultIter = this.currentKeyResult.iterator();
                    if (this.currentKeyResultIter.hasNext()) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Map<String, Object> next() {
                if (this.currentKeyResultIter != null) {
                    if (this.currentKeyResultIter.hasNext()) {
                        return this.currentKeyResultIter.next();
                    }
                    this.currentKeyResult = null;
                    this.currentKeyResultIter = null;
                }
                Map.Entry<Object, List<Map<String, Object>>> next = null;
                if (this.theMapIter.hasNext()) {
                    next = this.theMapIter.next();
                    this.currentKeyResult = next.getValue();
                    this.currentKeyResultIter = this.currentKeyResult.iterator();
                    if (this.currentKeyResultIter.hasNext()) {
                        return this.currentKeyResultIter.next();
                    }
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void open(Context context) {
        String pkName;
        this.checkOpen(false);
        this.isOpen = true;
        if (this.theMap == null) {
            this.theMap = new TreeMap<Object, List<Map<String, Object>>>();
        }
        if ((pkName = CachePropertyUtil.getAttributeValueAsString(context, "cachePk")) != null) {
            this.primaryKeyName = pkName;
        }
        this.isReadOnly = false;
        String readOnlyStr = CachePropertyUtil.getAttributeValueAsString(context, "cacheReadOnly");
        if ("true".equalsIgnoreCase(readOnlyStr)) {
            this.isReadOnly = true;
        }
    }

    static /* synthetic */ SortedMap access$000(SortedMapBackedCache x0) {
        return x0.theMap;
    }
}

