/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.DateUtil;

public class SolrQuery
extends ModifiableSolrParams {
    private static Pattern scorePattern = Pattern.compile("(^|[, ])score");

    public SolrQuery() {
    }

    public SolrQuery(String q) {
        this();
        this.set("q", q);
    }

    public SolrQuery setTerms(boolean b) {
        if (b) {
            this.set("terms", true);
        } else {
            this.remove("terms");
            this.remove("terms.fl");
            this.remove("terms.lower");
            this.remove("terms.upper");
            this.remove("terms.upper.incl");
            this.remove("terms.lower.incl");
            this.remove("terms.limit");
            this.remove("terms.prefix");
            this.remove("terms.mincount");
            this.remove("terms.maxcount");
            this.remove("terms.raw");
            this.remove("terms.sort");
            this.remove("terms.regex");
            this.remove("terms.regex.flag");
        }
        return this;
    }

    public boolean getTerms() {
        return this.getBool("terms", false);
    }

    public SolrQuery addTermsField(String field) {
        this.add("terms.fl", field);
        return this;
    }

    public String[] getTermsFields() {
        return this.getParams("terms.fl");
    }

    public SolrQuery setTermsLower(String lower) {
        this.set("terms.lower", lower);
        return this;
    }

    public String getTermsLower() {
        return this.get("terms.lower", "");
    }

    public SolrQuery setTermsUpper(String upper) {
        this.set("terms.upper", upper);
        return this;
    }

    public String getTermsUpper() {
        return this.get("terms.upper", "");
    }

    public SolrQuery setTermsUpperInclusive(boolean b) {
        this.set("terms.upper.incl", b);
        return this;
    }

    public boolean getTermsUpperInclusive() {
        return this.getBool("terms.upper.incl", false);
    }

    public SolrQuery setTermsLowerInclusive(boolean b) {
        this.set("terms.lower.incl", b);
        return this;
    }

    public boolean getTermsLowerInclusive() {
        return this.getBool("terms.lower.incl", true);
    }

    public SolrQuery setTermsLimit(int limit) {
        this.set("terms.limit", limit);
        return this;
    }

    public int getTermsLimit() {
        return this.getInt("terms.limit", 10);
    }

    public SolrQuery setTermsMinCount(int cnt) {
        this.set("terms.mincount", cnt);
        return this;
    }

    public int getTermsMinCount() {
        return this.getInt("terms.mincount", 1);
    }

    public SolrQuery setTermsMaxCount(int cnt) {
        this.set("terms.maxcount", cnt);
        return this;
    }

    public int getTermsMaxCount() {
        return this.getInt("terms.maxcount", -1);
    }

    public SolrQuery setTermsPrefix(String prefix) {
        this.set("terms.prefix", prefix);
        return this;
    }

    public String getTermsPrefix() {
        return this.get("terms.prefix", "");
    }

    public SolrQuery setTermsRaw(boolean b) {
        this.set("terms.raw", b);
        return this;
    }

    public boolean getTermsRaw() {
        return this.getBool("terms.raw", false);
    }

    public SolrQuery setTermsSortString(String type) {
        this.set("terms.sort", type);
        return this;
    }

    public String getTermsSortString() {
        return this.get("terms.sort", "count");
    }

    public SolrQuery setTermsRegex(String regex) {
        this.set("terms.regex", regex);
        return this;
    }

    public String getTermsRegex() {
        return this.get("terms.regex");
    }

    public SolrQuery setTermsRegexFlag(String flag) {
        this.add("terms.regex.flag", flag);
        return this;
    }

    public String[] getTermsRegexFlags() {
        return this.getParams("terms.regex.flag");
    }

    public SolrQuery addFacetField(String ... fields) {
        this.add("facet.field", fields);
        this.set("facet", true);
        return this;
    }

    public SolrQuery addFacetPivotField(String ... fields) {
        this.add("facet.pivot", fields);
        this.set("facet", true);
        return this;
    }

    public SolrQuery addNumericRangeFacet(String field, Number start, Number end, Number gap) {
        this.add("facet.range", field);
        this.add(String.format(Locale.ROOT, "f.%s.%s", field, "facet.range.start"), start.toString());
        this.add(String.format(Locale.ROOT, "f.%s.%s", field, "facet.range.end"), end.toString());
        this.add(String.format(Locale.ROOT, "f.%s.%s", field, "facet.range.gap"), gap.toString());
        this.set("facet", true);
        return this;
    }

    public SolrQuery addDateRangeFacet(String field, Date start, Date end, String gap) {
        this.add("facet.range", field);
        this.add(String.format(Locale.ROOT, "f.%s.%s", field, "facet.range.start"), DateUtil.getThreadLocalDateFormat().format(start));
        this.add(String.format(Locale.ROOT, "f.%s.%s", field, "facet.range.end"), DateUtil.getThreadLocalDateFormat().format(end));
        this.add(String.format(Locale.ROOT, "f.%s.%s", field, "facet.range.gap"), gap);
        this.set("facet", true);
        return this;
    }

    public String[] getFacetFields() {
        return this.getParams("facet.field");
    }

    public boolean removeFacetField(String name) {
        boolean b = this.remove("facet.field", name);
        if (this.get("facet.field") == null && this.get("facet.query") == null) {
            this.setFacet(false);
        }
        return b;
    }

    public SolrQuery setFacet(boolean b) {
        if (b) {
            this.set("facet", true);
        } else {
            this.remove("facet");
            this.remove("facet.mincount");
            this.remove("facet.field");
            this.remove("facet.limit");
            this.remove("facet.missing");
            this.remove("facet.offset");
            this.remove("facet.prefix");
            this.remove("facet.query");
            this.remove("facet.sort");
            this.remove("facet.zeros");
            this.remove("facet.prefix");
        }
        return this;
    }

    public SolrQuery setFacetPrefix(String prefix) {
        this.set("facet.prefix", prefix);
        return this;
    }

    public SolrQuery setFacetPrefix(String field, String prefix) {
        this.set("f." + field + "." + "facet.prefix", prefix);
        return this;
    }

    public SolrQuery addFacetQuery(String f) {
        this.add("facet.query", f);
        this.set("facet", true);
        return this;
    }

    public String[] getFacetQuery() {
        return this.getParams("facet.query");
    }

    public boolean removeFacetQuery(String q) {
        boolean b = this.remove("facet.query", q);
        if (this.get("facet.field") == null && this.get("facet.query") == null) {
            this.setFacet(false);
        }
        return b;
    }

    public SolrQuery setFacetLimit(int lim) {
        this.set("facet.limit", lim);
        return this;
    }

    public int getFacetLimit() {
        return this.getInt("facet.limit", 25);
    }

    public SolrQuery setFacetMinCount(int cnt) {
        this.set("facet.mincount", cnt);
        return this;
    }

    public int getFacetMinCount() {
        return this.getInt("facet.mincount", 1);
    }

    public SolrQuery setFacetMissing(Boolean v) {
        this.set("facet.missing", v);
        return this;
    }

    @Deprecated
    public SolrQuery setMissing(String fld) {
        return this.setFacetMissing(Boolean.valueOf(fld));
    }

    public String getFacetSortString() {
        return this.get("facet.sort", "count");
    }

    @Deprecated
    public boolean getFacetSort() {
        return this.get("facet.sort", "count").equals("count");
    }

    public SolrQuery setFacetSort(String sort) {
        this.set("facet.sort", sort);
        return this;
    }

    @Deprecated
    public SolrQuery setFacetSort(boolean sort) {
        this.set("facet.sort", sort ? "count" : "index");
        return this;
    }

    public SolrQuery addHighlightField(String f) {
        this.add("hl.fl", f);
        this.set("hl", true);
        return this;
    }

    public boolean removeHighlightField(String f) {
        boolean b = this.remove("hl.fl", f);
        if (this.get("hl.fl") == null) {
            this.setHighlight(false);
        }
        return b;
    }

    public String[] getHighlightFields() {
        return this.getParams("hl.fl");
    }

    public SolrQuery setHighlightSnippets(int num) {
        this.set("hl.snippets", num);
        return this;
    }

    public int getHighlightSnippets() {
        return this.getInt("hl.snippets", 1);
    }

    public SolrQuery setHighlightFragsize(int num) {
        this.set("hl.fragsize", num);
        return this;
    }

    public int getHighlightFragsize() {
        return this.getInt("hl.fragsize", 100);
    }

    public SolrQuery setHighlightRequireFieldMatch(boolean flag) {
        this.set("hl.requireFieldMatch", flag);
        return this;
    }

    public boolean getHighlightRequireFieldMatch() {
        return this.getBool("hl.requireFieldMatch", false);
    }

    public SolrQuery setHighlightSimplePre(String f) {
        this.set("hl.simple.pre", f);
        return this;
    }

    public String getHighlightSimplePre() {
        return this.get("hl.simple.pre", "");
    }

    public SolrQuery setHighlightSimplePost(String f) {
        this.set("hl.simple.post", f);
        return this;
    }

    public String getHighlightSimplePost() {
        return this.get("hl.simple.post", "");
    }

    public SolrQuery setSortField(String field, ORDER order) {
        this.remove("sort");
        this.addValueToParam("sort", this.toSortString(field, order));
        return this;
    }

    public SolrQuery addSortField(String field, ORDER order) {
        return this.addValueToParam("sort", this.toSortString(field, order));
    }

    public SolrQuery removeSortField(String field, ORDER order) {
        String s = this.get("sort");
        String removeSort = this.toSortString(field, order);
        if (s != null) {
            String[] sorts = s.split(",");
            if ((s = this.join(sorts, ", ", removeSort)).length() == 0) {
                s = null;
            }
            this.set("sort", s);
        }
        return this;
    }

    public String[] getSortFields() {
        String s = this.getSortField();
        if (s == null) {
            return null;
        }
        return s.split(",");
    }

    public String getSortField() {
        return this.get("sort");
    }

    public void setGetFieldStatistics(boolean v) {
        this.set("stats", v);
    }

    public void setGetFieldStatistics(String field) {
        this.set("stats", true);
        this.add("stats.field", field);
    }

    public void addStatsFieldFacets(String field, String ... facets) {
        if (field == null) {
            this.add("stats.facet", facets);
        } else {
            for (String f : facets) {
                this.add("f." + field + "." + "stats.facet", f);
            }
        }
    }

    public SolrQuery setFilterQueries(String ... fq) {
        this.set("fq", fq);
        return this;
    }

    public SolrQuery addFilterQuery(String ... fq) {
        this.add("fq", fq);
        return this;
    }

    public boolean removeFilterQuery(String fq) {
        return this.remove("fq", fq);
    }

    public String[] getFilterQueries() {
        return this.getParams("fq");
    }

    public boolean getHighlight() {
        return this.getBool("hl", false);
    }

    public SolrQuery setHighlight(boolean b) {
        if (b) {
            this.set("hl", true);
        } else {
            this.remove("hl");
            this.remove("hl.requireFieldMatch");
            this.remove("hl.fl");
            this.remove("hl.formatter");
            this.remove("hl.fragsize");
            this.remove("hl.simple.post");
            this.remove("hl.simple.pre");
            this.remove("hl.snippets");
        }
        return this;
    }

    public SolrQuery setFields(String ... fields) {
        if (fields == null || fields.length == 0) {
            this.remove("fl");
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fields[0]);
        for (int i = 1; i < fields.length; ++i) {
            sb.append(',');
            sb.append(fields[i]);
        }
        this.set("fl", sb.toString());
        return this;
    }

    public SolrQuery addField(String field) {
        return this.addValueToParam("fl", field);
    }

    public String getFields() {
        String fields = this.get("fl");
        if (fields != null && fields.equals("score")) {
            fields = "*, score";
        }
        return fields;
    }

    public SolrQuery setIncludeScore(boolean includeScore) {
        String fields = this.get("fl", "*");
        if (includeScore) {
            if (!scorePattern.matcher(fields).find()) {
                this.set("fl", fields + ",score");
            }
        } else {
            this.set("fl", scorePattern.matcher(fields).replaceAll(""));
        }
        return this;
    }

    public SolrQuery setQuery(String query) {
        this.set("q", query);
        return this;
    }

    public String getQuery() {
        return this.get("q");
    }

    public SolrQuery setRows(Integer rows) {
        if (rows == null) {
            this.remove("rows");
        } else {
            this.set("rows", rows);
        }
        return this;
    }

    public Integer getRows() {
        return this.getInt("rows");
    }

    public void setShowDebugInfo(boolean showDebugInfo) {
        this.set("debugQuery", String.valueOf(showDebugInfo));
    }

    public SolrQuery setStart(Integer start) {
        if (start == null) {
            this.remove("start");
        } else {
            this.set("start", start);
        }
        return this;
    }

    public Integer getStart() {
        return this.getInt("start");
    }

    public SolrQuery setRequestHandler(String qt) {
        this.set("qt", qt);
        return this;
    }

    public String getRequestHandler() {
        return this.get("qt");
    }

    @Deprecated
    public SolrQuery setQueryType(String qt) {
        return this.setRequestHandler(qt);
    }

    @Deprecated
    public String getQueryType() {
        return this.getRequestHandler();
    }

    public SolrQuery setParam(String name, String ... values) {
        this.set(name, values);
        return this;
    }

    public SolrQuery setParam(String name, boolean value) {
        this.set(name, value);
        return this;
    }

    public SolrQuery getCopy() {
        SolrQuery q = new SolrQuery();
        for (String name : this.getParameterNames()) {
            q.setParam(name, this.getParams(name));
        }
        return q;
    }

    public SolrQuery setTimeAllowed(Integer milliseconds) {
        if (milliseconds == null) {
            this.remove("timeAllowed");
        } else {
            this.set("timeAllowed", milliseconds);
        }
        return this;
    }

    public Integer getTimeAllowed() {
        return this.getInt("timeAllowed");
    }

    private String toSortString(String field, ORDER order) {
        return field.trim() + ' ' + String.valueOf((Object)order).trim();
    }

    private String join(String a, String b, String sep) {
        StringBuilder sb = new StringBuilder();
        if (a != null && a.length() > 0) {
            sb.append(a);
            sb.append(sep);
        }
        if (b != null && b.length() > 0) {
            sb.append(b);
        }
        return sb.toString().trim();
    }

    private SolrQuery addValueToParam(String name, String value) {
        String tmp = this.get(name);
        tmp = this.join(tmp, value, ",");
        this.set(name, tmp);
        return this;
    }

    private String join(String[] vals, String sep, String removeVal) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (removeVal != null && vals[i].equals(removeVal)) continue;
            sb.append(vals[i]);
            if (i >= vals.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString().trim();
    }

    public static enum ORDER {
        desc,
        asc;


        public ORDER reverse() {
            return this == asc ? desc : asc;
        }
    }
}

