/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometFilter;
import org.apache.catalina.CometFilterChain;
import org.apache.catalina.CometProcessor;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain,
CometFilterChain {
    private static final ThreadLocal lastServicedRequest;
    private static final ThreadLocal lastServicedResponse;
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private static final StringManager sm;
    private InstanceSupport support = null;
    private static Class[] classType;
    private static Class[] classTypeUsedInService;
    private static Class[] cometClassType;
    private static Class[] classTypeUsedInEvent;

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter, request, response);
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] args = new Object[]{req, res, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, args);
                    args = null;
                } else {
                    filter.doFilter(request, response, (FilterChain)this);
                }
                this.support.fireInstanceEvent("afterFilter", filter, request, response);
            }
            catch (IOException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (ServletException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, e);
                }
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        try {
            if (Globals.STRICT_SERVLET_COMPLIANCE) {
                lastServicedRequest.set(request);
                lastServicedResponse.set(response);
            }
            this.support.fireInstanceEvent("beforeService", this.servlet, request, response);
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] args = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", this.servlet, classTypeUsedInService, args, principal);
                    args = null;
                } else {
                    this.servlet.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                }
            } else {
                this.servlet.service(request, response);
            }
            this.support.fireInstanceEvent("afterService", this.servlet, request, response);
        }
        catch (IOException e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e);
            throw e;
        }
        catch (ServletException e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, e);
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
        finally {
            if (Globals.STRICT_SERVLET_COMPLIANCE) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
        }
    }

    public void doFilterEvent(CometEvent event) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final CometEvent ev = event;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilterEvent(ev);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilterEvent(event);
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return (ServletRequest)lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return (ServletResponse)lastServicedResponse.get();
    }

    private void internalDoFilterEvent(CometEvent event) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            CometFilter filter = null;
            try {
                filter = (CometFilter)filterConfig.getFilter();
                if (Globals.IS_SECURITY_ENABLED) {
                    CometEvent ev = event;
                    Principal principal = ev.getHttpServletRequest().getUserPrincipal();
                    Object[] args = new Object[]{ev, this};
                    SecurityUtil.doAsPrivilege("doFilterEvent", filter, cometClassType, args);
                    args = null;
                } else {
                    filter.doFilterEvent(event, this);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                CometEvent ev = event;
                Principal principal = ev.getHttpServletRequest().getUserPrincipal();
                Object[] args = new Object[]{ev};
                SecurityUtil.doAsPrivilege("event", this.servlet, classTypeUsedInEvent, args, principal);
                args = null;
            } else {
                ((CometProcessor)this.servlet).event(event);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] newFilters = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        for (int i = 0; i < this.n; ++i) {
            this.filters[i] = null;
        }
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.support = null;
    }

    void reuse() {
        this.pos = 0;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport support) {
        this.support = support;
    }

    static {
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            lastServicedRequest = new ThreadLocal();
            lastServicedResponse = new ThreadLocal();
        } else {
            lastServicedRequest = null;
            lastServicedResponse = null;
        }
        sm = StringManager.getManager("org.apache.catalina.core");
        classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
        classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
        cometClassType = new Class[]{CometEvent.class, CometFilterChain.class};
        classTypeUsedInEvent = new Class[]{CometEvent.class};
    }
}

