/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;

public class AspectJElementHierarchy
implements IHierarchy {
    private static final long serialVersionUID = 6462734311117048620L;
    private transient AsmManager asm;
    protected IProgramElement root = null;
    protected String configFile = null;
    private Map fileMap = null;
    private Map handleMap = new HashMap();
    private Map typeMap = null;

    public AspectJElementHierarchy(AsmManager asm) {
        this.asm = asm;
    }

    public IProgramElement getElement(String handle) {
        return this.findElementForHandleOrCreate(handle, false);
    }

    public void setAsmManager(AsmManager asm) {
        this.asm = asm;
    }

    public IProgramElement getRoot() {
        return this.root;
    }

    public void setRoot(IProgramElement root) {
        this.root = root;
        this.handleMap = new HashMap();
        this.typeMap = new HashMap();
    }

    public void addToFileMap(Object key, Object value) {
        this.fileMap.put(key, value);
    }

    public boolean removeFromFileMap(Object key) {
        if (this.fileMap.containsKey(key)) {
            return this.fileMap.remove(key) != null;
        }
        return true;
    }

    public void setFileMap(HashMap fileMap) {
        this.fileMap = fileMap;
    }

    public Object findInFileMap(Object key) {
        return this.fileMap.get(key);
    }

    public Set getFileMapEntrySet() {
        return this.fileMap.entrySet();
    }

    public boolean isValid() {
        return this.root != null && this.fileMap != null;
    }

    public IProgramElement findElementForSignature(IProgramElement parent, IProgramElement.Kind kind, String signature) {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (node.getKind() == kind && signature.equals(node.toSignatureString())) {
                return node;
            }
            IProgramElement childSearch = this.findElementForSignature(node, kind, signature);
            if (childSearch == null) continue;
            return childSearch;
        }
        return null;
    }

    public IProgramElement findElementForLabel(IProgramElement parent, IProgramElement.Kind kind, String label) {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (node.getKind() == kind && label.equals(node.toLabelString())) {
                return node;
            }
            IProgramElement childSearch = this.findElementForLabel(node, kind, label);
            if (childSearch == null) continue;
            return childSearch;
        }
        return null;
    }

    public IProgramElement findElementForType(String packageName, String typeName) {
        StringBuffer keyb = packageName == null ? new StringBuffer() : new StringBuffer(packageName);
        keyb.append(".").append(typeName);
        String key = keyb.toString();
        IProgramElement cachedValue = (IProgramElement)this.typeMap.get(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        List packageNodes = this.findMatchingPackages(packageName);
        Iterator iterator = packageNodes.iterator();
        while (iterator.hasNext()) {
            IProgramElement pkg = (IProgramElement)iterator.next();
            Iterator it = pkg.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement fileNode = (IProgramElement)it.next();
                IProgramElement cNode = this.findClassInNodes(fileNode.getChildren(), typeName, typeName);
                if (cNode == null) continue;
                this.typeMap.put(key, cNode);
                return cNode;
            }
        }
        return null;
    }

    public List findMatchingPackages(String packagename) {
        List children = this.root.getChildren();
        if (children.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (((IProgramElement)children.get(0)).getKind() == IProgramElement.Kind.SOURCE_FOLDER) {
            ArrayList<IProgramElement> matchingPackageNodes = new ArrayList<IProgramElement>();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IProgramElement sourceFolder = (IProgramElement)iterator.next();
                List possiblePackageNodes = sourceFolder.getChildren();
                Iterator iterator2 = possiblePackageNodes.iterator();
                while (iterator2.hasNext()) {
                    IProgramElement possiblePackageNode = (IProgramElement)iterator2.next();
                    if (possiblePackageNode.getKind() != IProgramElement.Kind.PACKAGE || !possiblePackageNode.getName().equals(packagename)) continue;
                    matchingPackageNodes.add(possiblePackageNode);
                }
            }
            return matchingPackageNodes;
        }
        if (packagename == null) {
            ArrayList<IProgramElement> result = new ArrayList<IProgramElement>();
            result.add(this.root);
            return result;
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            IProgramElement possiblePackage = (IProgramElement)iterator.next();
            if (possiblePackage.getKind() != IProgramElement.Kind.PACKAGE || !possiblePackage.getName().equals(packagename)) continue;
            ArrayList<IProgramElement> result = new ArrayList<IProgramElement>();
            result.add(possiblePackage);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private IProgramElement findClassInNodes(Collection nodes, String name, String typeName) {
        String innerName;
        String baseName;
        int dollar = name.indexOf(36);
        if (dollar == -1) {
            baseName = name;
            innerName = null;
        } else {
            baseName = name.substring(0, dollar);
            innerName = name.substring(dollar + 1);
        }
        Iterator j = nodes.iterator();
        while (j.hasNext()) {
            IProgramElement node;
            IProgramElement classNode = (IProgramElement)j.next();
            if (baseName.equals(classNode.getName())) {
                if (innerName == null) {
                    return classNode;
                }
                return this.findClassInNodes(classNode.getChildren(), innerName, typeName);
            }
            if (name.equals(classNode.getName())) {
                return classNode;
            }
            if (typeName.equals(classNode.getBytecodeSignature())) {
                return classNode;
            }
            if (classNode.getChildren() == null || classNode.getChildren().isEmpty() || (node = this.findClassInNodes(classNode.getChildren(), name, typeName)) == null) continue;
            return node;
        }
        return null;
    }

    public IProgramElement findElementForSourceFile(String sourceFile) {
        try {
            if (!this.isValid() || sourceFile == null) {
                return IHierarchy.NO_STRUCTURE;
            }
            String correctedPath = this.asm.getCanonicalFilePath(new File(sourceFile));
            IProgramElement node = (IProgramElement)this.findInFileMap(correctedPath);
            if (node != null) {
                return node;
            }
            return this.createFileStructureNode(correctedPath);
        }
        catch (Exception e) {
            return IHierarchy.NO_STRUCTURE;
        }
    }

    public IProgramElement findElementForSourceLine(ISourceLocation location) {
        try {
            return this.findElementForSourceLine(this.asm.getCanonicalFilePath(location.getSourceFile()), location.getLine());
        }
        catch (Exception e) {
            return null;
        }
    }

    public IProgramElement findElementForSourceLine(String sourceFilePath, int lineNumber) {
        String canonicalSFP = this.asm.getCanonicalFilePath(new File(sourceFilePath));
        IProgramElement node = this.findNodeForSourceLineHelper(this.root, canonicalSFP, lineNumber, -1);
        if (node != null) {
            return node;
        }
        return this.createFileStructureNode(sourceFilePath);
    }

    public IProgramElement findElementForOffSet(String sourceFilePath, int lineNumber, int offSet) {
        String canonicalSFP = this.asm.getCanonicalFilePath(new File(sourceFilePath));
        IProgramElement node = this.findNodeForSourceLineHelper(this.root, canonicalSFP, lineNumber, offSet);
        if (node != null) {
            return node;
        }
        return this.createFileStructureNode(sourceFilePath);
    }

    private IProgramElement createFileStructureNode(String sourceFilePath) {
        int lastSlash = sourceFilePath.lastIndexOf(92);
        if (lastSlash == -1) {
            lastSlash = sourceFilePath.lastIndexOf(47);
        }
        int i = sourceFilePath.lastIndexOf(33);
        int j = sourceFilePath.indexOf(".class");
        if (i > lastSlash && i != -1 && j != -1) {
            lastSlash = i;
        }
        String fileName = sourceFilePath.substring(lastSlash + 1);
        ProgramElement fileNode = new ProgramElement(this.asm, fileName, IProgramElement.Kind.FILE_JAVA, new SourceLocation(new File(sourceFilePath), 1, 1), 0, null, null);
        fileNode.addChild(IHierarchy.NO_STRUCTURE);
        return fileNode;
    }

    private IProgramElement findNodeForSourceLineHelper(IProgramElement node, String sourceFilePath, int lineNumber, int offSet) {
        if (this.matches(node, sourceFilePath, lineNumber, offSet) && !this.hasMoreSpecificChild(node, sourceFilePath, lineNumber, offSet)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement foundNode = this.findNodeForSourceLineHelper((IProgramElement)it.next(), sourceFilePath, lineNumber, offSet);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private boolean matches(IProgramElement node, String sourceFilePath, int lineNumber, int offSet) {
        return node != null && node.getSourceLocation() != null && node.getSourceLocation().getSourceFile().getAbsolutePath().equals(sourceFilePath) && (offSet != -1 && node.getSourceLocation().getOffset() == offSet || offSet == -1) && (node.getSourceLocation().getLine() <= lineNumber && node.getSourceLocation().getEndLine() >= lineNumber || lineNumber <= 1 && node.getKind().isSourceFile());
    }

    private boolean hasMoreSpecificChild(IProgramElement node, String sourceFilePath, int lineNumber, int offSet) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement child = (IProgramElement)it.next();
            if (!this.matches(child, sourceFilePath, lineNumber, offSet)) continue;
            return true;
        }
        return false;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public IProgramElement findElementForHandle(String handle) {
        return this.findElementForHandleOrCreate(handle, true);
    }

    public IProgramElement findElementForHandleOrCreate(String handle, boolean create) {
        IProgramElement ipe = (IProgramElement)this.handleMap.get(handle);
        if (ipe != null) {
            return ipe;
        }
        ipe = this.findElementForHandle(this.root, handle);
        if (ipe == null && create) {
            ipe = this.createFileStructureNode(this.getFilename(handle));
        }
        if (ipe != null) {
            this.cache(handle, ipe);
        }
        return ipe;
    }

    private IProgramElement findElementForHandle(IProgramElement parent, String handle) {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement childSearch;
            IProgramElement node = (IProgramElement)it.next();
            String nodeHid = node.getHandleIdentifier();
            if (handle.equals(nodeHid)) {
                return node;
            }
            if (!handle.startsWith(nodeHid) || (childSearch = this.findElementForHandle(node, handle)) == null) continue;
            return childSearch;
        }
        return null;
    }

    protected void cache(String handle, IProgramElement pe) {
        if (!AsmManager.isCompletingTypeBindings()) {
            this.handleMap.put(handle, pe);
        }
    }

    public void flushTypeMap() {
        this.typeMap.clear();
    }

    public void flushHandleMap() {
        this.handleMap.clear();
    }

    public void flushFileMap() {
        this.fileMap.clear();
    }

    public void updateHandleMap(Set deletedFiles) {
        String filePath;
        String typeName;
        IProgramElement ipe;
        String handle;
        ArrayList<String> forRemoval = new ArrayList<String>();
        Set k = this.handleMap.keySet();
        Iterator<Object> iter = k.iterator();
        while (iter.hasNext()) {
            handle = (String)iter.next();
            ipe = (IProgramElement)this.handleMap.get(handle);
            if (!deletedFiles.contains(this.getCanonicalFilePath(ipe))) continue;
            forRemoval.add(handle);
        }
        iter = forRemoval.iterator();
        while (iter.hasNext()) {
            handle = (String)iter.next();
            this.handleMap.remove(handle);
        }
        forRemoval.clear();
        k = this.typeMap.keySet();
        iter = k.iterator();
        while (iter.hasNext()) {
            typeName = (String)iter.next();
            ipe = (IProgramElement)this.typeMap.get(typeName);
            if (!deletedFiles.contains(this.getCanonicalFilePath(ipe))) continue;
            forRemoval.add(typeName);
        }
        iter = forRemoval.iterator();
        while (iter.hasNext()) {
            typeName = (String)iter.next();
            this.typeMap.remove(typeName);
        }
        forRemoval.clear();
        k = this.fileMap.keySet();
        iter = k.iterator();
        while (iter.hasNext()) {
            filePath = (String)iter.next();
            ipe = (IProgramElement)this.fileMap.get(filePath);
            if (!deletedFiles.contains(this.getCanonicalFilePath(ipe))) continue;
            forRemoval.add(filePath);
        }
        iter = forRemoval.iterator();
        while (iter.hasNext()) {
            filePath = (String)iter.next();
            this.fileMap.remove(filePath);
        }
    }

    private String getFilename(String hid) {
        return this.asm.getHandleProvider().getFileForHandle(hid);
    }

    private String getCanonicalFilePath(IProgramElement ipe) {
        if (ipe.getSourceLocation() != null) {
            return this.asm.getCanonicalFilePath(ipe.getSourceLocation().getSourceFile());
        }
        return "";
    }
}

