/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Position;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.PerClause;

public class ReferenceType
extends ResolvedType {
    private final List derivativeTypes = new ArrayList();
    ReferenceType genericType = null;
    ReferenceTypeDelegate delegate = null;
    int startPos = 0;
    int endPos = 0;
    ResolvedMember[] parameterizedMethods = null;
    ResolvedMember[] parameterizedFields = null;
    ResolvedMember[] parameterizedPointcuts = null;
    ResolvedType[] parameterizedInterfaces = null;
    Collection parameterizedDeclares = null;
    Collection parameterizedTypeMungers = null;

    public ReferenceType(String signature, World world) {
        super(signature, world);
    }

    public ReferenceType(String signature, String signatureErasure, World world) {
        super(signature, signatureErasure, world);
    }

    public static ReferenceType fromTypeX(UnresolvedType tx, World world) {
        ReferenceType rt = new ReferenceType(tx.getErasureSignature(), world);
        rt.typeKind = tx.typeKind;
        return rt;
    }

    public ReferenceType(ResolvedType theGenericType, ResolvedType[] theParameters, World aWorld) {
        super(ReferenceType.makeParameterizedSignature(theGenericType, theParameters), theGenericType.signatureErasure, aWorld);
        ReferenceType genericReferenceType = (ReferenceType)theGenericType;
        this.typeParameters = theParameters;
        this.genericType = genericReferenceType;
        this.typeKind = UnresolvedType.TypeKind.PARAMETERIZED;
        this.delegate = genericReferenceType.getDelegate();
        genericReferenceType.addDependentType(this);
    }

    private void addDependentType(ReferenceType dependent) {
        this.derivativeTypes.add(dependent);
    }

    public String getSignatureForAttribute() {
        if (this.genericType == null || this.typeParameters == null) {
            return this.getSignature();
        }
        return ReferenceType.makeDeclaredSignature(this.genericType, this.typeParameters);
    }

    public ReferenceType(UnresolvedType genericType, World world) {
        super(genericType.getSignature(), world);
        this.typeKind = UnresolvedType.TypeKind.GENERIC;
    }

    public boolean isClass() {
        return this.delegate.isClass();
    }

    public boolean isGenericType() {
        return !this.isParameterizedType() && !this.isRawType() && this.delegate.isGeneric();
    }

    public String getGenericSignature() {
        String sig = this.delegate.getDeclaredGenericSignature();
        return sig == null ? "" : sig;
    }

    public AnnotationAJ[] getAnnotations() {
        return this.delegate.getAnnotations();
    }

    public void addAnnotation(AnnotationAJ annotationX) {
        this.delegate.addAnnotation(annotationX);
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        return this.delegate.hasAnnotation(ofType);
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.delegate == null) {
            throw new BCException("Unexpected null delegate for type " + this.getName());
        }
        return this.delegate.getAnnotationTypes();
    }

    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        AnnotationAJ[] axs = this.delegate.getAnnotations();
        if (axs == null) {
            return null;
        }
        for (int i = 0; i < axs.length; ++i) {
            if (!axs[i].getTypeSignature().equals(ofType.getSignature())) continue;
            return axs[i];
        }
        return null;
    }

    public boolean isAspect() {
        return this.delegate.isAspect();
    }

    public boolean isAnnotationStyleAspect() {
        return this.delegate.isAnnotationStyleAspect();
    }

    public boolean isEnum() {
        return this.delegate.isEnum();
    }

    public boolean isAnnotation() {
        return this.delegate.isAnnotation();
    }

    public boolean isAnonymous() {
        return this.delegate.isAnonymous();
    }

    public boolean isNested() {
        return this.delegate.isNested();
    }

    public ResolvedType getOuterClass() {
        return this.delegate.getOuterClass();
    }

    public String getRetentionPolicy() {
        return this.delegate.getRetentionPolicy();
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return this.delegate.isAnnotationWithRuntimeRetention();
    }

    public boolean canAnnotationTargetType() {
        return this.delegate.canAnnotationTargetType();
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        return this.delegate.getAnnotationTargetKinds();
    }

    public boolean isCoerceableFrom(ResolvedType o) {
        ResolvedType other = o.resolve(this.world);
        if (this.isAssignableFrom(other) || other.isAssignableFrom(this)) {
            return true;
        }
        if (this.isParameterizedType() && other.isParameterizedType()) {
            return this.isCoerceableFromParameterizedType(other);
        }
        if (this.isParameterizedType() && other.isRawType()) {
            return ((ReferenceType)this.getRawType()).isCoerceableFrom(other.getGenericType());
        }
        if (this.isRawType() && other.isParameterizedType()) {
            return this.getGenericType().isCoerceableFrom((ReferenceType)other.getRawType());
        }
        if (!this.isInterface() && !other.isInterface()) {
            return false;
        }
        if (this.isFinal() || other.isFinal()) {
            return false;
        }
        ResolvedMember[] a = this.getDeclaredMethods();
        ResolvedMember[] b = other.getDeclaredMethods();
        int alen = a.length;
        for (int ai = 0; ai < alen; ++ai) {
            int blen = b.length;
            for (int bi = 0; bi < blen; ++bi) {
                if (b[bi].isCompatibleWith(a[ai])) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean isCoerceableFromParameterizedType(ResolvedType other) {
        ResolvedType theirRawType;
        if (!other.isParameterizedType()) {
            return false;
        }
        ResolvedType myRawType = (ResolvedType)this.getRawType();
        if ((myRawType == (theirRawType = (ResolvedType)other.getRawType()) || myRawType.isCoerceableFrom(theirRawType)) && this.getTypeParameters().length == other.getTypeParameters().length) {
            ResolvedType[] myTypeParameters = this.getResolvedTypeParameters();
            ResolvedType[] theirTypeParameters = other.getResolvedTypeParameters();
            for (int i = 0; i < myTypeParameters.length; ++i) {
                TypeVariable tv;
                TypeVariableReferenceType tvrt;
                BoundedReferenceType wildcard;
                if (myTypeParameters[i] == theirTypeParameters[i]) continue;
                if (myTypeParameters[i].isGenericWildcard()) {
                    wildcard = (BoundedReferenceType)myTypeParameters[i];
                    if (wildcard.canBeCoercedTo(theirTypeParameters[i])) continue;
                    return false;
                }
                if (myTypeParameters[i].isTypeVariableReference()) {
                    tvrt = (TypeVariableReferenceType)myTypeParameters[i];
                    tv = tvrt.getTypeVariable();
                    tv.resolve(this.world);
                    if (tv.canBeBoundTo(theirTypeParameters[i])) continue;
                    return false;
                }
                if (theirTypeParameters[i].isTypeVariableReference()) {
                    tvrt = (TypeVariableReferenceType)theirTypeParameters[i];
                    tv = tvrt.getTypeVariable();
                    tv.resolve(this.world);
                    if (tv.canBeBoundTo(myTypeParameters[i])) continue;
                    return false;
                }
                if (theirTypeParameters[i].isGenericWildcard()) {
                    wildcard = (BoundedReferenceType)theirTypeParameters[i];
                    if (wildcard.canBeCoercedTo(myTypeParameters[i])) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(ResolvedType other) {
        return this.isAssignableFrom(other, false);
    }

    public boolean isAssignableFrom(ResolvedType other, boolean allowMissing) {
        if (other.isPrimitiveType()) {
            if (!this.world.isInJava5Mode()) {
                return false;
            }
            if (ResolvedType.validBoxing.contains(this.getSignature() + other.getSignature())) {
                return true;
            }
        }
        if (this == other) {
            return true;
        }
        if (this.getSignature().equals(UnresolvedType.OBJECT.getSignature())) {
            return true;
        }
        if ((this.isRawType() || this.isGenericType()) && other.isParameterizedType() && this.isAssignableFrom((ResolvedType)other.getRawType())) {
            return true;
        }
        if (this.isRawType() && other.isGenericType() && this.isAssignableFrom((ResolvedType)other.getRawType())) {
            return true;
        }
        if (this.isGenericType() && other.isRawType() && this.isAssignableFrom(other.getGenericType())) {
            return true;
        }
        if (this.isParameterizedType() && ((ReferenceType)this.getRawType()).isAssignableFrom(other)) {
            boolean wildcardsAllTheWay = true;
            ResolvedType[] myParameters = this.getResolvedTypeParameters();
            for (int i = 0; i < myParameters.length; ++i) {
                if (!myParameters[i].isGenericWildcard()) {
                    wildcardsAllTheWay = false;
                    continue;
                }
                BoundedReferenceType boundedRT = (BoundedReferenceType)myParameters[i];
                if (!boundedRT.isExtends() && !boundedRT.isSuper()) continue;
                wildcardsAllTheWay = false;
            }
            if (wildcardsAllTheWay && !other.isParameterizedType()) {
                return true;
            }
            ResolvedType[] theirParameters = other.getResolvedTypeParameters();
            boolean parametersAssignable = true;
            if (myParameters.length == theirParameters.length) {
                for (int i = 0; i < myParameters.length && parametersAssignable; ++i) {
                    if (myParameters[i] == theirParameters[i]) continue;
                    if (myParameters[i].isTypeVariableReference() && theirParameters[i].isTypeVariableReference()) {
                        TypeVariable myTV = ((TypeVariableReferenceType)myParameters[i]).getTypeVariable();
                        boolean b = myTV.canBeBoundTo(theirParameters[i]);
                        if (b) continue;
                        parametersAssignable = false;
                    } else if (!myParameters[i].isGenericWildcard()) {
                        parametersAssignable = false;
                    } else {
                        BoundedReferenceType wildcardType = (BoundedReferenceType)myParameters[i];
                        if (wildcardType.alwaysMatches(theirParameters[i])) continue;
                        parametersAssignable = false;
                    }
                    break;
                }
            } else {
                parametersAssignable = false;
            }
            if (parametersAssignable) {
                return true;
            }
        }
        if (this.isTypeVariableReference() && !other.isTypeVariableReference()) {
            TypeVariable aVar = ((TypeVariableReference)((Object)this)).getTypeVariable();
            return aVar.resolve(this.world).canBeBoundTo(other);
        }
        if (other.isTypeVariableReference()) {
            TypeVariableReferenceType otherType = (TypeVariableReferenceType)other;
            if (this instanceof TypeVariableReference) {
                return ((TypeVariableReference)((Object)this)).getTypeVariable().resolve(this.world).canBeBoundTo(otherType.getTypeVariable().getFirstBound().resolve(this.world));
            }
            return this.isAssignableFrom(otherType.getTypeVariable().getFirstBound().resolve(this.world));
        }
        if (allowMissing && other.isMissing()) {
            return false;
        }
        Iterator i = other.getDirectSupertypes();
        while (i.hasNext()) {
            if (!this.isAssignableFrom((ResolvedType)i.next(), allowMissing)) continue;
            return true;
        }
        return false;
    }

    public ISourceContext getSourceContext() {
        return this.delegate.getSourceContext();
    }

    public ISourceLocation getSourceLocation() {
        ISourceContext isc = this.delegate.getSourceContext();
        return isc.makeSourceLocation(new Position(this.startPos, this.endPos));
    }

    public boolean isExposedToWeaver() {
        return this.delegate == null || this.delegate.isExposedToWeaver();
    }

    public WeaverStateInfo getWeaverState() {
        return this.delegate.getWeaverState();
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.parameterizedFields != null) {
            return this.parameterizedFields;
        }
        if (this.isParameterizedType() || this.isRawType()) {
            ResolvedMember[] delegateFields = this.delegate.getDeclaredFields();
            this.parameterizedFields = new ResolvedMember[delegateFields.length];
            for (int i = 0; i < delegateFields.length; ++i) {
                this.parameterizedFields[i] = delegateFields[i].parameterizedWith(this.getTypesForMemberParameterization(), this, this.isParameterizedType());
            }
            return this.parameterizedFields;
        }
        return this.delegate.getDeclaredFields();
    }

    public ResolvedType[] getDeclaredInterfaces() {
        if (this.parameterizedInterfaces != null) {
            return this.parameterizedInterfaces;
        }
        if (this.isParameterizedType()) {
            ResolvedType[] delegateInterfaces = this.delegate.getDeclaredInterfaces();
            this.parameterizedInterfaces = new ResolvedType[delegateInterfaces.length];
            for (int i = 0; i < delegateInterfaces.length; ++i) {
                this.parameterizedInterfaces[i] = delegateInterfaces[i].isParameterizedType() ? delegateInterfaces[i].parameterize(this.getMemberParameterizationMap()).resolve(this.world) : delegateInterfaces[i];
            }
            return this.parameterizedInterfaces;
        }
        if (this.isRawType()) {
            ResolvedType[] delegateInterfaces = this.delegate.getDeclaredInterfaces();
            UnresolvedType[] paramTypes = this.getTypesForMemberParameterization();
            this.parameterizedInterfaces = new ResolvedType[delegateInterfaces.length];
            for (int i = 0; i < this.parameterizedInterfaces.length; ++i) {
                this.parameterizedInterfaces[i] = delegateInterfaces[i];
                if (this.parameterizedInterfaces[i].isGenericType()) {
                    this.parameterizedInterfaces[i] = this.parameterizedInterfaces[i].getRawType().resolve(this.getWorld());
                    continue;
                }
                if (!this.parameterizedInterfaces[i].isParameterizedType()) continue;
                UnresolvedType[] toUseForParameterization = this.determineThoseTypesToUse(this.parameterizedInterfaces[i], paramTypes);
                this.parameterizedInterfaces[i] = this.parameterizedInterfaces[i].parameterizedWith(toUseForParameterization);
            }
            return this.parameterizedInterfaces;
        }
        return this.delegate.getDeclaredInterfaces();
    }

    private UnresolvedType[] determineThoseTypesToUse(ResolvedType parameterizedInterface, UnresolvedType[] paramTypes) {
        UnresolvedType[] tParms = parameterizedInterface.getTypeParameters();
        UnresolvedType[] retVal = new UnresolvedType[tParms.length];
        for (int i = 0; i < tParms.length; ++i) {
            UnresolvedType tParm = tParms[i];
            if (tParm.isTypeVariableReference()) {
                TypeVariableReference tvrt = (TypeVariableReference)((Object)tParm);
                TypeVariable tv = tvrt.getTypeVariable();
                int rank = this.getRank(tv.getName());
                if (rank != -1) {
                    retVal[i] = paramTypes[rank];
                    continue;
                }
                retVal[i] = tParms[i];
                continue;
            }
            retVal[i] = tParms[i];
        }
        return retVal;
    }

    private int getRank(String tvname) {
        TypeVariable[] thisTypesTVars = this.getGenericType().getTypeVariables();
        for (int i = 0; i < thisTypesTVars.length; ++i) {
            TypeVariable tv = thisTypesTVars[i];
            if (!tv.getName().equals(tvname)) continue;
            return i;
        }
        return -1;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.parameterizedMethods != null) {
            return this.parameterizedMethods;
        }
        if (this.isParameterizedType() || this.isRawType()) {
            ResolvedMember[] delegateMethods = this.delegate.getDeclaredMethods();
            UnresolvedType[] parameters = this.getTypesForMemberParameterization();
            this.parameterizedMethods = new ResolvedMember[delegateMethods.length];
            for (int i = 0; i < delegateMethods.length; ++i) {
                this.parameterizedMethods[i] = delegateMethods[i].parameterizedWith(parameters, this, this.isParameterizedType());
            }
            return this.parameterizedMethods;
        }
        return this.delegate.getDeclaredMethods();
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.parameterizedPointcuts != null) {
            return this.parameterizedPointcuts;
        }
        if (this.isParameterizedType()) {
            ResolvedMember[] delegatePointcuts = this.delegate.getDeclaredPointcuts();
            this.parameterizedPointcuts = new ResolvedMember[delegatePointcuts.length];
            for (int i = 0; i < delegatePointcuts.length; ++i) {
                this.parameterizedPointcuts[i] = delegatePointcuts[i].parameterizedWith(this.getTypesForMemberParameterization(), this, this.isParameterizedType());
            }
            return this.parameterizedPointcuts;
        }
        return this.delegate.getDeclaredPointcuts();
    }

    private UnresolvedType[] getTypesForMemberParameterization() {
        UnresolvedType[] parameters = null;
        if (this.isParameterizedType()) {
            parameters = this.getTypeParameters();
        } else if (this.isRawType()) {
            TypeVariable[] tvs = this.getGenericType().getTypeVariables();
            parameters = new UnresolvedType[tvs.length];
            for (int i = 0; i < tvs.length; ++i) {
                parameters[i] = tvs[i].getFirstBound();
            }
        }
        return parameters;
    }

    public UnresolvedType getRawType() {
        return super.getRawType().resolve(this.getWorld());
    }

    public TypeVariable[] getTypeVariables() {
        if (this.typeVariables == null) {
            this.typeVariables = this.delegate.getTypeVariables();
            for (int i = 0; i < this.typeVariables.length; ++i) {
                this.typeVariables[i].resolve(this.world);
            }
        }
        return this.typeVariables;
    }

    public PerClause getPerClause() {
        PerClause pclause = this.delegate.getPerClause();
        if (this.isParameterizedType()) {
            Map parameterizationMap = this.getAjMemberParameterizationMap();
            pclause = (PerClause)pclause.parameterizeWith(parameterizationMap, this.world);
        }
        return pclause;
    }

    public Collection getDeclares() {
        if (this.parameterizedDeclares != null) {
            return this.parameterizedDeclares;
        }
        Collection declares = null;
        if (this.ajMembersNeedParameterization()) {
            Collection genericDeclares = this.delegate.getDeclares();
            this.parameterizedDeclares = new ArrayList();
            Map parameterizationMap = this.getAjMemberParameterizationMap();
            Iterator iter = genericDeclares.iterator();
            while (iter.hasNext()) {
                Declare declareStatement = (Declare)iter.next();
                this.parameterizedDeclares.add(declareStatement.parameterizeWith(parameterizationMap, this.world));
            }
            declares = this.parameterizedDeclares;
        } else {
            declares = this.delegate.getDeclares();
        }
        Iterator iter = declares.iterator();
        while (iter.hasNext()) {
            Declare d = (Declare)iter.next();
            d.setDeclaringType(this);
        }
        return declares;
    }

    protected Collection getTypeMungers() {
        return this.delegate.getTypeMungers();
    }

    protected Collection getPrivilegedAccesses() {
        return this.delegate.getPrivilegedAccesses();
    }

    public int getModifiers() {
        return this.delegate.getModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedType getSuperclass() {
        ResolvedType ret = null;
        try {
            this.world.setTypeVariableLookupScope(this);
            ret = this.delegate.getSuperclass();
        }
        finally {
            this.world.setTypeVariableLookupScope(null);
        }
        if (this.isParameterizedType() && ret.isParameterizedType()) {
            ret = ret.parameterize(this.getMemberParameterizationMap()).resolve(this.getWorld());
        }
        return ret;
    }

    public ReferenceTypeDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ReferenceTypeDelegate delegate) {
        ReferenceType genType;
        if (this.delegate != null && this.delegate.copySourceContext() && this.delegate.getSourceContext() != SourceContextImpl.UNKNOWN_SOURCE_CONTEXT) {
            ((AbstractReferenceTypeDelegate)delegate).setSourceContext(this.delegate.getSourceContext());
        }
        this.delegate = delegate;
        Iterator it = this.derivativeTypes.iterator();
        while (it.hasNext()) {
            ReferenceType dependent = (ReferenceType)it.next();
            dependent.setDelegate(delegate);
        }
        if (this.isRawType() && this.getGenericType() != null && (genType = (ReferenceType)this.getGenericType()).getDelegate() != delegate) {
            genType.setDelegate(delegate);
        }
        this.clearParameterizationCaches();
    }

    private void clearParameterizationCaches() {
        this.parameterizedFields = null;
        this.parameterizedInterfaces = null;
        this.parameterizedMethods = null;
        this.parameterizedPointcuts = null;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setEndPos(int endPos) {
        this.endPos = endPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    public boolean doesNotExposeShadowMungers() {
        return this.delegate.doesNotExposeShadowMungers();
    }

    public String getDeclaredGenericSignature() {
        return this.delegate.getDeclaredGenericSignature();
    }

    public void setGenericType(ReferenceType rt) {
        this.genericType = rt;
        if (this.typeKind == UnresolvedType.TypeKind.SIMPLE) {
            this.typeKind = UnresolvedType.TypeKind.RAW;
            this.signatureErasure = this.signature;
        }
    }

    public void demoteToSimpleType() {
        this.genericType = null;
        this.typeKind = UnresolvedType.TypeKind.SIMPLE;
        this.signatureErasure = null;
    }

    public ResolvedType getGenericType() {
        if (this.isGenericType()) {
            return this;
        }
        return this.genericType;
    }

    private static String makeParameterizedSignature(ResolvedType aGenericType, ResolvedType[] someParameters) {
        String rawSignature = aGenericType.getErasureSignature();
        StringBuffer ret = new StringBuffer();
        ret.append("P");
        ret.append(rawSignature.substring(1, rawSignature.length() - 1));
        ret.append("<");
        for (int i = 0; i < someParameters.length; ++i) {
            ret.append(someParameters[i].getSignature());
        }
        ret.append(">;");
        return ret.toString();
    }

    private static String makeDeclaredSignature(ResolvedType aGenericType, UnresolvedType[] someParameters) {
        StringBuffer ret = new StringBuffer();
        String rawSig = aGenericType.getErasureSignature();
        ret.append(rawSig.substring(0, rawSig.length() - 1));
        ret.append("<");
        for (int i = 0; i < someParameters.length; ++i) {
            ret.append(((ReferenceType)someParameters[i]).getSignatureForAttribute());
        }
        ret.append(">;");
        return ret.toString();
    }
}

