/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class ShadowMunger
implements PartialOrder.PartialComparable,
IHasPosition {
    protected Pointcut pointcut;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext;
    private ISourceLocation sourceLocation;
    private ISourceLocation binarySourceLocation;
    private File binaryFile;
    public String handle = null;
    private ResolvedType declaringType;
    public static final ShadowMunger[] NONE = new ShadowMunger[0];
    private boolean isBinary;
    private boolean checkedIsBinary;

    public ShadowMunger(Pointcut pointcut, int start, int end, ISourceContext sourceContext) {
        this.pointcut = pointcut;
        this.start = start;
        this.end = end;
        this.sourceContext = sourceContext;
    }

    public abstract ShadowMunger concretize(ResolvedType var1, World var2, PerClause var3);

    public abstract void specializeOn(Shadow var1);

    public abstract boolean implementOn(Shadow var1);

    public boolean match(Shadow shadow, World world) {
        return this.pointcut.match(shadow).maybeTrue();
    }

    public abstract ShadowMunger parameterizeWith(ResolvedType var1, Map var2);

    public int fallbackCompareTo(Object other) {
        return this.toString().compareTo(this.toString());
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public ISourceLocation getSourceLocation() {
        if (this.sourceLocation == null && this.sourceContext != null) {
            this.sourceLocation = this.sourceContext.makeSourceLocation(this);
        }
        if (this.isBinary()) {
            if (this.binarySourceLocation == null) {
                this.binarySourceLocation = this.getBinarySourceLocation(this.sourceLocation);
            }
            return this.binarySourceLocation;
        }
        return this.sourceLocation;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setDeclaringType(ResolvedType aType) {
        this.declaringType = aType;
    }

    public ResolvedType getDeclaringType() {
        return this.declaringType;
    }

    public abstract Collection getThrownExceptions();

    public abstract boolean mustCheckExceptions();

    public ISourceLocation getBinarySourceLocation(ISourceLocation sl) {
        if (sl == null) {
            return null;
        }
        String sourceFileName = null;
        if (this.getDeclaringType() instanceof ReferenceType) {
            String s = ((ReferenceType)this.getDeclaringType()).getDelegate().getSourcefilename();
            int i = s.lastIndexOf(47);
            sourceFileName = i != -1 ? s.substring(i + 1) : s;
        }
        SourceLocation sLoc = new SourceLocation(this.getBinaryFile(), sl.getLine(), sl.getEndLine(), sl.getColumn() == 0 ? -2147483647 : sl.getColumn(), sl.getContext(), sourceFileName);
        return sLoc;
    }

    private File getBinaryFile() {
        if (this.binaryFile == null) {
            String s = this.getDeclaringType().getBinaryPath();
            File f = this.getDeclaringType().getSourceLocation().getSourceFile();
            int i = f.getPath().lastIndexOf(46);
            String path = f.getPath().substring(0, i) + ".class";
            this.binaryFile = new File(s + "!" + path);
        }
        return this.binaryFile;
    }

    public boolean isBinary() {
        if (!this.checkedIsBinary) {
            ResolvedType rt = this.getDeclaringType();
            if (rt != null) {
                this.isBinary = rt.getBinaryPath() != null;
            }
            this.checkedIsBinary = true;
        }
        return this.isBinary;
    }

    public abstract /* synthetic */ int compareTo(Object var1);
}

