/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.controls.rest;

import eu.dnetlib.monitoring.controls.Control;
import eu.dnetlib.monitoring.server.dao.GenericControlDAO;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/controls"})
public class ControlController {
    private static final Logger log = Logger.getLogger(ControlController.class);
    @Autowired
    private GenericControlDAO controlDao;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<Control> listControls(@PathVariable String scenario) {
        log.info((Object)"List controls");
        return this.controlDao.listControls(scenario);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public int createControl(@PathVariable String scenario, @RequestBody Control control) {
        int controlId = this.controlDao.create(control);
        log.info((Object)("Created control - Id: " + controlId));
        return controlId;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseBody
    public int updateControl(@PathVariable String scenario, @RequestBody Control control) {
        int controlId = this.controlDao.update(control);
        log.info((Object)("Updated control - Id: " + controlId));
        return controlId;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{controlId}"})
    @ResponseBody
    public String deleteControl(@PathVariable String scenario, @PathVariable String controlId) {
        log.info((Object)("Delete control - Id: " + controlId));
        this.controlDao.delete(Integer.valueOf(controlId).intValue());
        return controlId;
    }
}

