/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.metrics.rest;

import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/metrics"})
public class MetricsController {
    private static final Logger log = Logger.getLogger(MetricsController.class);
    @Autowired
    private GenericConfigurationDAO confDao;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<String> getAllMetrics(@PathVariable String scenario) {
        List metrics = this.confDao.listMetrics(scenario);
        return metrics;
    }

    @RequestMapping(value={"/{metric}/labels"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> listLabelNameByMetric(@PathVariable String scenario, @PathVariable String metric) {
        log.info((Object)String.format("List labels of (%s) in scenario (%s)", metric, scenario));
        return this.confDao.listLabelNames(scenario, metric);
    }

    @RequestMapping(value={"/{metric}/labels/{label}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> listLabelValuesByMetric(@PathVariable String scenario, @PathVariable String metric, @PathVariable String label) {
        log.info((Object)String.format("List values of (%s) (%s) in scenario (%s)", metric, label, scenario));
        return this.confDao.listLabelValues(scenario, metric, label);
    }
}

