/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.server.dao.postgres.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.util.PGobject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.support.TransactionTemplate;

public class ConfigurationDAO
implements GenericConfigurationDAO {
    private static final Log log = LogFactory.getLog(ConfigurationDAO.class);
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    public int create(SensorConfiguration configuration) {
        String query = "INSERT INTO configurations(name, params, status, lastmodified) VALUES (?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update((PreparedStatementCreator)new /* Unavailable Anonymous Inner Class!! */, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    public int update(SensorConfiguration configuration) {
        log.debug((Object)("Update configuration " + configuration.getId()));
        String query = "UPDATE configurations SET (name, params, status, lastmodified) = (?, ?, ?, ?) WHERE id = ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update((PreparedStatementCreator)new /* Unavailable Anonymous Inner Class!! */, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    public List<SensorConfiguration> listConfigurations(String scenario) {
        log.debug((Object)("List configurations for scenario " + scenario));
        String query = "SELECT * FROM configurations WHERE params->>'monitoringScenario' = ?";
        return this.queryForConfigurationList(query, new Object[]{scenario});
    }

    public SensorConfiguration getConfiguration(String scenario, String configurationName) {
        log.debug((Object)("Get configurations " + scenario + "/" + configurationName));
        String query = "SELECT * FROM configurations WHERE params->>'monitoringScenario' = ? AND name = ?";
        return (SensorConfiguration)this.queryForConfigurationList(query, new Object[]{scenario, configurationName}).get(0);
    }

    private List<SensorConfiguration> queryForConfigurationList(String query, Object ... queryParams) {
        ArrayList results = Lists.newArrayList();
        List rows = this.jdbcTemplate.queryForList(query, queryParams);
        for (Map row : rows) {
            SensorConfiguration configuration = new SensorConfiguration(this.pgJsonToMap(row.get("params")));
            configuration.setId(((Integer)row.get("id")).intValue());
            configuration.setName((String)row.get("name"));
            configuration.setStatus((String)row.get("status"));
            configuration.setLastModified(((Timestamp)row.get("lastmodified")).getTime());
            results.add(configuration);
        }
        return results;
    }

    private Map<String, Object> pgJsonToMap(Object obj) {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        if (obj != null) {
            return (Map)new Gson().fromJson(((PGobject)obj).getValue(), listType);
        }
        return new HashMap<String, Object>();
    }

    private PGobject mapToPGJson(Map map) throws SQLException {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("json");
        jsonObject.setValue(new Gson().toJson((Object)map));
        return jsonObject;
    }

    public List<String> listMetrics(String scenario) {
        log.debug((Object)("List metrics for scenario " + scenario));
        List queryForList = this.jdbcTemplate.queryForList("(SELECT DISTINCT json_object_keys(params->'querySet') AS m FROM configurations WHERE params->>'monitoringScenario'=?) UNION (SELECT DISTINCT params->>'metric' AS m FROM configurations WHERE params->>'monitoringScenario'=? AND (params->>'metric') IS NOT NULL) ORDER BY m ASC", String.class, new Object[]{scenario, scenario});
        return queryForList;
    }

    public List<String> listLabelNames(String scenario, String metric) {
        log.debug((Object)("List label names for scenario " + scenario + " and metric " + metric));
        List queryForList = this.jdbcTemplate.queryForList("SELECT DISTINCT json_object_keys(params->'labels') AS l FROM configurations WHERE params->>'monitoringScenario'=? AND params->'querySet'->>? != '' ORDER BY l ASC;", String.class, new Object[]{scenario, metric});
        return queryForList;
    }

    public List<String> listLabelValues(String scenario, String metric, String labelName) {
        log.debug((Object)("List label names for scenario " + scenario + " and metric " + metric + " on label " + labelName));
        List queryForList = this.jdbcTemplate.queryForList("SELECT DISTINCT params->'labels'->>? AS v FROM configurations WHERE params->>'monitoringScenario'=? AND params->'querySet'->>? != '' ORDER BY v ASC;", String.class, new Object[]{labelName, scenario, metric});
        return queryForList;
    }

    public void delete(int id) {
        log.debug((Object)("Deleting configuration id: " + id));
        String query = "DELETE FROM configurations WHERE id=?";
        this.jdbcTemplate.update("DELETE FROM configurations WHERE id=?", new Object[]{id});
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    static /* synthetic */ PGobject access$000(ConfigurationDAO x0, Map x1) throws SQLException {
        return x0.mapToPGJson(x1);
    }
}

