/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.configurations.rest;

import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import eu.dnetlib.monitoring.server.dao.exceptions.ConfigurationNotFoundException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/configurations"})
public class ConfigurationController {
    private static final Log log = LogFactory.getLog(ConfigurationController.class);
    @Autowired
    private GenericConfigurationDAO configurationDao;

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public int createConfiguration(@PathVariable String scenario, @RequestBody SensorConfiguration configuration) {
        int configurationId = this.configurationDao.create(configuration);
        log.info((Object)String.format("Created configuration with ID: %s", configurationId));
        return configurationId;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PUT})
    public int updateConfiguration(@PathVariable String scenario, @RequestBody SensorConfiguration configuration) {
        int configurationId = this.configurationDao.update(configuration);
        log.info((Object)String.format("Updated configuration with ID: %s", configurationId));
        return configurationId;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public List<SensorConfiguration> ListConfigurationsByScenario(@PathVariable String scenario) {
        log.info((Object)String.format("Listing available configurations for scenario (%s)", scenario));
        return this.configurationDao.listConfigurations(scenario);
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    public SensorConfiguration getConfigurationByName(@PathVariable String scenario, @PathVariable String name) throws ConfigurationNotFoundException {
        log.info((Object)String.format("Returning configuration (%s) for scenario (%s)", name, scenario));
        return this.configurationDao.getConfiguration(scenario, name);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public String deleteControl(@PathVariable String scenario, @PathVariable String id) {
        log.info((Object)String.format("Delete configuration with ID: %s", id));
        this.configurationDao.delete(Integer.parseInt(id));
        return id;
    }
}

