/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.observations.rest;

import eu.dnetlib.monitoring.model.Observation;
import eu.dnetlib.monitoring.server.dao.GenericObservationDAO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/metrics/{metric}/observations"})
public class ObservationsController {
    private static final Log log = LogFactory.getLog(ObservationsController.class);
    @Autowired
    @Qualifier(value="chosenDao")
    private GenericObservationDAO observationDao;

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public void createObservation(@RequestBody Observation observation) {
        if (!this.observationDao.create(observation)) {
            log.info((Object)String.format("Cannot save observation -> %s(%s = %s)", observation.getSensorType(), observation.getMetric(), observation.getValue()));
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public Map<String, Object> getObservationsByMetricInC3ReadyFormat(@PathVariable String scenario, @PathVariable String metric, @RequestParam(required=false) String label) {
        log.info((Object)String.format("Retrieve observations for metric (%s) (%s) in scenario (%s)", metric, label, scenario));
        List observations = this.getObservationsByMetric(scenario, metric, label);
        LinkedHashMap outerMap = new LinkedHashMap();
        HashSet<String> foundLabelValues = new HashSet<String>();
        for (Observation o : observations) {
            Map<String, Double> innerMap;
            Long timestamp = o.getTimestamp();
            if (!outerMap.containsKey(timestamp)) {
                innerMap = new HashMap<String, Long>();
                innerMap.put("timestamp", (Double)((Object)timestamp));
            } else {
                innerMap = (Map)outerMap.get(timestamp);
            }
            String labelValue = (String)o.getLabels().get(label);
            if (labelValue != null) {
                foundLabelValues.add(labelValue);
                innerMap.put(labelValue, o.getValue());
                outerMap.put(timestamp, innerMap);
                continue;
            }
            foundLabelValues.add("undefined");
            innerMap.put("undefined", o.getValue());
            outerMap.put(timestamp, innerMap);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("observations", outerMap.values());
        retMap.put("labelValues", foundLabelValues);
        return retMap;
    }

    @ResponseBody
    @RequestMapping(value={"/raw"}, method={RequestMethod.GET})
    public List<Observation> getObservationsByMetric(@PathVariable String scenario, @PathVariable String metric, @RequestParam(required=false) String label) {
        if (label != null) {
            log.info((Object)String.format("Retrieve observations for metric (%s) (%s) in scenario (%s)", metric, label, scenario));
            return this.observationDao.findObservations(scenario, metric, label);
        }
        log.info((Object)String.format("Retrieve observations for metric (%s) in scenario (%s)", metric, scenario));
        return this.observationDao.findObservations(scenario, metric);
    }
}

