/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.server.dao.influxdb.impl;

import com.google.common.collect.Lists;
import eu.dnetlib.monitoring.model.Observation;
import eu.dnetlib.monitoring.server.dao.GenericObservationDAO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.factory.annotation.Required;

public class ObservationDAO
implements GenericObservationDAO {
    private static final Log log = LogFactory.getLog(ObservationDAO.class);
    private InfluxDB influxDB;
    private String influxDbName;
    private String influxDbHost;
    private String influxDbPort;
    private String influxDbPassword;
    private String influxDbUsername;

    public void init() {
        this.influxDB = InfluxDBFactory.connect((String)("http://" + this.influxDbHost + ":" + this.influxDbPort), (String)this.influxDbUsername, (String)this.influxDbPassword);
        this.influxDB.createDatabase(this.influxDbName);
        this.influxDB.enableBatch(1000, 100, TimeUnit.NANOSECONDS);
    }

    public boolean create(Observation observation) {
        Point point = Point.measurement((String)observation.getMetric()).time(observation.getTimestamp(), TimeUnit.NANOSECONDS).addField("value", (Number)observation.getValue()).tag("monitoringScenario", observation.getMonitoringScenario()).tag("sensorType", observation.getSensorType()).tag("sensorId", observation.getSensorId()).tag(observation.getLabels()).build();
        this.influxDB.write(this.influxDbName, "default", point);
        return true;
    }

    public Observation getById(String id) {
        return null;
    }

    public List<String> listMetrics(String scenario) {
        List results = this.influxDB.query(new Query("SHOW MEASUREMENTS", this.influxDbName)).getResults();
        QueryResult.Series series = (QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0);
        ArrayList metrics = Lists.newArrayList();
        ListIterator iterator = series.getValues().listIterator();
        while (iterator.hasNext()) {
            metrics.add(((List)iterator.next()).get(0));
        }
        return metrics;
    }

    public List<Observation> findObservations(String scenario, String metric) {
        String queryString = String.format("select * from \"%s\" where monitoringScenario = '%s' order by time desc", metric, scenario);
        return this.queryForObservationList(queryString);
    }

    public List<Observation> findObservations(String scenario, String metric, String labelName) {
        String queryString = String.format("select * from \"%s\" where monitoringScenario = '%s' and \"%s\" != '' order by time desc", metric, scenario, labelName);
        return this.queryForObservationList(queryString);
    }

    public List<Observation> findKLastObservations(String scenario, String metric, int k) {
        String queryString = String.format("select * from \"%s\" where monitoringScenario = '%s' order by time desc limit %s", metric, scenario, k);
        return this.queryForObservationList(queryString);
    }

    public List<Observation> findKLastObservations(String scenario, String metric, String labelName, int k) {
        String queryString = String.format("select * from \"%s\" where monitoringScenario = '%s' and \"%s\" != '' order by time desc limit %s", metric, scenario, labelName, k);
        return this.queryForObservationList(queryString);
    }

    public List<Observation> findKLastObservations(String scenario, String metric, String labelName, String labelValue, int k) {
        String queryString = String.format("select * from \"%s\" where monitoringScenario = '%s' and \"%s\" != '%s' order by time desc limit %s", metric, scenario, labelName, labelValue, k);
        return this.queryForObservationList(queryString);
    }

    private List<Observation> queryForObservationList(String queryString) {
        Query query = new Query(queryString, this.influxDbName);
        List results = this.influxDB.query(query).getResults();
        QueryResult.Series series = (QueryResult.Series)((QueryResult.Result)results.get(0)).getSeries().get(0);
        List columns = series.getColumns();
        ArrayList observations = Lists.newArrayList();
        ListIterator iterator = series.getValues().listIterator();
        while (iterator.hasNext()) {
            observations.add(this.influxValueToObservation((List)iterator.next(), columns, series.getName()));
        }
        return observations;
    }

    private Observation influxValueToObservation(List<Object> value, List<String> columns, String metric) {
        Observation observation = new Observation();
        try {
            observation.setTimestamp(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse((String)value.get(columns.indexOf("time"))).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        observation.setValue((Double)value.get(columns.indexOf("value")));
        observation.setMetric(metric);
        observation.setMonitoringScenario((String)value.get(columns.indexOf("monitoringScenario")));
        observation.setSensorType((String)value.get(columns.indexOf("sensorType")));
        observation.setSensorId((String)value.get(columns.indexOf("sensorId")));
        return observation;
    }

    public int countObservations(String scenario) {
        List metrics = this.listMetrics(scenario);
        int total = 0;
        for (String metric : metrics) {
            total += this.findObservations(scenario, metric).size();
        }
        return total;
    }

    public String getInfluxDbName() {
        return this.influxDbName;
    }

    @Required
    public void setInfluxDbName(String influxDbName) {
        this.influxDbName = influxDbName;
    }

    public String getInfluxDbHost() {
        return this.influxDbHost;
    }

    @Required
    public void setInfluxDbHost(String influxDbHost) {
        this.influxDbHost = influxDbHost;
    }

    public String getInfluxDbPort() {
        return this.influxDbPort;
    }

    @Required
    public void setInfluxDbPort(String influxDbPort) {
        this.influxDbPort = influxDbPort;
    }

    public String getInfluxDbPassword() {
        return this.influxDbPassword;
    }

    @Required
    public void setInfluxDbPassword(String influxDbPassword) {
        this.influxDbPassword = influxDbPassword;
    }

    public String getInfluxDbUsername() {
        return this.influxDbUsername;
    }

    @Required
    public void setInfluxDbUsername(String influxDbUsername) {
        this.influxDbUsername = influxDbUsername;
    }
}

