/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.server.impl;

import com.caucho.hessian.server.HessianServlet;
import eu.dnetlib.monitoring.exception.DataFlowMonitoringServiceRuntimeException;
import eu.dnetlib.monitoring.model.Observation;
import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.rmi.DataFlowMonitoringAPI;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import eu.dnetlib.monitoring.server.dao.GenericObservationDAO;
import eu.dnetlib.monitoring.server.dao.exceptions.ConfigurationNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DataFlowMonitoringService
extends HessianServlet
implements DataFlowMonitoringAPI {
    private static final Log log = LogFactory.getLog(DataFlowMonitoringService.class);
    private GenericObservationDAO observationDAO;
    private GenericConfigurationDAO configurationDAO;

    public boolean storeObservation(Observation observation) {
        return this.observationDAO.create(observation);
    }

    public SensorConfiguration getConfigurationByName(String scenario, String name) {
        try {
            return this.configurationDAO.getConfiguration(scenario, name);
        }
        catch (ConfigurationNotFoundException e) {
            throw new DataFlowMonitoringServiceRuntimeException("Cannot find the configuration", (Throwable)e);
        }
    }

    public GenericObservationDAO getObservationDAO() {
        return this.observationDAO;
    }

    @Required
    public void setObservationDAO(GenericObservationDAO observationDAO) {
        this.observationDAO = observationDAO;
    }

    public GenericConfigurationDAO getConfigurationDAO() {
        return this.configurationDAO;
    }

    @Required
    public void setConfigurationDAO(GenericConfigurationDAO configurationDAO) {
        this.configurationDAO = configurationDAO;
    }
}

