/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import pl.edu.icm.yadda.common.crypt.Md5;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.archive.db.IContentDao;
import pl.edu.icm.yadda.tools.ConsumerThread;
import pl.edu.icm.yadda.tools.pathdispatcher.HashSplitPathDispatcher;
import pl.edu.icm.yadda.tools.pathdispatcher.IPathDispatcher;

public class FileSystemContentDao
implements IContentDao,
DisposableBean,
InitializingBean {
    protected IPathDispatcher pathDispatcher = new HashSplitPathDispatcher();
    protected MessageDigest md;
    protected String storageLocation;
    protected Map<String, FileHandle> usedFileCache = new HashMap<String, FileHandle>();
    protected ConsumerThread<WriteRequest> delayedWriter = new ConsumerThread<WriteRequest>(Thread.currentThread()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void consume(WriteRequest item) throws Exception {
            FileHandle handle = FileSystemContentDao.this.usedFileCache.get(item.fileName);
            if (handle == null) {
                throw new ServiceException("File with name " + item.fileName + " is not open");
            }
            if (handle.closed) {
                throw new ServiceException("File with name " + item.fileName + " is closed");
            }
            FileHandle fileHandle = handle;
            synchronized (fileHandle) {
                handle.file.seek(item.start);
                handle.file.write(item.buffer, item.bufOff, item.bufLen);
                --handle.requests;
                handle.size = Math.max(handle.size, item.start + (long)item.bufLen);
                if (handle.requests == 0) {
                    handle.notifyAll();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commitFile(String name) throws IOException {
        FileHandle handle = this.usedFileCache.get(name);
        if (handle == null) {
            throw new IOException("Part with file name " + name + " is not open.");
        }
        FileHandle fileHandle = handle;
        synchronized (fileHandle) {
            try {
                if (handle.requests > 0) {
                    handle.wait();
                }
                handle.file.close();
                handle.closed = true;
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        return handle.size;
    }

    protected String calculateMd5(String name) throws IOException {
        File absoluteFile = this.buildCannonicalFile(name);
        DigestInputStream dis = new DigestInputStream(new FileInputStream(absoluteFile), this.md);
        byte[] buf = new byte[65536];
        while (dis.read(buf) >= 0) {
        }
        dis.close();
        return Md5.computeMD5((MessageDigest)dis.getMessageDigest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentDao.CommitResult commitFileWithMD5(String name) throws IOException {
        FileHandle handle = this.usedFileCache.get(name);
        if (handle == null) {
            throw new IOException("Part with file name " + name + " is not open.");
        }
        FileHandle fileHandle = handle;
        synchronized (fileHandle) {
            try {
                if (handle.requests > 0) {
                    handle.wait();
                }
                handle.file.close();
                handle.closed = true;
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        String md5 = this.calculateMd5(name);
        IContentDao.CommitResult result = new IContentDao.CommitResult();
        result.md5 = md5;
        result.size = handle.size;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFile() throws IOException {
        String fileName = this.buildFilename();
        File absoluteFile = this.buildCannonicalFile(fileName);
        absoluteFile.getParentFile().mkdirs();
        absoluteFile.createNewFile();
        FileHandle handle = new FileHandle(new RandomAccessFile(absoluteFile, "rw"));
        Map<String, FileHandle> map = this.usedFileCache;
        synchronized (map) {
            if (this.usedFileCache.containsKey(fileName)) {
                throw new IOException("Part with name " + fileName + " is already open");
            }
            this.usedFileCache.put(fileName, handle);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAll(String name) throws IOException {
        File file = this.buildCannonicalFile(name);
        byte[] buf = new byte[(int)file.length()];
        FileInputStream is = new FileInputStream(file);
        try {
            ((InputStream)is).read(buf);
        }
        finally {
            ((InputStream)is).close();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFile(String name, long start, int count, byte[] buf) throws IOException {
        File file = this.buildCannonicalFile(name);
        FileInputStream is = new FileInputStream(file);
        try {
            ((InputStream)is).skip(start);
            int n = ((InputStream)is).read(buf, 0, count);
            return n;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void remove(String name) throws IOException {
        File absoluteFile = this.buildCannonicalFile(name);
        absoluteFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String id, long start, byte[] buf, int bufOff, int bufLen) throws IOException {
        FileHandle fh;
        FileHandle fileHandle = fh = this.usedFileCache.get(id);
        synchronized (fileHandle) {
            ++fh.requests;
        }
        try {
            this.delayedWriter.produce((Object)new WriteRequest(id, start, bufOff, bufLen, buf));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected String buildFilename() {
        String hexId;
        String fileName = hexId = new String(Hex.encodeHex((byte[])UUID.randomUUID().toString().getBytes()));
        String dispatchedPath = this.pathDispatcher.dispatch(hexId);
        return dispatchedPath + File.separator + fileName;
    }

    protected File buildCannonicalFile(String relativeFileName) throws IOException {
        File absoluteFile = new File(this.storageLocation + File.separator + relativeFileName);
        return absoluteFile.getCanonicalFile();
    }

    public void afterPropertiesSet() throws Exception {
        this.md = MessageDigest.getInstance("MD5");
        this.delayedWriter.start();
    }

    public void destroy() throws Exception {
        this.delayedWriter.finish();
        for (FileHandle handle : this.usedFileCache.values()) {
            handle.file.close();
        }
    }

    public void setPathDispatcher(IPathDispatcher pathDispatcher) {
        this.pathDispatcher = pathDispatcher;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    protected class WriteRequest {
        String fileName;
        long start;
        int bufOff;
        int bufLen;
        byte[] buffer;

        public WriteRequest(String id, long start, int bufOff, int bufLen, byte[] buffer) {
            this.fileName = id;
            this.start = start;
            this.bufOff = bufOff;
            this.bufLen = bufLen;
            this.buffer = buffer;
        }
    }

    protected class FileHandle {
        RandomAccessFile file;
        int requests = 0;
        long size = 0L;
        boolean closed = false;

        FileHandle(RandomAccessFile file) {
            this.file = file;
        }
    }
}

