/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.servlet;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.springframework.beans.factory.annotation.Required;
import pl.edu.icm.yadda.service2.ArchiveContentPartMeta;
import pl.edu.icm.yadda.service2.EndpointReference;
import pl.edu.icm.yadda.service2.archive.IProtocolRequest;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectPath;
import pl.edu.icm.yadda.service3.IDataHost;
import pl.edu.icm.yadda.service3.archive.servlet.HttpProtocolRequest;

public class OssHttpHost
implements IDataHost {
    private URL contentServerContext;

    public EndpointReference buildReference(ArchiveObject2Meta owner, ArchiveContentPartMeta part, IProtocolRequest protocolRequest) {
        if (!this.isSupported(protocolRequest)) {
            throw new IllegalStateException();
        }
        HttpProtocolRequest httpRequest = (HttpProtocolRequest)protocolRequest;
        try {
            EndpointReference er = new EndpointReference();
            URI archiveURI = new URI(new ArchiveObjectPath(owner.getId()).encode());
            String archivePath = archiveURI.getSchemeSpecificPart();
            while (archivePath.startsWith("/")) {
                archivePath = archivePath.substring(1);
            }
            er.setAddress(new URL(this.contentServerContext, this.buildPath(archivePath, part, httpRequest)).toURI());
            return er;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected String buildPath(String ownerPath, ArchiveContentPartMeta part, HttpProtocolRequest httpRequest) {
        return ownerPath + "?" + part.getType();
    }

    public boolean isSupported(IProtocolRequest protocol) {
        return protocol instanceof HttpProtocolRequest;
    }

    @Required
    public void setContentServerContext(String contentServerContext) throws MalformedURLException {
        this.contentServerContext = new URL(contentServerContext);
    }
}

