/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db.operation;

import java.util.HashMap;
import java.util.Map;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service3.storage.db.operation.Storage2OperationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionContext {
    private Map<Long, Storage2OperationHandler.HierarchyData> processedObjects = new HashMap<Long, Storage2OperationHandler.HierarchyData>();
    private Map<String, YaddaObjectID> deletedObjectIds = new HashMap<String, YaddaObjectID>();
    private Map<String, ObjectChange> updatedObjectIds = new HashMap<String, ObjectChange>();

    public Map<Long, Storage2OperationHandler.HierarchyData> getProcessedObjects() {
        return this.processedObjects;
    }

    public void setProcessedObjects(Map<Long, Storage2OperationHandler.HierarchyData> processedObjects) {
        this.processedObjects = processedObjects;
    }

    public boolean isAlreadyDeleted(String id) {
        return this.deletedObjectIds.containsKey(id);
    }

    public YaddaObjectID getDeletedObjectId(String id) {
        return this.deletedObjectIds.get(id);
    }

    public void setDeletedObjectId(YaddaObjectID id) {
        this.deletedObjectIds.put(id.getId(), id);
    }

    public boolean isAlreadyUpdated(String id) {
        return this.updatedObjectIds.containsKey(id);
    }

    public YaddaObjectID getNewId(YaddaObjectID id) {
        return this.updatedObjectIds.get(id).getNewId();
    }

    public YaddaObjectID getOldId(String id) {
        return this.updatedObjectIds.get(id).getOldId();
    }

    public void notifyUpdated(YaddaObjectID oldVersion, YaddaObjectID newVersion) {
        this.updatedObjectIds.put(oldVersion.getId(), new ObjectChange(oldVersion, newVersion));
    }

    public class ObjectChange {
        YaddaObjectID oldId;
        YaddaObjectID newId;

        public ObjectChange(YaddaObjectID oldId, YaddaObjectID newId) {
            this.oldId = oldId;
            this.newId = newId;
        }

        public YaddaObjectID getOldId() {
            return this.oldId;
        }

        public YaddaObjectID getNewId() {
            return this.newId;
        }
    }
}

