/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools;

import org.apache.commons.lang.StringUtils;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service3.tools.PartTokenData;

public class PartTokenCodec {
    public static final char TOKEN_SEPARATOR = '-';
    protected static final char SPECIAL_CHAR_PREFIX = '$';
    protected static final char SPECIAL_CHAR_SUFFIX = '$';

    public static String encode(YaddaObjectID id, String partType, long nextPosition, int nextPartSize, long crc) {
        String token = PartTokenCodec.escapeSpecialChars(id.getId()) + '-' + PartTokenCodec.escapeSpecialChars(id.getVersion()) + '-' + PartTokenCodec.escapeSpecialChars(id.getBranch()) + '-' + PartTokenCodec.escapeSpecialChars(partType) + '-' + Long.toString(nextPosition) + '-' + Integer.toString(nextPartSize) + '-' + Long.toHexString(crc);
        return token;
    }

    public static PartTokenData decode(String token) {
        String[] parts = StringUtils.splitPreserveAllTokens((String)token, (char)'-');
        if (parts.length != 7) {
            throw new RuntimeException("Token broken (" + token + ")");
        }
        String id = PartTokenCodec.unescapeSpecialChars(parts[0]);
        String version = PartTokenCodec.unescapeSpecialChars(parts[1]);
        String branch = PartTokenCodec.unescapeSpecialChars(parts[2]);
        String partType = PartTokenCodec.unescapeSpecialChars(parts[3]);
        long nextPosition = Long.parseLong(parts[4]);
        int nextPartSize = Integer.parseInt(parts[5]);
        long crc = Long.parseLong(parts[6].toUpperCase(), 16);
        YaddaObjectID yid = new YaddaObjectID(id, version, branch);
        return new PartTokenData(yid, partType, nextPosition, nextPartSize, crc);
    }

    protected static String escapeSpecialChars(String input) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (PartTokenCodec.isSpecial(c)) {
                output.append('$');
                output.append((int)c);
                output.append('$');
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    protected static String unescapeSpecialChars(String input) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '$') {
                StringBuffer cb = new StringBuffer();
                while (true) {
                    if (++i >= input.length()) {
                        throw new RuntimeException("Token broken - unterminated special char in (" + input + ")");
                    }
                    c = input.charAt(i);
                    if (c == '$') break;
                    cb.append(c);
                }
                output.append((char)Integer.parseInt(cb.toString()));
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    protected static boolean isSpecial(char c) {
        return c == '$' || c == '-';
    }
}

