/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools.cli;

import java.util.List;
import java.util.Map;
import pl.edu.icm.yadda.service2.ArchiveContentPartFacade;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;

public class ShowDetails {
    public static void main(String[] args) {
        IArchiveFacade2 archiveFacade = null;
        String id = null;
        try {
            ArchiveObjectFacade object = archiveFacade.getObjectWithAllParts(new YaddaObjectID(id), true);
            System.out.println("Object " + object.getId().getId());
            System.out.println("Repository path " + ShowDetails.calculatePath(archiveFacade, object));
            System.out.println("Change history:");
            ShowDetails.printHistory(archiveFacade, new YaddaObjectID(id));
            System.out.println();
            System.out.println("Parts:");
            ShowDetails.printParts(object);
            System.out.println();
            System.out.println("Children:");
            ShowDetails.printChildren(object);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    protected static String calculatePath(IArchiveFacade2 archiveFacade, ArchiveObjectFacade object) throws ServiceException {
        if (object.getParentId() != null) {
            ArchiveObjectFacade parent = archiveFacade.getObject(new YaddaObjectID(object.getParentId()), null, false);
            return ShowDetails.calculatePath(archiveFacade, object) + "/" + object.getParentRelationName();
        }
        return "yar://" + object.getId().getId();
    }

    protected static void printParts(ArchiveObjectFacade object) {
        for (ArchiveContentPartFacade part : object.getParts()) {
            System.out.println(part.getType() + "\t" + part.getSize() + "\t" + part.getMime() + "\t" + part.getMd5());
        }
    }

    protected static void printChildren(ArchiveObjectFacade object) {
        for (Map.Entry entry : object.getChildren().entrySet()) {
            System.out.println((String)entry.getKey() + ":");
            for (YaddaObjectID childId : (List)entry.getValue()) {
                System.out.println("\t" + childId);
            }
        }
    }

    protected static void printHistory(IArchiveFacade2 archiveFacade, YaddaObjectID id) {
    }
}

