/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.service2.ArchiveContentPart;
import pl.edu.icm.yadda.service2.ArchiveContentPartMeta;
import pl.edu.icm.yadda.service2.GenericRequest;
import pl.edu.icm.yadda.service2.GetFeaturesRequest;
import pl.edu.icm.yadda.service2.GetFeaturesResponse;
import pl.edu.icm.yadda.service2.YaddaError;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.archive.DataChunk;
import pl.edu.icm.yadda.service2.archive.IProtocolRequest;
import pl.edu.icm.yadda.service2.archive.IdResponse;
import pl.edu.icm.yadda.service2.archive.ListArchiveRequest;
import pl.edu.icm.yadda.service2.archive.RetrieveResponse;
import pl.edu.icm.yadda.service2.exception.NotFoundException;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.IDataHost;
import pl.edu.icm.yadda.service3.archive.GetArchive2ObjectRequest;
import pl.edu.icm.yadda.service3.archive.GetArchive2ObjectResponse;
import pl.edu.icm.yadda.service3.archive.GetArchive2ObjectsRequest;
import pl.edu.icm.yadda.service3.archive.IArchive2;
import pl.edu.icm.yadda.service3.archive.ListArchiveObjects2Response;
import pl.edu.icm.yadda.service3.archive.ListArchiveRequest2;
import pl.edu.icm.yadda.service3.archive.RetrieveRequest;
import pl.edu.icm.yadda.service3.archive.db.DbArchiveObject2Meta;
import pl.edu.icm.yadda.service3.archive.db.IArchiveDao2;
import pl.edu.icm.yadda.service3.archive.db.IContentPartDao2;
import pl.edu.icm.yadda.service3.tools.PartTokenCodec;
import pl.edu.icm.yadda.service3.tools.PartTokenData;

public class DbArchive2
implements IArchive2 {
    protected String archiveId;
    public static final String ID_ARCHIVE_META = "pl.edu.icm.yadda.service3.archive.meta";
    public static final String TYPE_UUID = "UUID";
    public static final String TAG_PREFIX_ARCHIVE_ID = "archiveId:";
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final Set<String> FEATURES = new HashSet<String>();
    protected IContentPartDao2 contentPartDao;
    protected IArchiveDao2 archiveDao;
    protected List<IDataHost> dataHosts = Collections.emptyList();

    public GetArchive2ObjectResponse getObject(GetArchive2ObjectRequest request) {
        try {
            YaddaObjectID objId = request.getId();
            DbArchiveObject2Meta obj = objId.isVersioned() ? this.archiveDao.readObject(objId, !request.isHistorical()) : this.archiveDao.readObject(objId.getId(), true, false);
            if (obj == null) {
                if (request.isThrowExceptionIfNotExists()) {
                    throw new NotFoundException(objId.toString(), "ArchiveObject");
                }
                return new GetArchive2ObjectResponse(null);
            }
            obj.setTags(this.archiveDao.readTags(obj.getPk()));
            ArchiveObject2 result = new ArchiveObject2((ArchiveObject2Meta)obj);
            if (request.isFetchChildren()) {
                result.setChildren(this.archiveDao.readChildren(obj.getPk()));
            }
            result.setParts(new HashMap());
            for (ArchiveContentPartMeta partMeta : this.contentPartDao.getPartsOfObject(obj.getPk())) {
                if (!request.isFetchAllParts() && !ArrayUtils.contains((Object[])request.getPartsToFetch(), (Object)partMeta.getType())) continue;
                result.getParts().put(partMeta.getType(), this.buildPart(obj, partMeta, request.getRequestedProtocols()));
            }
            return new GetArchive2ObjectResponse(result);
        }
        catch (ServiceException e) {
            this.log.debug((Object)e);
            return new GetArchive2ObjectResponse(new YaddaError("", e.toString(), (Exception)((Object)e)));
        }
    }

    protected ArchiveContentPart buildPart(ArchiveObject2Meta owner, ArchiveContentPartMeta meta, IProtocolRequest[] protocolRequests) {
        if (protocolRequests != null) {
            IProtocolRequest[] iProtocolRequestArray = protocolRequests;
            int n = protocolRequests.length;
            int n2 = 0;
            while (n2 < n) {
                IProtocolRequest request = iProtocolRequestArray[n2];
                for (IDataHost dataHost : this.dataHosts) {
                    if (!dataHost.isSupported(request)) continue;
                    return new ArchiveContentPart(meta, dataHost.buildReference(owner, meta, request));
                }
                ++n2;
            }
        }
        return new ArchiveContentPart(meta, null);
    }

    public ListArchiveObjects2Response listObjects(ListArchiveRequest request) {
        IArchiveDao2.HistoricalSelection historicalSelection = request.isHistorical() ? IArchiveDao2.HistoricalSelection.ONLY_HISTORY : IArchiveDao2.HistoricalSelection.ONLY_CURRENT;
        try {
            String[][] tags = null;
            if (request.getTags() != null) {
                tags = new String[request.getTags().size()][];
                int i = 0;
                for (String tag : request.getTags()) {
                    tags[i] = new String[]{tag};
                    ++i;
                }
            }
            IArchiveDao2.Page<DbArchiveObject2Meta> result = request.getResumptionToken() != null ? this.archiveDao.listObjects(request.getResumptionToken()) : this.archiveDao.listObjects(request.getTimeSince(), request.getTimeTo(), tags, request.isOnlyRoots(), historicalSelection);
            LinkedList<ArchiveObject2Meta> rawResult = new LinkedList<ArchiveObject2Meta>();
            for (DbArchiveObject2Meta meta : result) {
                ArchiveObject2Meta rawMeta = new ArchiveObject2Meta((ArchiveObject2Meta)meta);
                rawMeta.setTags(this.archiveDao.readTags(meta.getPk()));
                rawResult.add(rawMeta);
            }
            return new ListArchiveObjects2Response(rawResult, result.getResumptionToken());
        }
        catch (ServiceException e) {
            this.log.debug((Object)e);
            return new ListArchiveObjects2Response(new YaddaError("", e.toString(), (Exception)((Object)e)));
        }
    }

    public ListArchiveObjects2Response listObjects(ListArchiveRequest2 request) {
        IArchiveDao2.HistoricalSelection historicalSelection = request.isHistorical() ? IArchiveDao2.HistoricalSelection.ONLY_HISTORY : IArchiveDao2.HistoricalSelection.ONLY_CURRENT;
        try {
            IArchiveDao2.Page<DbArchiveObject2Meta> result = request.getResumptionToken() != null ? this.archiveDao.listObjects(request.getResumptionToken()) : this.archiveDao.listObjects(request.getTimeSince(), request.getTimeTo(), request.getTags(), request.isOnlyRoots(), historicalSelection);
            LinkedList<ArchiveObject2Meta> rawResult = new LinkedList<ArchiveObject2Meta>();
            for (DbArchiveObject2Meta meta : result) {
                ArchiveObject2Meta rawMeta = new ArchiveObject2Meta((ArchiveObject2Meta)meta);
                rawMeta.setTags(this.archiveDao.readTags(meta.getPk()));
                rawResult.add(rawMeta);
            }
            return new ListArchiveObjects2Response(rawResult, result.getResumptionToken());
        }
        catch (ServiceException e) {
            this.log.debug((Object)e);
            return new ListArchiveObjects2Response(new YaddaError("", e.toString(), (Exception)((Object)e)));
        }
    }

    public ListArchiveObjects2Response queryObjects(GetArchive2ObjectsRequest request) {
        try {
            List<Long> pks = this.archiveDao.retrieveIndexEntries(request.getPath(), request.isSkipDeleted());
            LinkedList<ArchiveObject2Meta> results = new LinkedList<ArchiveObject2Meta>();
            for (long pk : pks) {
                ArchiveObject2Meta meta = new ArchiveObject2Meta((ArchiveObject2Meta)this.archiveDao.readObject(pk, true, false));
                meta.setTags(this.archiveDao.readTags(pk));
                results.add(meta);
            }
            ListArchiveObjects2Response resp = new ListArchiveObjects2Response();
            resp.setPage(results);
            return resp;
        }
        catch (ServiceException e) {
            this.log.debug((Object)e);
            return new ListArchiveObjects2Response(new YaddaError("", e.toString(), (Exception)((Object)e)));
        }
    }

    protected String resolvePartId(YaddaObjectID id, String type) throws ServiceException {
        DbArchiveObject2Meta object = this.archiveDao.readObject(id, true);
        ArchiveContentPartMeta meta = this.contentPartDao.getPartOfObject(object.getPk(), type);
        return meta.getId();
    }

    public RetrieveResponse readChunk(RetrieveRequest request) {
        try {
            int chunkSize;
            long pos;
            String partType;
            YaddaObjectID ownerId;
            if (request.getToken() != null) {
                PartTokenData tokenData = PartTokenCodec.decode(request.getToken());
                ownerId = tokenData.getOwnerId();
                partType = tokenData.getPartType();
                pos = tokenData.getPosition();
                chunkSize = tokenData.getPartSize();
            } else {
                ownerId = request.getOwnerId();
                partType = request.getPartType();
                pos = request.getFrom();
                chunkSize = request.getSize();
            }
            String partId = this.resolvePartId(ownerId, partType);
            byte[] buffer = new byte[chunkSize];
            int readCount = this.contentPartDao.read(partId, pos, chunkSize, buffer);
            int nextPartSize = readCount < chunkSize ? 0 : chunkSize;
            byte[] trimmedBuffer = ArrayUtils.subarray((byte[])buffer, (int)0, (int)readCount);
            CRC32 crc = new CRC32();
            crc.update(trimmedBuffer);
            String newToken = PartTokenCodec.encode(ownerId, partType, pos += (long)readCount, nextPartSize, crc.getValue());
            return new RetrieveResponse(new DataChunk(trimmedBuffer, newToken));
        }
        catch (Exception e) {
            this.log.error((Object)"Exception caught", (Throwable)e);
            YaddaError error = new YaddaError("", e.getMessage(), e);
            return new RetrieveResponse(error);
        }
    }

    protected String getArchiveId() throws ServiceException {
        GetArchive2ObjectResponse resp = this.getObject(new GetArchive2ObjectRequest(new YaddaObjectID(ID_ARCHIVE_META), null, false, false));
        if (resp.getError() != null) {
            throw new ServiceException((Throwable)resp.getError().getException());
        }
        ArchiveObject2 object = resp.getResult();
        if (object == null) {
            throw new ServiceException("ArchiveId object not found");
        }
        String[] stringArray = object.getTags();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.startsWith(TAG_PREFIX_ARCHIVE_ID)) {
                return tag.substring(TAG_PREFIX_ARCHIVE_ID.length());
            }
            ++n2;
        }
        throw new ServiceException("ArchiveId object is invalid");
    }

    public IdResponse getArchiveId(GenericRequest request) {
        IdResponse resp = new IdResponse();
        try {
            if (this.archiveId == null) {
                this.archiveId = this.getArchiveId();
            }
            resp.setServiceId(this.archiveId);
        }
        catch (ServiceException e) {
            this.log.error((Object)"Exception caught", (Throwable)e);
            YaddaError error = new YaddaError("", e.getMessage(), (Exception)((Object)e));
            return new IdResponse(error);
        }
        return resp;
    }

    public GetFeaturesResponse getFeatures(GetFeaturesRequest request) {
        GetFeaturesResponse resp = new GetFeaturesResponse();
        resp.setFeatures(new HashSet<String>(this.FEATURES));
        return resp;
    }

    public IContentPartDao2 getContentPartDao() {
        return this.contentPartDao;
    }

    public void setContentPartDao(IContentPartDao2 contentPartDao) {
        this.contentPartDao = contentPartDao;
    }

    public void setArchiveDao(IArchiveDao2 archiveDao) {
        this.archiveDao = archiveDao;
    }

    public List<IDataHost> getDataHosts() {
        return this.dataHosts;
    }

    public void setDataHosts(List<IDataHost> dataHosts) {
        this.dataHosts = dataHosts;
    }
}

