/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import pl.edu.icm.yadda.service2.ArchiveContentPartFacade;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.ArchiveObjectPath;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;

public class HttpProvidePartServlet
extends HttpServlet {
    private static final long serialVersionUID = 3442379912754376301L;
    protected String archiveFacadeBean = "servletArchiveFacade";
    public static final String PARAM_PART_TYPE = "type";
    public static final int CHUNK_SIZE = 65536;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ArchiveObjectFacade object;
            IArchiveFacade2 archive = this.getBean(this.archiveFacadeBean, IArchiveFacade2.class);
            String objectId = this.extractIdFromRequest(req);
            ArchiveObjectPath path = ArchiveObjectPath.decode((String)objectId);
            String partType = ServletRequestUtils.getRequiredStringParameter((ServletRequest)req, (String)PARAM_PART_TYPE);
            if (path.hasParent()) {
                ArchiveObject2Meta meta = archive.queryUniqueObject(objectId, true);
                if (meta == null) {
                    resp.sendError(404, "Object with path " + objectId + " not found");
                    return;
                }
                object = archive.getObject(meta.getId(), new String[]{partType}, false);
            } else {
                object = archive.getObject(path.getRootId(), new String[]{partType}, false);
            }
            if (object == null) {
                resp.sendError(404, "Object with path " + objectId + " not found");
                return;
            }
            ArchiveContentPartFacade part = object.getPart(partType);
            if (part == null) {
                resp.sendError(404, "Part " + partType + " not found");
                return;
            }
            resp.setContentType(part.getMime());
            resp.setContentLength((int)part.getSize());
            InputStream is = part.getData();
            ServletOutputStream os = resp.getOutputStream();
            try {
                int size;
                byte[] buffer = new byte[65536];
                while ((size = is.read(buffer)) >= 0) {
                    os.write(buffer, 0, size);
                    os.flush();
                }
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            this.log(e.getMessage(), e);
            resp.sendError(500, e.getMessage());
        }
    }

    protected String extractIdFromRequest(HttpServletRequest req) {
        String id = req.getPathInfo();
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        id = "yar://" + id;
        return id;
    }

    protected <T> T getBean(String name, Class<T> type) {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Object result = ctx.getBean(name, type);
        return (T)result;
    }
}

