/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.springframework.test.annotation.AbstractAnnotationAwareTransactionalTests;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.catalog.CountingIterator;
import pl.edu.icm.yadda.service2.exception.NotFoundException;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.ArchiveObjectPath;
import pl.edu.icm.yadda.service3.archive.impl.ArchiveFacade2;
import pl.edu.icm.yadda.service3.storage.impl.StorageFacade2;

public class PostgresDbArchiveTest
extends AbstractAnnotationAwareTransactionalTests {
    protected ArchiveFacade2 archiveFacade;
    protected StorageFacade2 storageFacade;

    public PostgresDbArchiveTest() {
        this.setAutowireMode(1);
    }

    protected void onSetUpInTransaction() throws Exception {
        StorageFacade2 cf = this.storageFacade;
        if (cf.isPrepared() != null) {
            cf.prepare();
        }
        super.onSetUpInTransaction();
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:pl/edu/icm/yadda/service3/archive/db/dao/archive-service-beans-postgresql.xml"};
    }

    public void testGetObject() throws Exception {
        ArchiveObjectFacade root = this.createSampleRoot();
        ArchiveObjectFacade child1 = this.createSampleChild("1", root.getId(), "A");
        ArchiveObjectFacade child2 = this.createSampleChild("2", root.getId(), "A");
        ArchiveObjectFacade child3 = this.createSampleChild("3", root.getId(), "B");
        ArchiveObjectFacade retrievedRoot = this.archiveFacade.getObject(new YaddaObjectID(root.getId().getId()), new String[0], false);
        PostgresDbArchiveTest.assertNotNull((Object)retrievedRoot);
        PostgresDbArchiveTest.assertEquals((String)root.getId().getId(), (String)retrievedRoot.getId().getId());
        PostgresDbArchiveTest.assertEquals((String)root.getId().getId(), (String)retrievedRoot.getAlternativeId().getId());
        PostgresDbArchiveTest.assertEquals((Object)root.getStatus(), (Object)retrievedRoot.getStatus());
        PostgresDbArchiveTest.assertEquals((String)root.getStructureType(), (String)retrievedRoot.getStructureType());
        PostgresDbArchiveTest.assertEquals((String)root.getType(), (String)retrievedRoot.getType());
        PostgresDbArchiveTest.assertNull((Object)root.getChildren());
        PostgresDbArchiveTest.assertTrue((String)(String.valueOf(Arrays.toString(root.getTags())) + " != " + Arrays.toString(retrievedRoot.getTags())), (boolean)Arrays.equals(root.getTags(), retrievedRoot.getTags()));
    }

    public void testGetObjectWithChildren() throws Exception {
        ArchiveObjectFacade root = this.createSampleRoot();
        ArchiveObjectFacade child1 = this.createSampleChild("1", root.getId(), "A");
        ArchiveObjectFacade child2 = this.createSampleChild("2", root.getId(), "A");
        ArchiveObjectFacade child3 = this.createSampleChild("3", root.getId(), "B");
        ArchiveObjectFacade retrievedRoot = this.archiveFacade.getObject(new YaddaObjectID(root.getId().getId()), new String[0], true);
        PostgresDbArchiveTest.assertNotNull((Object)retrievedRoot);
        PostgresDbArchiveTest.assertEquals((String)root.getId().getId(), (String)retrievedRoot.getId().getId());
        PostgresDbArchiveTest.assertEquals((String)root.getId().getId(), (String)retrievedRoot.getAlternativeId().getId());
        PostgresDbArchiveTest.assertEquals((Object)root.getStatus(), (Object)retrievedRoot.getStatus());
        PostgresDbArchiveTest.assertEquals((String)root.getStructureType(), (String)retrievedRoot.getStructureType());
        PostgresDbArchiveTest.assertEquals((String)root.getType(), (String)retrievedRoot.getType());
        PostgresDbArchiveTest.assertNotNull((Object)retrievedRoot.getChildren());
        PostgresDbArchiveTest.assertTrue((boolean)Arrays.equals(root.getTags(), retrievedRoot.getTags()));
        PostgresDbArchiveTest.assertNotNull(retrievedRoot.getChildren().get("A"));
        PostgresDbArchiveTest.assertNotNull(retrievedRoot.getChildren().get("B"));
        PostgresDbArchiveTest.assertEquals((Object)child1.getId(), ((List)retrievedRoot.getChildren().get("A")).get(0));
        PostgresDbArchiveTest.assertEquals((Object)child2.getId(), ((List)retrievedRoot.getChildren().get("A")).get(1));
        PostgresDbArchiveTest.assertEquals((Object)child3.getId(), ((List)retrievedRoot.getChildren().get("B")).get(0));
    }

    public void testGetNonExistentObject1() throws ServiceException {
        try {
            ArchiveObjectFacade retrievedRoot = this.archiveFacade.getObject(new YaddaObjectID("NON EXISTENT"), new String[0], true);
            PostgresDbArchiveTest.fail((String)"Expected exception not raised");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testGetNonExistentObject2() throws ServiceException {
        ArchiveObjectFacade root = this.createSampleRoot();
        YaddaObjectID newId = new YaddaObjectID(root.getId().getId(), "WRONG", "WRONG");
        try {
            ArchiveObjectFacade retrievedRoot = this.archiveFacade.getObject(newId, new String[0], true);
            PostgresDbArchiveTest.fail((String)"Expected exception not raised");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testQueryObjectsByPath() throws ServiceException {
        ArchiveObjectFacade root = this.createSampleRoot();
        ArchiveObjectFacade child1 = this.createSampleChild("A1", root.getId(), "A");
        ArchiveObjectFacade child2 = this.createSampleChild("A2", root.getId(), "A");
        ArchiveObjectFacade child3 = this.createSampleChild("B", root.getId(), "B");
        ArchiveObjectFacade subchild1 = this.createSampleChild("A1:C1", child1.getId(), "C");
        ArchiveObjectFacade subchild2 = this.createSampleChild("A1:D1", child1.getId(), "D");
        ArchiveObjectFacade subchild3 = this.createSampleChild("A1:C2", child1.getId(), "C");
        ArchiveObjectFacade subchild4 = this.createSampleChild("A2:C1", child2.getId(), "C");
        CountingIterator children = this.archiveFacade.queryObjects(new ArchiveObjectPath(new YaddaObjectID(root.getId().getId()), new String[]{"A", "C"}), false);
        LinkedList<ArchiveObject2Meta> resultList = new LinkedList<ArchiveObject2Meta>();
        while (children.hasNext()) {
            ArchiveObject2Meta meta = (ArchiveObject2Meta)children.next();
            resultList.add(meta);
            System.out.println(String.valueOf(meta.getParentRelationName()) + ":" + meta.getParentPosition());
        }
        PostgresDbArchiveTest.assertEquals((int)3, (int)resultList.size());
        PostgresDbArchiveTest.assertEquals((String)subchild1.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(0)).getId().getId());
        PostgresDbArchiveTest.assertEquals((String)subchild3.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(1)).getId().getId());
        PostgresDbArchiveTest.assertEquals((String)subchild4.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(2)).getId().getId());
    }

    public void testQueryObjectsByPathWithDeleted() throws ServiceException {
        ArchiveObjectFacade root = this.createSampleRoot();
        ArchiveObjectFacade child1 = this.createSampleChild("A1", root.getId(), "A");
        ArchiveObjectFacade child2 = this.createSampleChild("A2", root.getId(), "A");
        ArchiveObjectFacade child3 = this.createSampleChild("B", root.getId(), "B");
        ArchiveObjectFacade subchild1 = this.createSampleChild("A1:C1", child1.getId(), "C");
        ArchiveObjectFacade subchild2 = this.createSampleChild("A1:D1", child1.getId(), "D");
        ArchiveObjectFacade subchild3 = this.createSampleChild("A1:C2", child1.getId(), "C");
        ArchiveObjectFacade subchild4 = this.createSampleChild("A2:C1", child2.getId(), "C");
        this.storageFacade.deleteObject(new YaddaObjectID("A1:C2"));
        CountingIterator children = this.archiveFacade.queryObjects(new ArchiveObjectPath(new YaddaObjectID(root.getId().getId()), new String[]{"A", "C"}), true);
        LinkedList<ArchiveObject2Meta> resultList = new LinkedList<ArchiveObject2Meta>();
        while (children.hasNext()) {
            ArchiveObject2Meta meta = (ArchiveObject2Meta)children.next();
            resultList.add(meta);
            System.out.println(String.valueOf(meta.getParentRelationName()) + ":" + meta.getParentPosition());
        }
        PostgresDbArchiveTest.assertEquals((int)2, (int)resultList.size());
        PostgresDbArchiveTest.assertEquals((String)subchild1.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(0)).getId().getId());
        PostgresDbArchiveTest.assertEquals((String)subchild4.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(1)).getId().getId());
    }

    public void testQueryObjectsByUrl() throws Exception {
        ArchiveObjectFacade root = this.createSampleRoot();
        ArchiveObjectFacade child1 = this.createSampleChild("A1", root.getId(), "A");
        ArchiveObjectFacade child2 = this.createSampleChild("A2", root.getId(), "A");
        ArchiveObjectFacade child3 = this.createSampleChild("B", root.getId(), "B");
        ArchiveObjectFacade subchild1 = this.createSampleChild("A1:C1", child1.getId(), "C");
        ArchiveObjectFacade subchild2 = this.createSampleChild("A1:D1", child1.getId(), "D");
        ArchiveObjectFacade subchild3 = this.createSampleChild("A1:C2", child1.getId(), "C");
        ArchiveObjectFacade subchild4 = this.createSampleChild("A2:C1", child2.getId(), "C");
        CountingIterator children = this.archiveFacade.queryObjects("yar://" + root.getId().getId() + "/A/C", false);
        LinkedList<ArchiveObject2Meta> resultList = new LinkedList<ArchiveObject2Meta>();
        while (children.hasNext()) {
            ArchiveObject2Meta meta = (ArchiveObject2Meta)children.next();
            resultList.add(meta);
            System.out.println(String.valueOf(meta.getParentRelationName()) + ":" + meta.getParentPosition());
        }
        PostgresDbArchiveTest.assertEquals((int)3, (int)resultList.size());
        PostgresDbArchiveTest.assertEquals((String)subchild1.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(0)).getId().getId());
        PostgresDbArchiveTest.assertEquals((String)subchild3.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(1)).getId().getId());
        PostgresDbArchiveTest.assertEquals((String)subchild4.getId().getId(), (String)((ArchiveObject2Meta)resultList.get(2)).getId().getId());
    }

    public void testListObjects1() {
        PostgresDbArchiveTest.fail();
    }

    protected void assertTimestamp(Date date) {
        long MAX_DIFFERENCE = 2000L;
        long difference = Math.abs(date.getTime() - new Date().getTime());
        PostgresDbArchiveTest.assertTrue((String)("Unexpected timestamp (" + date + ")"), (difference < 2000L ? 1 : 0) != 0);
    }

    protected ArchiveObjectFacade createSampleRoot() throws ServiceException {
        YaddaObjectID id = new YaddaObjectID(UUID.randomUUID().toString(), "DisplayName");
        ArchiveObjectFacade meta = new ArchiveObjectFacade();
        meta.setId(id);
        meta.setStructureType(UUID.randomUUID().toString());
        meta.setType(UUID.randomUUID().toString());
        meta.setTags(new String[]{UUID.randomUUID().toString(), "SAMPLE2"});
        Arrays.sort(meta.getTags());
        id = this.storageFacade.saveObject(null, meta, null, null);
        meta.setId(id);
        return meta;
    }

    protected ArchiveObjectFacade createSampleChild(String extId, YaddaObjectID parent, String parentName) throws ServiceException {
        YaddaObjectID id = new YaddaObjectID(extId, "DisplayName");
        ArchiveObjectFacade meta = new ArchiveObjectFacade();
        meta.setId(id);
        meta.setStructureType(UUID.randomUUID().toString());
        meta.setType(UUID.randomUUID().toString());
        meta.setParentId(parent);
        meta.setParentRelationName(parentName);
        meta.setTags(new String[]{UUID.randomUUID().toString(), "SAMPLE2"});
        Arrays.sort(meta.getTags());
        id = this.storageFacade.saveObject(null, meta, null, null);
        meta.setId(id);
        return meta;
    }

    public StorageFacade2 getStorageFacade() {
        return this.storageFacade;
    }

    public void setStorageFacade(StorageFacade2 storageFacade) {
        this.storageFacade = storageFacade;
    }

    public ArchiveFacade2 getArchiveFacade() {
        return this.archiveFacade;
    }

    public void setArchiveFacade(ArchiveFacade2 archiveFacade) {
        this.archiveFacade = archiveFacade;
    }
}

