/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class RandomInputStream
extends InputStream {
    private boolean closed = false;
    private int currentValue = 1;
    private int remaining = 0;
    private byte[] values = new byte[1024];

    public RandomInputStream(int remaining) {
        this.remaining = remaining;
        new Random().nextBytes(this.values);
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.remaining <= 0) {
            return -1;
        }
        byte result = this.values[0];
        if (result < 0) {
            result = -result;
        }
        --this.remaining;
        return result;
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        this.checkOpen();
        int i = 0;
        while (i < length / this.values.length) {
            System.arraycopy(this.values, 0, data, offset + i * this.values.length, this.values.length);
            ++i;
        }
        System.arraycopy(this.values, 0, data, offset + i * this.values.length, length % this.values.length);
        if (this.remaining <= 0) {
            return -1;
        }
        if (length > this.remaining) {
            int result = this.remaining;
            this.remaining = 0;
            return result;
        }
        this.remaining -= length;
        return length;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        this.checkOpen();
        return bytesToSkip;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed");
        }
    }

    @Override
    public int available() {
        return this.remaining;
    }
}

