/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.NotImplementedException;
import pl.edu.icm.yadda.service2.EndpointReference;
import pl.edu.icm.yadda.service2.archive.IArchiveClient;
import pl.edu.icm.yadda.service2.archive.IContentSource;

public class HttpArchiveClient
implements IArchiveClient {
    protected String username;
    protected String password;
    protected boolean httpClientStateSet = false;
    private Object timeoutThread;
    protected HttpClient client = new HttpClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getData(EndpointReference ref) {
        HttpArchiveClient httpArchiveClient = this;
        synchronized (httpArchiveClient) {
            if (!this.httpClientStateSet) {
                if (this.username != null) {
                    this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                } else {
                    this.client.getState().setCredentials(AuthScope.ANY, null);
                    this.client.getParams().setAuthenticationPreemptive(false);
                }
                this.httpClientStateSet = true;
            }
        }
        GetMethod getMethod = new GetMethod(ref.getAddress().toString());
        try {
            int statusCode = this.client.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                throw new RuntimeException("Data not found. HTTP Error " + statusCode);
            }
            return new ForceReleaseInputStream(getMethod.getResponseBodyAsStream(), (HttpMethod)getMethod);
        }
        catch (Exception e) {
            getMethod.releaseConnection();
            throw new RuntimeException(e);
        }
    }

    public InputStream negotiateAndGet(String partId, IContentSource facade) {
        throw new NotImplementedException();
    }

    public boolean supports(EndpointReference ref) {
        try {
            ref.getAddress().toURL();
            return true;
        }
        catch (MalformedURLException mu) {
            return false;
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public void setTimeoutThread(Object timeoutThread) {
        this.timeoutThread = timeoutThread;
    }

    protected class ForceReleaseInputStream
    extends InputStream {
        protected HttpMethod httpMethod;
        protected InputStream is;

        public ForceReleaseInputStream(InputStream is, HttpMethod httpMethod) {
            this.is = is;
            this.httpMethod = httpMethod;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.is.close();
            }
            finally {
                this.httpMethod.releaseConnection();
            }
        }

        public boolean equals(Object obj) {
            return this.is.equals(obj);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        @Override
        public void mark(int arg0) {
            this.is.mark(arg0);
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.is.read(arg0, arg1, arg2);
        }

        @Override
        public int read(byte[] arg0) throws IOException {
            return this.is.read(arg0);
        }

        @Override
        public void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public long skip(long arg0) throws IOException {
            return this.is.skip(arg0);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

