/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.YaddaObjectMeta;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectPath;
import pl.edu.icm.yadda.service3.archive.db.DbArchiveObject2Meta;
import pl.edu.icm.yadda.service3.archive.db.IArchiveDao2;
import pl.edu.icm.yadda.tools.GenericTokenCodec;

public abstract class ArchiveDao2
implements IArchiveDao2 {
    protected Log log = LogFactory.getLog(this.getClass());
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected String tablePrefix = "";
    public final long PAGE_SIZE = 100L;
    protected boolean acceptsForUpdate = false;
    private GenericTokenCodec<ResumptionTokenData> resumptionTokenCodec = new ResumptionTokenCodec();

    protected abstract long getNewInternalId();

    @Override
    public long createObject(long parentPk, ArchiveObject2Meta object) {
        long newId = this.getNewInternalId();
        String query = "INSERT INTO " + this.tablePrefix + "archive_object (" + "_pk, " + "id, version, branch, display_name, " + "object_timestamp, status, object_type, " + "alt_id, alt_version, alt_branch, alt_display_name," + "parent__pk, parent_relation_name, parent_position, " + "schema_type, history) VALUES (?, " + "?, ?, ?, ?, " + "?, ?, ?, " + "?, ?, ?, ?, " + "?, ?, ?," + "?, ?)";
        String altId = object.getAlternativeId() != null ? object.getAlternativeId().getId() : null;
        String altVersion = object.getAlternativeId() != null ? object.getAlternativeId().getVersion() : null;
        String altBranch = object.getAlternativeId() != null ? object.getAlternativeId().getBranch() : null;
        String altDisplayName = object.getAlternativeId() != null ? object.getAlternativeId().getDisplayName() : null;
        this.simpleJdbcTemplate.update(query, new Object[]{newId, object.getId().getId(), object.getId().getVersion(), object.getId().getBranch(), object.getId().getDisplayName(), object.getTimestamp(), object.getStatus().toString(), object.getType(), altId, altVersion, altBranch, altDisplayName, parentPk, object.getParentRelationName(), object.getParentPosition(), object.getStructureType(), false});
        return newId;
    }

    @Override
    public long createHistoryObject(YaddaObjectID parentId, ArchiveObject2Meta object) throws ServiceException {
        String altDisplayName;
        long newId = this.getNewInternalId();
        String query = "INSERT INTO " + this.tablePrefix + "archive_object (" + "_pk, " + "id, version, branch, display_name, " + "object_timestamp, status, object_type, " + "alt_id, alt_version, alt_branch, alt_display_name," + "parent_id, parent_version, parent_branch, parent_display_name, " + "parent_relation_name, parent_position, " + "schema_type, history) VALUES (?, " + "?, ?, ?, ?, " + "?, ?, ?, " + "?, ?, ?, ?, " + "?, ?, ?, ?," + "?, ?," + "?, ?)";
        String altId = object.getAlternativeId() != null ? object.getAlternativeId().getId() : null;
        String altVersion = object.getAlternativeId() != null ? object.getAlternativeId().getVersion() : null;
        String altBranch = object.getAlternativeId() != null ? object.getAlternativeId().getVersion() : null;
        String string = altDisplayName = object.getAlternativeId() != null ? object.getAlternativeId().getDisplayName() : null;
        if (parentId == null) {
            parentId = new YaddaObjectID();
        }
        this.simpleJdbcTemplate.update(query, new Object[]{newId, object.getId().getId(), object.getId().getVersion(), object.getId().getBranch(), object.getId().getDisplayName(), object.getTimestamp(), object.getStatus().toString(), object.getType(), altId, altVersion, altBranch, altDisplayName, parentId.getId(), parentId.getVersion(), parentId.getBranch(), parentId.getDisplayName(), object.getParentRelationName(), object.getParentPosition(), object.getStructureType(), true});
        return newId;
    }

    @Override
    public long createRootObject(ArchiveObject2Meta object) {
        long newId = this.getNewInternalId();
        String query = "INSERT INTO " + this.tablePrefix + "archive_object (" + "_pk, " + "id, version, branch, display_name, " + "object_timestamp, status, object_type, " + "alt_id, alt_version, alt_branch, alt_display_name," + "schema_type, history) VALUES (?, " + "?, ?, ?, ?, " + "?, ?, ?, " + "?, ?, ?, ?, " + "?, ?)";
        String altId = object.getAlternativeId() != null ? object.getAlternativeId().getId() : null;
        String altVersion = object.getAlternativeId() != null ? object.getAlternativeId().getVersion() : null;
        String altBranch = object.getAlternativeId() != null ? object.getAlternativeId().getBranch() : null;
        String altDisplayName = object.getAlternativeId() != null ? object.getAlternativeId().getDisplayName() : null;
        this.simpleJdbcTemplate.update(query, new Object[]{newId, object.getId().getId(), object.getId().getVersion(), object.getId().getBranch(), object.getId().getDisplayName(), object.getTimestamp(), object.getStatus().toString(), object.getType(), altId, altVersion, altBranch, altDisplayName, object.getStructureType(), false});
        return newId;
    }

    @Override
    public Map<String, List<YaddaObjectID>> readChildren(long parentId, boolean skipDeleted) {
        Object[] params;
        String query;
        if (skipDeleted) {
            query = "SELECT id, branch, version, parent_position, parent_relation_name FROM " + this.tablePrefix + "archive_object WHERE parent__pk = ? AND status <> ? AND status <> ? ORDER BY parent_relation_name, parent_position";
            params = new Object[]{parentId, YaddaObjectMeta.STATUS.DELETED.toString(), YaddaObjectMeta.STATUS.MERGED_DELETED.toString()};
        } else {
            query = "SELECT id, branch, version, parent_position, parent_relation_name FROM " + this.tablePrefix + "archive_object WHERE parent__pk = ? ORDER BY parent_relation_name, parent_position";
            params = new Object[]{parentId};
        }
        Map result = (Map)this.simpleJdbcTemplate.getJdbcOperations().query(query, params, new ResultSetExtractor(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap result = new HashMap();
                while (rs.next()) {
                    YaddaObjectID targetId = new YaddaObjectID(rs.getString("id"), rs.getString("version"), rs.getString("branch"));
                    String name = rs.getString("parent_relation_name");
                    if (!result.containsKey(name)) {
                        result.put(name, new ArrayList());
                    }
                    ((List)result.get(name)).add(targetId);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public List<YaddaObjectID> readChildren(long parentId, String childName) throws ServiceException {
        String query = "SELECT id, branch, version, parent_position, parent_relation_name FROM " + this.tablePrefix + "archive_object WHERE parent__pk = ? AND parent_relation_name = ? ORDER BY parent_position";
        List result = (List)this.simpleJdbcTemplate.getJdbcOperations().query(query, new Object[]{parentId, childName}, new ResultSetExtractor(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                LinkedList<YaddaObjectID> result = new LinkedList<YaddaObjectID>();
                while (rs.next()) {
                    YaddaObjectID targetId = new YaddaObjectID(rs.getString("id"), rs.getString("version"), rs.getString("branch"));
                    result.add(targetId);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public List<Long> readChildrenPks(long parentPk, String childName, boolean skipDeleted) throws ServiceException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT _pk FROM " + this.tablePrefix + "archive_object " + "WHERE parent__pk = ? AND parent_relation_name = ? ");
        if (skipDeleted) {
            query.append("AND (status <> 'DELETED' ) AND (status <> 'MERGED_DELETED' ) ");
        }
        query.append("ORDER BY parent_position");
        List result = this.simpleJdbcTemplate.getJdbcOperations().queryForList(query.toString(), new Object[]{parentPk, childName}, Long.class);
        return result;
    }

    @Override
    public List<Long> readChildrenPks(String parentId, String childName, boolean skipDeleted) throws ServiceException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ao._pk FROM " + this.tablePrefix + "archive_object ao LEFT JOIN " + this.tablePrefix + "archive_object po ON " + "ao.parent__pk = po._pk WHERE po.id = ? AND ao.parent_relation_name = ? AND ao.history = 'false'");
        if (skipDeleted) {
            query.append("AND (ao.status <> 'DELETED' ) AND (ao.status <> 'MERGED_DELETED' ) ");
        }
        query.append("ORDER BY ao.parent_position");
        List result = this.simpleJdbcTemplate.getJdbcOperations().queryForList(query.toString(), new Object[]{parentId, childName}, Long.class);
        return result;
    }

    @Override
    public List<Long> readChildrenPks(YaddaObjectID parentId, String childName, boolean skipDeleted, boolean skipHistorical) throws ServiceException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ao._pk FROM " + this.tablePrefix + "archive_object ao LEFT JOIN " + this.tablePrefix + "archive_object po ON " + "ao.parent__pk = po._pk WHERE po.id = ? AND po.version = ? AND po.branch = ? AND ao.parent_relation_name = ?");
        if (skipDeleted) {
            query.append("AND (ao.status <> 'DELETED' ) AND (ao.status <> 'MERGED_DELETED' ) ");
        }
        query.append("ORDER BY ao.parent_position");
        if (skipHistorical) {
            query.append(" AND ao.history = 'false'");
        }
        List result = this.simpleJdbcTemplate.getJdbcOperations().queryForList(query.toString(), new Object[]{parentId.getId(), parentId.getVersion(), parentId.getBranch(), childName}, Long.class);
        return result;
    }

    @Override
    public void addTags(long ownerId, String[] tags) {
        String query = "INSERT INTO " + this.tablePrefix + "archive_tag (owner__pk, tag_value) values (?, ?)";
        for (String tag : tags) {
            this.simpleJdbcTemplate.update(query, new Object[]{ownerId, tag});
        }
    }

    @Override
    public void dropTags(long ownerId, String[] tags) {
        String query = "DELETE FROM " + this.tablePrefix + "archive_tag WHERE owner__pk = ? AND tag_value = ?";
        for (String tag : tags) {
            this.simpleJdbcTemplate.update(query, new Object[]{ownerId, tag});
        }
    }

    @Override
    public void createIndexEntry(ArchiveObjectPath path, long pk) {
        StringBuffer address = new StringBuffer();
        address.append(path.getRootId().getId());
        for (String pathEntry : path.getPath()) {
            address.append("/");
            address.append(pathEntry);
        }
        String query = "INSERT INTO " + this.tablePrefix + "archive_index (path, pk, deleted) values(?, ?,?)";
        this.simpleJdbcTemplate.update(query, new Object[]{address, pk, false});
    }

    @Override
    public void removeIndexEntry(ArchiveObjectPath path, long pk) {
        StringBuffer address = new StringBuffer();
        address.append(path.getRootId().getId());
        for (String pathEntry : path.getPath()) {
            address.append("/");
            address.append(pathEntry);
        }
        String query = "DELETE FROM " + this.tablePrefix + "archive_index WHERE path = ? AND pk = ?";
        this.simpleJdbcTemplate.update(query, new Object[]{address, pk});
    }

    @Override
    public void updateIndexEntry(long pk, boolean deletedFlag) {
        String query = "UPDATE " + this.tablePrefix + "archive_index SET deleted = ? WHERE pk = ?";
        this.simpleJdbcTemplate.update(query, new Object[]{deletedFlag, pk});
    }

    @Override
    public List<Long> retrieveIndexEntries(ArchiveObjectPath path, boolean skipDeleted) {
        StringBuffer address = new StringBuffer();
        address.append(path.getRootId().getId());
        for (String pathEntry : path.getPath()) {
            address.append("/");
            address.append(pathEntry);
        }
        String query = "SELECT pk FROM " + this.tablePrefix + "archive_index WHERE path = ?";
        if (skipDeleted) {
            query = query + " AND NOT deleted";
        }
        List result = this.simpleJdbcTemplate.getJdbcOperations().queryForList(query, new Object[]{address}, Long.class);
        return result;
    }

    @Override
    public List<DbArchiveObject2Meta> retrieveObjectsFromIndex(ArchiveObjectPath path, boolean skipDeleted) {
        StringBuffer address = new StringBuffer();
        address.append(path.getRootId().getId());
        for (String pathEntry : path.getPath()) {
            address.append("/");
            address.append(pathEntry);
        }
        String query = "SELECT ao.*  FROM " + this.tablePrefix + "archive_object ao " + "LEFT JOIN " + this.tablePrefix + "archive_index ai ON ai.pk = ao._pk WHERE ai.path = ?";
        return this.simpleJdbcTemplate.query(query, (ParameterizedRowMapper)new ArchiveObjectRowMapper(false), new Object[]{address});
    }

    @Override
    public List<String> retrievePathsFromIndex(long pk) {
        String query = "SELECT ai.path  FROM " + this.tablePrefix + "archive_index ai WHERE ai.pk = ?";
        List result = this.simpleJdbcTemplate.getJdbcOperations().queryForList(query, new Object[]{pk}, String.class);
        return result;
    }

    @Override
    public void updateMeta(long pk, ArchiveObject2Meta object) {
        String query = "UPDATE " + this.tablePrefix + "archive_object " + " SET " + "id = ?, version = ?, branch = ?, display_name = ?, " + "object_timestamp = ?, status = ?, object_type = ?, " + "alt_id = ?, alt_version = ?, alt_branch = ?, alt_display_name = ?," + "schema_type = ? WHERE _pk = ?";
        this.simpleJdbcTemplate.update(query, new Object[]{object.getId().getId(), object.getId().getVersion(), object.getId().getBranch(), object.getId().getDisplayName(), object.getTimestamp(), object.getStatus().toString(), object.getType(), object.getAlternativeId().getId(), object.getAlternativeId().getVersion(), object.getAlternativeId().getBranch(), object.getAlternativeId().getDisplayName(), object.getStructureType(), pk});
    }

    @Override
    public IArchiveDao2.Page<DbArchiveObject2Meta> listObjects(Date timeSince, Date timeTo, String[][] tags, boolean onlyRoots, IArchiveDao2.HistoricalSelection historySelection) throws ServiceException {
        return this.doListObject(timeSince, timeTo, tags, onlyRoots, null, 100L, historySelection);
    }

    @Override
    public IArchiveDao2.Page<DbArchiveObject2Meta> listObjects(String resumptionToken) throws ServiceException {
        ResumptionTokenData tokenData = (ResumptionTokenData)this.resumptionTokenCodec.decode(resumptionToken);
        return this.doListObject(tokenData.sinceDate, tokenData.toDate, tokenData.tags, tokenData.onlyRoots, tokenData.firstPk, tokenData.count, tokenData.historicalSelection);
    }

    protected IArchiveDao2.Page<DbArchiveObject2Meta> doListObject(Date timeSince, Date timeTo, String[][] tags, boolean onlyRoots, Long lastPk, long size, IArchiveDao2.HistoricalSelection historySelection) throws ServiceException {
        int i;
        StringBuffer query = new StringBuffer();
        LinkedList<Object> params = new LinkedList<Object>();
        query.append("SELECT ao.*, po.id as join_parent_id, po.version as join_parent_version, po.branch as join_parent_branch, po.display_name as join_parent_display_name FROM " + this.tablePrefix + "archive_object ao LEFT JOIN " + this.tablePrefix + "archive_object po ON ao.parent__pk = po._pk ");
        if (tags != null) {
            for (i = 0; i < tags.length; ++i) {
                for (int j = 0; j < tags[i].length; ++j) {
                    query.append("LEFT JOIN " + this.tablePrefix + "archive_tag t" + i + "_" + j + " ON ao._pk = t" + i + "_" + j + ".owner__pk AND t" + i + "_" + j + ".tag_value = ?");
                    params.add(tags[i][j]);
                }
            }
        }
        switch (historySelection) {
            case ALL: {
                query.append(" WHERE 1 = 1 ");
                break;
            }
            case ONLY_CURRENT: {
                query.append(" WHERE ao.HISTORY = 'false'");
                break;
            }
            case ONLY_HISTORY: {
                query.append(" WHERE ao.HISTORY = 'true'");
            }
        }
        if (tags != null) {
            i = 0;
            for (String[] tagAlternative : tags) {
                query.append("AND ( 1 = 0");
                int j = 0;
                for (String tag : tagAlternative) {
                    query.append(" OR t" + i + "_" + j + ".tag_value NOTNULL");
                    ++j;
                }
                query.append(")");
                ++i;
            }
        }
        if (timeSince != null) {
            query.append(" AND ao.object_timestamp > ?");
            params.add(timeSince);
        }
        if (timeTo != null) {
            query.append(" AND ao.object_timestamp < ?");
            params.add(timeTo);
        }
        if (lastPk != null) {
            query.append(" AND ao._pk > ?");
            params.add(lastPk);
        }
        if (onlyRoots) {
            query.append(" AND ao.parent__pk IS NULL");
        }
        query.append(" ORDER BY ao._pk LIMIT " + size);
        List result = this.simpleJdbcTemplate.query(query.toString(), (ParameterizedRowMapper)new ArchiveObjectRowMapper(true), params.toArray());
        String resumptionToken = null;
        if (!result.isEmpty()) {
            ResumptionTokenData tokenData = new ResumptionTokenData();
            tokenData.sinceDate = timeSince;
            tokenData.toDate = timeTo;
            tokenData.tags = tags != null ? tags : new String[][]{};
            tokenData.count = size;
            tokenData.firstPk = ((DbArchiveObject2Meta)result.get(result.size() - 1)).getPk();
            tokenData.historicalSelection = historySelection;
            tokenData.onlyRoots = onlyRoots;
            resumptionToken = this.resumptionTokenCodec.encode((Object)tokenData);
        }
        IArchiveDao2.Page<DbArchiveObject2Meta> objects = new IArchiveDao2.Page<DbArchiveObject2Meta>(result, resumptionToken);
        return objects;
    }

    @Override
    public DbArchiveObject2Meta readObject(long pk, boolean fetchParentData, boolean lockForUpdate) throws ServiceException {
        String query = fetchParentData ? "SELECT ao.*, po.id as join_parent_id, po.version as join_parent_version, po.branch as join_parent_branch, po.display_name as join_parent_display_name FROM " + this.tablePrefix + "archive_object ao LEFT JOIN " + this.tablePrefix + "archive_object po ON ao.parent__pk = po._pk WHERE ao._pk = ?" : "SELECT ao.* FROM " + this.tablePrefix + "archive_object ao WHERE ao._pk = ?";
        if (this.acceptsForUpdate && lockForUpdate) {
            query = query + " FOR UPDATE";
        }
        try {
            return (DbArchiveObject2Meta)this.simpleJdbcTemplate.queryForObject(query, (ParameterizedRowMapper)new ArchiveObjectRowMapper(fetchParentData), new Object[]{pk});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public DbArchiveObject2Meta readObject(YaddaObjectID id, boolean skipHistorical) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ao.*, po.id as join_parent_id, po.version as join_parent_version, po.branch as join_parent_branch, po.display_name as join_parent_display_name FROM " + this.tablePrefix + "archive_object ao LEFT JOIN " + this.tablePrefix + "archive_object po ON ao.parent__pk = po._pk WHERE ao.id = ? AND ao.version = ? AND ao.branch = ?");
        if (skipHistorical) {
            query.append(" AND ao.history = 'false'");
        }
        try {
            DbArchiveObject2Meta result = (DbArchiveObject2Meta)this.simpleJdbcTemplate.queryForObject(query.toString(), (ParameterizedRowMapper)new ArchiveObjectRowMapper(true), new Object[]{id.getId(), id.getVersion(), id.getBranch()});
            return result;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public DbArchiveObject2Meta readObject(String id, boolean fetchParent, boolean lockForUpdate) throws ServiceException {
        String query = fetchParent ? "SELECT ao.*, po.id as join_parent_id, po.version as join_parent_version, po.branch as join_parent_branch, po.display_name as join_parent_display_name FROM " + this.tablePrefix + "archive_object ao LEFT JOIN " + this.tablePrefix + "archive_object po ON ao.parent__pk = po._pk WHERE ao.id = ?" : "SELECT ao.* FROM " + this.tablePrefix + "archive_object ao WHERE ao.id = ?";
        query = query + " AND ao.history = 'false'";
        if (this.acceptsForUpdate && lockForUpdate) {
            query = query + " FOR UPDATE";
        }
        try {
            return (DbArchiveObject2Meta)this.simpleJdbcTemplate.queryForObject(query, (ParameterizedRowMapper)new ArchiveObjectRowMapper(fetchParent), new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public String[] readTags(long ownerId) throws ServiceException {
        String query = "SELECT tag_value FROM " + this.tablePrefix + "archive_tag WHERE owner__pk = ?";
        List result = this.simpleJdbcTemplate.getJdbcOperations().queryForList(query, new Object[]{ownerId}, String.class);
        return result.toArray(new String[result.size()]);
    }

    public SimpleJdbcTemplate getSimpleJdbcTemplate() {
        return this.simpleJdbcTemplate;
    }

    public void setSimpleJdbcTemplate(SimpleJdbcTemplate simpleJdbcTemplate) {
        this.simpleJdbcTemplate = simpleJdbcTemplate;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public static class ResumptionTokenCodec
    extends GenericTokenCodec<ResumptionTokenData> {
        protected ResumptionTokenData build(String[] parts) {
            ResumptionTokenData data = new ResumptionTokenData();
            if (!StringUtils.isEmpty((String)parts[0])) {
                data.sinceDate = new Date(Long.parseLong(parts[0]));
            }
            if (!StringUtils.isEmpty((String)parts[1])) {
                data.toDate = new Date(Long.parseLong(parts[1]));
            }
            data.firstPk = Long.parseLong(parts[2]);
            data.count = Integer.parseInt(parts[3]);
            data.historicalSelection = IArchiveDao2.HistoricalSelection.valueOf(parts[4]);
            data.onlyRoots = Boolean.valueOf(parts[5]);
            HashSet<String[]> tags = new HashSet<String[]>();
            for (int i = 6; i < parts.length; ++i) {
                if (parts[i].length() <= 0) continue;
                tags.add(StringUtils.split((String)parts[i], (String)"#"));
            }
            data.tags = (String[][])tags.toArray((T[])new String[tags.size()][]);
            return data;
        }

        protected String[] getParts(ResumptionTokenData object) {
            String[] parts = new String[object.tags.length + 6];
            parts[0] = object.sinceDate == null ? "" : String.valueOf(object.sinceDate.getTime());
            parts[1] = object.toDate == null ? "" : String.valueOf(object.toDate.getTime());
            parts[2] = String.valueOf(object.firstPk);
            parts[3] = String.valueOf(object.count);
            parts[4] = String.valueOf((Object)object.historicalSelection);
            parts[5] = String.valueOf(object.onlyRoots);
            int i = 6;
            for (Object[] objectArray : object.tags) {
                parts[i] = StringUtils.join((Object[])objectArray, (String)"#");
                ++i;
            }
            return parts;
        }
    }

    protected static class ResumptionTokenData {
        public long firstPk;
        public long count;
        public String[][] tags;
        public Date sinceDate;
        public Date toDate;
        protected boolean onlyRoots;
        public IArchiveDao2.HistoricalSelection historicalSelection;

        protected ResumptionTokenData() {
        }
    }

    protected class ArchiveObjectRowMapper
    implements ParameterizedRowMapper<DbArchiveObject2Meta> {
        protected boolean withParent;

        public ArchiveObjectRowMapper(boolean withParent) {
            this.withParent = withParent;
        }

        public DbArchiveObject2Meta mapRow(ResultSet rs, int num) throws SQLException {
            DbArchiveObject2Meta result = new DbArchiveObject2Meta();
            result.setId(new YaddaObjectID(rs.getString("id"), rs.getString("version"), rs.getString("branch"), rs.getString("display_name")));
            result.setAlternativeId(new YaddaObjectID(rs.getString("alt_id"), rs.getString("alt_version"), rs.getString("alt_branch"), rs.getString("alt_display_name")));
            result.setPk(rs.getLong("_pk"));
            if (!StringUtils.isEmpty((String)rs.getString("parent__pk"))) {
                if (this.withParent) {
                    result.setParentId(new YaddaObjectID(rs.getString("join_parent_id"), rs.getString("join_parent_version"), rs.getString("join_parent_branch"), rs.getString("join_parent_display_name")));
                }
                result.setParentPk(rs.getLong("parent__pk"));
                result.setParentPosition(rs.getInt("parent_position"));
                result.setParentRelationName(rs.getString("parent_relation_name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("parent_id"))) {
                result.setParentId(new YaddaObjectID(rs.getString("parent_id"), rs.getString("parent_version"), rs.getString("parent_branch"), rs.getString("parent_display_name")));
                result.setParentPk(rs.getLong("parent__pk"));
                result.setParentPosition(rs.getInt("parent_position"));
                result.setParentRelationName(rs.getString("parent_relation_name"));
            }
            if (result.getParentPk() != null && result.getParentPk() == 0L) {
                ArchiveDao2.this.log.error((Object)"Errorneous read");
                result.setParentPk(null);
            }
            result.setStatus(YaddaObjectMeta.STATUS.valueOf((String)rs.getString("status")));
            result.setStructureType(rs.getString("schema_type"));
            result.setTimestamp(rs.getTimestamp("object_timestamp"));
            result.setType(rs.getString("object_type"));
            return result;
        }
    }
}

