/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db.operation;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import pl.edu.icm.yadda.service2.ArchiveContentPart;
import pl.edu.icm.yadda.service2.ArchiveContentPartMeta;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.YaddaObjectMeta;
import pl.edu.icm.yadda.service2.exception.AlreadyExistsException;
import pl.edu.icm.yadda.service2.exception.InvalidDataException;
import pl.edu.icm.yadda.service2.exception.LockException;
import pl.edu.icm.yadda.service2.exception.NotFoundException;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service2.storage.operation.DeleteOperation;
import pl.edu.icm.yadda.service2.storage.operation.StorageOperation;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectPath;
import pl.edu.icm.yadda.service3.archive.db.DbArchiveObject2Meta;
import pl.edu.icm.yadda.service3.archive.db.IArchiveDao2;
import pl.edu.icm.yadda.service3.archive.db.IContentPartDao2;
import pl.edu.icm.yadda.service3.storage.db.IOperationHandler;
import pl.edu.icm.yadda.service3.storage.db.IVersionNumberGenerator;
import pl.edu.icm.yadda.service3.storage.db.operation.TransactionContext;
import pl.edu.icm.yadda.service3.storage.operation.Merge2Operation;
import pl.edu.icm.yadda.service3.storage.operation.Save2Operation;
import pl.edu.icm.yadda.service3.storage.operation.SavePolicy;
import pl.edu.icm.yadda.service3.storage.operation.Store2Operation;
import pl.edu.icm.yadda.tools.id.UUIDGenerator;

public class Storage2OperationHandler
implements IOperationHandler {
    protected IArchiveDao2 dao;
    protected IContentPartDao2 contentPartDao;
    protected IVersionNumberGenerator versionGenerator;
    protected int directContentSizeLimit = 16384;

    @Override
    public YaddaObjectID run(TransactionContext tc, StorageOperation op) throws ServiceException {
        if (op instanceof Save2Operation) {
            return this.save(tc, (Save2Operation)op);
        }
        if (op instanceof Merge2Operation) {
            return this.merge(tc, (Merge2Operation)op);
        }
        if (op instanceof DeleteOperation) {
            return this.delete(tc, (DeleteOperation)op);
        }
        if (op instanceof Store2Operation) {
            return this.store((Store2Operation)op);
        }
        throw new ServiceException("Unsupported operation " + op.getName());
    }

    protected YaddaObjectID save(TransactionContext tc, Save2Operation op) throws ServiceException {
        ArchiveContentPartMeta part;
        long objectPk;
        HierarchyData hd;
        YaddaObjectID newObjectId;
        ArchiveObject2Meta newMeta = op.getMeta();
        Long parentPk = null;
        DbArchiveObject2Meta existingObject = null;
        if (op.getPath().hasParent()) {
            List<DbArchiveObject2Meta> objs = this.dao.retrieveObjectsFromIndex(op.getPath(), op.getSavePolicy() == SavePolicy.UPDATE_IF_NOT_DELETED);
            if (objs.isEmpty() || op.getSavePolicy() == SavePolicy.ALWAYS_CREATE) {
                existingObject = this.dao.readObject(newMeta.getId().getId(), false, false);
                if (existingObject != null) {
                    throw new ServiceException("Object with the same id exists somewhere else in the object tree");
                }
                if (op.getPath().hasParent()) {
                    parentPk = this.resolveParentPk(op);
                    newMeta.setParentRelationName(op.getPath().getName());
                }
            } else {
                switch (op.getSavePolicy()) {
                    case FAIL_IF_EXISTS: {
                        throw new AlreadyExistsException(op.getPath().toString(), "ArchiveObject");
                    }
                    case UPDATE_IF_EXISTS: 
                    case UPDATE_IF_NOT_DELETED: {
                        existingObject = objs.get(0);
                    }
                }
                existingObject = this.dao.readObject(existingObject.getPk(), false, true);
            }
        } else {
            existingObject = this.dao.readObject(op.getPath().getRootId().getId(), false, true);
            if (existingObject != null) {
                if (op.getSavePolicy() == SavePolicy.FAIL_IF_EXISTS || op.getSavePolicy() == SavePolicy.ALWAYS_CREATE) {
                    throw new AlreadyExistsException(op.getPath().getRootId().toString(), "ArchiveObject");
                }
                this.checkOptimisticLock(tc, op.getPath().getRootId(), existingObject.getId());
                if (op.getMeta().getId() != null && !op.getMeta().getId().getId().equals(op.getPath().getRootId().getId())) {
                    throw new InvalidDataException("Proposed meta id must be the same as the id provided in the path");
                }
            }
        }
        if (existingObject == null) {
            newObjectId = this.versionGenerator.generateNew(newMeta.getId());
            hd = new HierarchyData(newObjectId);
            if (parentPk != null) {
                HierarchyData parentHd = this.touch(tc, parentPk);
                int parentPosition = this.getFirstParentPosition(parentPk, newMeta.getParentRelationName());
                newMeta.setParentPosition(Integer.valueOf(parentPosition));
                hd.setParentData(parentHd, newMeta.getParentRelationName());
            }
            objectPk = this.createMeta(newMeta, newObjectId, null, parentPk, YaddaObjectMeta.STATUS.READY);
            this.indexObject(hd, objectPk);
            tc.getProcessedObjects().put(objectPk, hd);
        } else {
            existingObject.setTags(this.dao.readTags(existingObject.getPk()));
            if (existingObject.getParentPk() != null) {
                parentPk = existingObject.getParentPk();
                newMeta.setParentRelationName(existingObject.getParentRelationName());
            }
            objectPk = existingObject.getPk();
            if (tc.getProcessedObjects().containsKey(existingObject.getPk())) {
                newObjectId = existingObject.getId();
                this.updateMeta(newMeta, newObjectId, existingObject.getId(), existingObject, existingObject.getStatus());
            } else {
                newObjectId = this.nextVersionNumber((YaddaObjectMeta)existingObject);
                this.updateMeta(newMeta, newObjectId, existingObject.getId(), existingObject, YaddaObjectMeta.STATUS.READY);
                hd = this.updateParentAndSaveHistory(tc, existingObject);
                tc.getProcessedObjects().put(existingObject.getPk(), hd);
                tc.notifyUpdated(existingObject.getId(), newObjectId);
            }
            if (existingObject.getStatus().isDeleted()) {
                this.dao.updateIndexEntry(existingObject.getPk(), false);
            }
        }
        HashSet<String> tagsToAdd = new HashSet<String>(Arrays.asList(op.getMeta().getTags()));
        HashSet<String> tagsToDrop = new HashSet<String>(Arrays.asList(op.getTagsToDrop()));
        if (existingObject != null) {
            if (op.getTagPreservePolicy() == Save2Operation.TagPreservePolicy.REPLACE) {
                tagsToDrop.addAll(Arrays.asList(existingObject.getTags()));
            }
            tagsToAdd.removeAll(Arrays.asList(existingObject.getTags()));
        }
        this.dao.addTags(objectPk, tagsToAdd.toArray(new String[tagsToAdd.size()]));
        this.dao.dropTags(objectPk, tagsToDrop.toArray(new String[tagsToDrop.size()]));
        for (String string : op.getPartTypesToDrop()) {
            part = this.contentPartDao.getPartOfObject(objectPk, string);
            if (part == null) continue;
            this.contentPartDao.remove(part.getId());
        }
        if (existingObject != null) {
            for (String string : op.getPartTypes()) {
                part = this.contentPartDao.getPartOfObject(objectPk, string);
                if (part == null) continue;
                this.contentPartDao.remove(part.getId());
            }
        }
        for (String string : op.getNonDirectPartsToAdd()) {
            this.contentPartDao.bindPart(string.getId(), objectPk);
        }
        for (String string : op.getPartsToAdd()) {
            this.storeDirectContentPart(objectPk, (ArchiveContentPart)string);
        }
        return newObjectId;
    }

    protected YaddaObjectID merge(TransactionContext tc, Merge2Operation op) throws ServiceException {
        Long objectPk;
        YaddaObjectID objectId;
        HierarchyData hd;
        DbArchiveObject2Meta existingObject;
        YaddaObjectID existingObjectId = op.getExistingObjectId();
        ArchiveObject2Meta newObject = op.getNewObject();
        if (existingObjectId == null) {
            existingObject = this.dao.readObject(newObject.getId().getId(), false, true);
            if (existingObject != null) {
                throw new InvalidDataException("Trying to merge an object as new on the archive, but previous version exists.");
            }
            hd = new HierarchyData(newObject.getId());
            objectId = newObject.getId();
            Long parentPk = null;
            if (newObject.getParentId() != null) {
                DbArchiveObject2Meta parentObject = this.dao.readObject(newObject.getParentId().getId(), false, false);
                if (parentObject == null) {
                    throw new ServiceException("Parent not found" + newObject.getParentId().getId());
                }
                HierarchyData hierarchyData = this.touch(tc, parentObject.getPk());
                int parentPosition = this.getFirstParentPosition(parentObject.getPk(), newObject.getParentRelationName());
                newObject.setParentPosition(Integer.valueOf(parentPosition));
                hd.setParentData(hierarchyData, newObject.getParentRelationName());
                parentPk = parentObject.getPk();
            }
            objectPk = this.createMeta(newObject, objectId, newObject.getAlternativeId(), parentPk, newObject.getStatus().markMergedFlag());
            this.indexObject(hd, objectPk);
            this.dao.addTags(objectPk, newObject.getTags());
            tc.getProcessedObjects().put(objectPk, hd);
        } else {
            existingObject = this.dao.readObject(existingObjectId.getId(), false, true);
            if (existingObject == null) {
                throw new NotFoundException(existingObjectId.getId(), "ArchiveObject (merged object)");
            }
            existingObject.setTags(this.dao.readTags(existingObject.getPk()));
            this.checkOptimisticLock(tc, existingObjectId, existingObject.getId());
            objectPk = existingObject.getPk();
            if (tc.getProcessedObjects().containsKey(objectPk)) {
                throw new ServiceException("Object with ID " + existingObjectId + " was already processed in the batch, cannot merge.");
            }
            if (existingObjectId.equals((Object)newObject.getId())) {
                return newObject.getId();
            }
            if (newObject.getAlternativeId().equals((Object)existingObjectId)) {
                this.updateMeta(newObject, newObject.getId(), newObject.getAlternativeId(), existingObject, newObject.getStatus().markMergedFlag());
                hd = this.updateParentAndSaveHistory(tc, existingObject);
                objectId = newObject.getId();
            } else if (this.isOwned((YaddaObjectMeta)existingObject)) {
                objectId = this.versionGenerator.generateNext(existingObject.getId());
                this.updateMeta(newObject, objectId, newObject.getId(), existingObject, newObject.getStatus().markMergedFlag());
                hd = this.updateParentAndSaveHistory(tc, existingObject);
            } else {
                objectId = this.versionGenerator.generateNew(existingObject.getId());
                DbArchiveObject2Meta intermediateObject = this.updateMeta(existingObject, objectId, existingObject.getId(), existingObject, existingObject.getStatus().clearMergedFlag());
                this.updateParentAndSaveHistory(tc, existingObject);
                objectId = this.versionGenerator.generateNext(objectId);
                this.updateMeta(op.getNewObject(), objectId, newObject.getId(), intermediateObject, newObject.getStatus().markMergedFlag());
                hd = this.updateParentAndSaveHistory(tc, intermediateObject);
            }
            this.updateTags(existingObject.getPk(), existingObject.getTags(), newObject.getTags());
            for (ArchiveContentPartMeta part : this.contentPartDao.getPartsOfObject(existingObject.getPk())) {
                if (ArrayUtils.contains((Object[])op.getPartsToLeave(), (Object)part.getType())) continue;
                this.contentPartDao.remove(part.getId());
            }
        }
        tc.getProcessedObjects().put(objectPk, hd);
        for (ArchiveContentPartMeta archiveContentPartMeta : op.getNonDirectPartsToAdd()) {
            if (ArrayUtils.contains((Object[])op.getPartsToLeave(), (Object)archiveContentPartMeta.getType())) continue;
            this.contentPartDao.bindPart(archiveContentPartMeta.getId(), objectPk);
        }
        for (ArchiveContentPartMeta archiveContentPartMeta : op.getPartsToAdd()) {
            this.storeDirectContentPart(objectPk, (ArchiveContentPart)archiveContentPartMeta);
        }
        return objectId;
    }

    protected YaddaObjectID delete(TransactionContext tc, DeleteOperation op) throws ServiceException {
        if (op.getObjectId().getId().equals("pl.edu.icm.yadda.service3.archive.meta")) {
            return op.getObjectId();
        }
        if (tc.isAlreadyDeleted(op.getObjectId().getId())) {
            return tc.getDeletedObjectId(op.getObjectId().getId());
        }
        DbArchiveObject2Meta existingObject = this.dao.readObject(op.getObjectId().getId(), true, true);
        if (existingObject == null) {
            throw new NotFoundException(op.getObjectId().toString(), "ArchiveObject");
        }
        existingObject.setTags(this.dao.readTags(existingObject.getPk()));
        this.checkOptimisticLock(tc, op.getObjectId(), existingObject.getId());
        YaddaObjectID newObjectId = this.nextVersionNumber((YaddaObjectMeta)existingObject);
        this.updateMeta(existingObject, newObjectId, existingObject.getId(), existingObject, YaddaObjectMeta.STATUS.DELETED);
        HierarchyData hd = this.updateParentAndSaveHistory(tc, existingObject);
        this.dao.updateIndexEntry(existingObject.getPk(), true);
        tc.getProcessedObjects().put(existingObject.getPk(), hd);
        tc.notifyUpdated(existingObject.getId(), newObjectId);
        for (ArchiveContentPartMeta part : this.contentPartDao.getPartsOfObject(existingObject.getPk())) {
            this.contentPartDao.remove(part.getId());
        }
        if (op.getPolicy() == DeleteOperation.DeletePolicy.CASCADE_DELETE || op.getPolicy() == DeleteOperation.DeletePolicy.FAIL_IF_CHILDREN) {
            Map<String, List<YaddaObjectID>> children = this.dao.readChildren(existingObject.getPk(), true);
            LinkedList<YaddaObjectID> flatChildren = new LinkedList<YaddaObjectID>();
            for (List<YaddaObjectID> part : children.values()) {
                flatChildren.addAll(part);
            }
            if (!flatChildren.isEmpty()) {
                switch (op.getPolicy()) {
                    case CASCADE_DELETE: {
                        for (YaddaObjectID childId : flatChildren) {
                            this.delete(tc, new DeleteOperation(new YaddaObjectID(childId.getId()), op.getPolicy()));
                        }
                        break;
                    }
                    case FAIL_IF_CHILDREN: {
                        throw new ServiceException("Deletion failed. There are children of the object with id " + op.getObjectId());
                    }
                }
            }
        }
        return newObjectId;
    }

    protected void checkOptimisticLock(TransactionContext tc, YaddaObjectID lockId, YaddaObjectID existingId) throws LockException {
        YaddaObjectID currentId = tc.isAlreadyUpdated(lockId.getId()) ? tc.getOldId(lockId.getId()) : existingId;
        if (lockId.isVersioned() && !lockId.equals((Object)currentId)) {
            throw new LockException(lockId, currentId);
        }
    }

    protected YaddaObjectID store(Store2Operation op) throws ServiceException {
        DbArchiveObject2Meta existingObject = this.dao.readObject(op.getMeta().getId(), false);
        if (existingObject != null) {
            return existingObject.getId();
        }
        long pk = this.dao.createHistoryObject(op.getMeta().getParentId(), op.getMeta());
        this.dao.addTags(pk, op.getMeta().getTags());
        return op.getMeta().getId();
    }

    protected long resolveParentPk(Save2Operation op) throws ServiceException {
        ArchiveObjectPath parentPath = op.getPath().getParent();
        if (parentPath.getPath() != null && parentPath.hasParent()) {
            List<Long> parents = this.dao.retrieveIndexEntries(parentPath, true);
            if (parents.isEmpty()) {
                throw new ServiceException("Parent not found (" + parentPath + ")");
            }
            if (parents.size() > 1) {
                throw new ServiceException("Too many possible parents");
            }
            return parents.get(0);
        }
        DbArchiveObject2Meta meta = this.dao.readObject(op.getPath().getRootId().getId(), false, true);
        if (meta == null) {
            throw new ServiceException("Parent not found");
        }
        return meta.getPk();
    }

    protected void updateTags(long id, String[] existingTagArray, String[] expectedTagArray) throws ServiceException {
        HashSet<String> existingTags = new HashSet<String>(Arrays.asList(existingTagArray));
        HashSet<String> expectedTags = new HashSet<String>(Arrays.asList(expectedTagArray));
        HashSet<String> tagsToAdd = new HashSet<String>(expectedTags);
        tagsToAdd.removeAll(existingTags);
        HashSet<String> tagsToDrop = new HashSet<String>(existingTags);
        tagsToDrop.removeAll(expectedTags);
        this.dao.addTags(id, tagsToAdd.toArray(new String[tagsToAdd.size()]));
        this.dao.dropTags(id, tagsToDrop.toArray(new String[tagsToDrop.size()]));
    }

    protected long createMeta(ArchiveObject2Meta meta, YaddaObjectID newId, YaddaObjectID alternativeId, Long parentPk, YaddaObjectMeta.STATUS status) throws ServiceException {
        ArchiveObject2Meta targetMeta = new ArchiveObject2Meta(meta);
        targetMeta.setId(newId);
        targetMeta.setAlternativeId(alternativeId);
        targetMeta.setStatus(status);
        targetMeta.setTimestamp(new Date());
        targetMeta.setParentPosition(meta.getParentPosition());
        targetMeta.setParentRelationName(meta.getParentRelationName());
        if (parentPk != null) {
            return this.dao.createObject(parentPk, targetMeta);
        }
        return this.dao.createRootObject(targetMeta);
    }

    protected DbArchiveObject2Meta updateMeta(ArchiveObject2Meta metaToUpdate, YaddaObjectID newId, YaddaObjectID altId, DbArchiveObject2Meta previousVersion, YaddaObjectMeta.STATUS status) throws ServiceException {
        DbArchiveObject2Meta targetMeta = new DbArchiveObject2Meta(previousVersion.getPk(), previousVersion.getParentPk(), metaToUpdate);
        targetMeta.setId(newId);
        targetMeta.setAlternativeId(altId);
        targetMeta.setStatus(status);
        targetMeta.setTimestamp(new Date());
        this.dao.updateMeta(previousVersion.getPk(), targetMeta);
        return targetMeta;
    }

    protected long saveHistory(DbArchiveObject2Meta existingObject, YaddaObjectID parentId) throws ServiceException {
        long historyPk = this.dao.createHistoryObject(parentId, existingObject);
        this.dao.addTags(historyPk, existingObject.getTags());
        return historyPk;
    }

    protected int getFirstParentPosition(long parentPk, String parentRelationName) throws ServiceException {
        List<YaddaObjectID> children = this.dao.readChildren(parentPk, parentRelationName);
        return children.size();
    }

    protected HierarchyData updateParentAndSaveHistory(TransactionContext tc, DbArchiveObject2Meta object) throws ServiceException {
        YaddaObjectID historyParentId = null;
        HierarchyData hd = new HierarchyData(object.getId());
        if (object.getParentPk() != null) {
            HierarchyData parentHd = this.touch(tc, object.getParentPk());
            hd.setParentData(parentHd, object.getParentRelationName());
            historyParentId = hd.previous.id;
        }
        this.saveHistory(object, historyParentId);
        return hd;
    }

    protected HierarchyData touch(TransactionContext tc, long pk) throws ServiceException {
        if (tc.getProcessedObjects().containsKey(pk)) {
            return tc.getProcessedObjects().get(pk);
        }
        DbArchiveObject2Meta object = this.dao.readObject(pk, false, true);
        if (object == null) {
            throw new ServiceException("Parent not found");
        }
        object.setTags(this.dao.readTags(pk));
        YaddaObjectID historyParentId = null;
        HierarchyData hd = new HierarchyData(object.getId());
        if (object.getParentPk() != null) {
            HierarchyData parentHd = this.touch(tc, object.getParentPk());
            hd.setParentData(parentHd, object.getParentRelationName());
            historyParentId = hd.previous.id;
        }
        YaddaObjectID newId = this.nextVersionNumber((YaddaObjectMeta)object);
        this.updateMeta(object, newId, object.getId(), object, YaddaObjectMeta.STATUS.READY);
        this.saveHistory(object, historyParentId);
        tc.getProcessedObjects().put(object.getPk(), hd);
        tc.notifyUpdated(object.getId(), newId);
        return hd;
    }

    protected void indexObject(HierarchyData hd, long pk) throws ServiceException {
        LinkedList<String> path = new LinkedList<String>();
        HierarchyData currentHd = hd;
        while (currentHd.previous != null) {
            path.add(0, currentHd.relationName);
            currentHd = currentHd.previous;
            this.dao.createIndexEntry(new ArchiveObjectPath(new YaddaObjectID(currentHd.id.getId()), path.toArray(new String[path.size()])), pk);
        }
    }

    protected YaddaObjectID nextVersionNumber(YaddaObjectMeta obj) {
        return this.isOwned(obj) ? this.versionGenerator.generateNext(obj.getId()) : this.versionGenerator.generateNew(obj.getId().getId(), obj.getId().getDisplayName());
    }

    protected boolean isOwned(YaddaObjectMeta meta) {
        return !meta.getStatus().isMerged();
    }

    protected void storeDirectContentPart(long ownerPk, ArchiveContentPart cp) throws ServiceException {
        String id = new UUIDGenerator().generate((Object)cp);
        if (cp.getData().length <= this.directContentSizeLimit) {
            this.contentPartDao.createDirect(id, ownerPk, cp.getType(), cp.getData(), cp.getMime());
        } else {
            String handler = this.contentPartDao.create(id, cp.getType(), cp.getMime());
            this.contentPartDao.write(handler, 0L, cp.getData(), 0, cp.getData().length);
            this.contentPartDao.commit(handler);
            this.contentPartDao.bindPart(id, ownerPk);
        }
    }

    @Override
    public boolean isSupported(StorageOperation o) {
        return o instanceof Save2Operation || o instanceof Merge2Operation || o instanceof DeleteOperation || o instanceof Store2Operation;
    }

    public IArchiveDao2 getDao() {
        return this.dao;
    }

    public void setDao(IArchiveDao2 dao) {
        this.dao = dao;
    }

    public void setContentPartDao(IContentPartDao2 contentPartDao) {
        this.contentPartDao = contentPartDao;
    }

    public void setVersionNumberGenerator(IVersionNumberGenerator verGen) {
        this.versionGenerator = verGen;
    }

    protected class HierarchyData {
        YaddaObjectID id;
        String relationName;
        HierarchyData previous;

        public HierarchyData(YaddaObjectID id) {
            this.id = id;
        }

        public void setParentData(HierarchyData parent, String relationName) {
            this.previous = parent;
            this.relationName = relationName;
        }
    }
}

