/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import pl.edu.icm.yadda.service2.ArchiveContentPartFacade;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.catalog.CountingIterator;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;
import pl.edu.icm.yadda.service3.archive.impl.ArchiveFacade2;

public class ReaderPerformanceTest {
    protected IArchiveFacade2 archiveFacade2;
    protected Queue<String> path = new ConcurrentLinkedQueue<String>();
    protected String partToFetch = "DATA";
    protected long startTime;
    protected volatile int fetched = 0;
    protected volatile long fetchedBytes = 0L;

    protected void doTest(int objectAmount, int threadAmount) throws InterruptedException, ServiceException {
        int i;
        System.out.println("Choosing objects to fetch");
        CountingIterator objs = this.archiveFacade2.listObjects(null, null, null, false);
        int i2 = 0;
        while (i2 < objectAmount && objs.hasNext()) {
            ArchiveObject2Meta meta = (ArchiveObject2Meta)objs.next();
            if (meta.getStatus().isDeleted()) continue;
            this.path.offer(meta.getId().getId());
            ++i2;
        }
        System.out.println("Fetching the objects");
        FetchingThread[] threads = new FetchingThread[threadAmount];
        this.startTime = System.currentTimeMillis();
        for (i = 0; i < threadAmount; ++i) {
            threads[i] = new FetchingThread();
            threads[i].start();
        }
        System.out.println("Collecting results");
        for (i = 0; i < threadAmount; ++i) {
            threads[i].join();
            System.out.println("Thread " + i);
            System.out.println("==============");
            System.out.println(1000L * (long)threads[i].threadFetched / (threads[i].threadEndTime - threads[i].threadStartTime) + " objs/s");
            System.out.println("So far " + 1000L * threads[i].threadFetchedBytes / (threads[i].threadEndTime - threads[i].threadStartTime) + " b/s");
        }
        System.out.println("Totally ");
        System.out.println("==============");
        System.out.println(1000L * (long)this.fetched / (System.currentTimeMillis() - this.startTime) + " objs/s");
        System.out.println("So far " + 1000L * this.fetchedBytes / (System.currentTimeMillis() - this.startTime) + " b/s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String contextPath;
        Options options = new Options();
        options.addOption("t", true, "specify custom context file");
        options.addOption("h", false, "show help");
        options.addOption("c", true, "specify amount of client threads");
        options.addOption("o", true, "specify amount of objects to read");
        PosixParser parser = new PosixParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("import.sh", options);
            System.exit(0);
        }
        LinkedList tags = new LinkedList();
        String string = contextPath = cl.hasOption("t") ? cl.getOptionValue("t") : "classpath:pl/edu/icm/yadda/service3/tools/oss-cli-context.xml";
        if (cl.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("import.sh", options);
            System.exit(0);
        }
        int threadAmount = cl.hasOption("c") ? Integer.parseInt(cl.getOptionValue("c")) : 1;
        int dataAmount = cl.hasOption("o") ? Integer.parseInt(cl.getOptionValue("o")) : 1000;
        try {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contextPath);
            ArchiveFacade2 af = (ArchiveFacade2)context.getBean("archiveFacade3");
            ReaderPerformanceTest rpt = new ReaderPerformanceTest();
            rpt.archiveFacade2 = af;
            rpt.doTest(dataAmount, threadAmount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public class FetchingThread
    extends Thread {
        private int threadFetched = 0;
        private long threadFetchedBytes = 0L;
        private long threadStartTime;
        private long threadEndTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String id;
            this.threadStartTime = System.currentTimeMillis();
            while ((id = ReaderPerformanceTest.this.path.poll()) != null) {
                try {
                    ArchiveObjectFacade obj = ReaderPerformanceTest.this.archiveFacade2.getObject(new YaddaObjectID(id), new String[]{ReaderPerformanceTest.this.partToFetch}, false);
                    ArchiveContentPartFacade cpi = obj.getPart(ReaderPerformanceTest.this.partToFetch);
                    byte[] buffer = new byte[65536];
                    if (cpi != null) {
                        int bytes = 0;
                        FetchingThread fetchingThread = this;
                        synchronized (fetchingThread) {
                            ++ReaderPerformanceTest.this.fetched;
                            ++this.threadFetched;
                        }
                        while ((bytes = cpi.getData().read(buffer)) > 0) {
                            fetchingThread = this;
                            synchronized (fetchingThread) {
                                ReaderPerformanceTest.this.fetchedBytes += (long)bytes;
                                this.threadFetchedBytes += (long)bytes;
                            }
                        }
                    }
                    System.out.println("Readed object" + obj.getId());
                    if (ReaderPerformanceTest.this.fetched % 100 != 0) continue;
                    System.out.println("Readed " + ReaderPerformanceTest.this.fetched + " objs");
                }
                catch (ServiceException e) {
                    System.out.println("Raised exception" + (Object)((Object)e));
                }
                catch (IOException e) {
                    System.out.println("Raised exception" + e);
                }
            }
            this.threadEndTime = System.currentTimeMillis();
        }
    }
}

