/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.sts.lls;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class FileUtils {
    public static String getFileContent(String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            String line;
            File file = null;
            URL fileURL = FileUtils.class.getResource("/" + filePath);
            file = fileURL != null ? new File(fileURL.getPath()) : new File(filePath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer strBuff = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                strBuff.append(line);
            }
            return strBuff.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertStreamToString(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static byte[] convertStreamToByteArray(InputStream inputStream) throws IOException {
        int length = inputStream.available();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("InputStream is to large, larger then Integer.MAX_VALUE");
        }
        byte[] bytes = new byte[length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = inputStream.read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read InputStream ");
        }
        inputStream.close();
        return bytes;
    }
}

