/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.sts.lls;

import eu.dnetlib.data.sts.lls.SimpleDigitalObject;
import eu.dnetlib.data.sts.lls.StoringStatusResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.service2.ArchiveContentPartFacade;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.catalog.CountingIterator;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service2.storage.IStorage;
import pl.edu.icm.yadda.service2.storage.operation.DeleteOperation;
import pl.edu.icm.yadda.service2.storage.operation.StorageOperation;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;
import pl.edu.icm.yadda.service3.storage.IStorageFacade2;
import pl.edu.icm.yadda.service3.storage.operation.Save2Operation;

public class LLSStorageFacade {
    public static final String STORE_DATA_STRUCTURE_SUBTYPE_OBJECTS = "objects";
    public static final String STORE_DATA_STRUCTURE_SUBTYPE_PROFILES = "profiles";
    public static final String STORE_DATA_STRUCTURE_SUBTYPE_SDOS = "sdos";
    protected static final Log log = LogFactory.getLog(LLSStorageFacade.class);
    public static final String protocol = "yar://";
    private IStorageFacade2 llsStore;
    private IArchiveFacade2 llsAccess;

    public void init() throws Exception {
    }

    public String createStoreDataStructure(String storeDataStructId) throws Exception {
        try {
            YaddaObjectID yaddaStoredDataStructerId = new YaddaObjectID(storeDataStructId);
            ArchiveObjectFacade checkStoreDataStructure = this.llsAccess.getOptionalObject(yaddaStoredDataStructerId, null, false, false);
            if (checkStoreDataStructure != null && !checkStoreDataStructure.getStatus().isDeleted()) {
                yaddaStoredDataStructerId = checkStoreDataStructure.getId();
                String msg = "The Store Data Structure is already present: " + yaddaStoredDataStructerId + "(STATUS:" + checkStoreDataStructure.getStatus() + ")";
                log.warn((Object)msg);
            } else {
                if (checkStoreDataStructure != null && !"".equals(checkStoreDataStructure) && checkStoreDataStructure.getStatus().isDeleted()) {
                    log.info((Object)("Recreating Store Data Structure: " + storeDataStructId));
                } else {
                    log.info((Object)("Creating new Store Data Structure: " + storeDataStructId));
                }
                ArchiveObjectFacade stds = new ArchiveObjectFacade();
                stds.setId(new YaddaObjectID(storeDataStructId));
                stds.setType("ROOT");
                stds.setStructureType("stdsDirectory");
                stds.setTags(new String[]{"stds"});
                yaddaStoredDataStructerId = this.llsStore.saveObject(protocol + storeDataStructId, stds, null, null);
                ArchiveObjectFacade stdsProfiles = new ArchiveObjectFacade();
                stdsProfiles.setId(new YaddaObjectID(UUID.randomUUID().toString()));
                stdsProfiles.setType("DIRECTORY");
                stdsProfiles.setStructureType("profilesDirectory");
                this.llsStore.saveObject(protocol + storeDataStructId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_PROFILES, stdsProfiles, null, null);
                ArchiveObjectFacade stdsObjects = new ArchiveObjectFacade();
                stdsObjects.setId(new YaddaObjectID(UUID.randomUUID().toString()));
                stdsObjects.setType("DIRECTORY");
                stdsObjects.setStructureType("objectsDirectory");
                this.llsStore.saveObject(protocol + storeDataStructId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_OBJECTS, stdsObjects, null, null);
                ArchiveObjectFacade stdsSDOs = new ArchiveObjectFacade();
                stdsSDOs.setId(new YaddaObjectID(UUID.randomUUID().toString()));
                stdsSDOs.setType("DIRECTORY");
                stdsSDOs.setStructureType("sdosDirectory");
                this.llsStore.saveObject(protocol + storeDataStructId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS, stdsSDOs, null, null);
            }
            return yaddaStoredDataStructerId.getId();
        }
        catch (ServiceException e) {
            log.error((Object)("Problem by creating Store Data Structure " + storeDataStructId + " Exception: " + e.getMessage()));
            throw new Exception("Problem by creating Store Data Structure " + storeDataStructId, e);
        }
    }

    public boolean removeStoreDataStructure(String storeDataStructId) throws Exception {
        ArchiveObjectFacade objectToDelete;
        block3: {
            try {
                objectToDelete = this.llsAccess.getOptionalObject(new YaddaObjectID(storeDataStructId), null, false, false);
                if (objectToDelete != null) break block3;
                log.warn((Object)("Store Data Structure could not be deleted. " + storeDataStructId + " not found"));
                return false;
            }
            catch (ServiceException e) {
                log.error((Object)("Problem by deleting Store Data Structure " + storeDataStructId + " Exception: " + e.getMessage()));
                throw new Exception("Problem by deleting Store Data Structure " + storeDataStructId, e);
            }
        }
        log.debug((Object)("Deleting Store Data Structure " + objectToDelete.getId()));
        DeleteOperation deleteOperation = new DeleteOperation(objectToDelete.getId(), DeleteOperation.DeletePolicy.CASCADE_DELETE);
        this.llsStore.executeOperation((StorageOperation)deleteOperation);
        log.debug((Object)("The Store Data Structure " + storeDataStructId + " deleted"));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String storeObject(String storeDataStructId, SimpleDigitalObject sdo) throws Exception {
        String basicURI = protocol + storeDataStructId + "/" + sdo.getDataStructureType();
        String objectURI = String.valueOf(basicURI) + "/" + sdo.getObjectName();
        try {
            String objectID = UUID.randomUUID().toString();
            YaddaObjectID yaddaObjectId = new YaddaObjectID(objectID);
            ArchiveObjectFacade object = new ArchiveObjectFacade();
            object.setId(yaddaObjectId);
            object.setType("FILE");
            object.setStructureType(sdo.getDataStructureType());
            object.addPart("BasicContent", sdo.getObjectMimeType(), (InputStream)new ByteArrayInputStream(sdo.getObjectLocation()));
            if (sdo.getObjectTags() == null) {
                object.setTags(new String[]{sdo.getObjectMimeType(), sdo.getDataStructureType()});
            } else {
                object.setTags(sdo.getObjectTags());
            }
            if (STORE_DATA_STRUCTURE_SUBTYPE_OBJECTS.equals(sdo.getDataStructureType())) {
                ArchiveObjectFacade sdoProfileObject = this.createSDOProfile(sdo, objectID, objectURI);
                if (sdoProfileObject == null) {
                    log.error((Object)"Object not stored, could not create SDO XML Profile");
                    return null;
                }
                String sdoProfileURI = protocol + storeDataStructId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS + "/" + sdo.getObjectName() + "-" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS;
                this.llsStore.saveObject(sdoProfileURI, sdoProfileObject, null, null);
            }
            yaddaObjectId = this.llsStore.saveObject(objectURI, object, null, null);
            log.debug((Object)("The Object '" + objectURI + "' stored in " + "Store Data Structure " + storeDataStructId));
            return yaddaObjectId.getId();
        }
        catch (ServiceException e) {
            log.error((Object)("Problem by storing object '" + objectURI + "' in " + "Store Data Structure " + storeDataStructId + " ;Exception: " + (Object)((Object)e)));
            throw new Exception("Problem by storing object '" + objectURI + "'in Store Data Structure " + storeDataStructId + ": " + (Object)((Object)e));
        }
    }

    public StoringStatusResponse storeObjectsBatch(String storeDataStructureId, Iterator<SimpleDigitalObject> objectsForStoring) throws Exception {
        log.debug((Object)"Preparing objects for storing");
        String objectURI = null;
        String sdoProfileURI = null;
        StoringStatusResponse storingResponse = new StoringStatusResponse();
        int processedObjects = 0;
        try {
            LinkedList<Save2Operation> ops = new LinkedList<Save2Operation>();
            HashMap<String, Long> storedObjectTypes = new HashMap<String, Long>();
            while (objectsForStoring.hasNext()) {
                SimpleDigitalObject sdo = objectsForStoring.next();
                ArchiveObjectFacade object = new ArchiveObjectFacade();
                String objectID = UUID.randomUUID().toString();
                objectURI = protocol + storeDataStructureId + "/" + sdo.getDataStructureType() + "/" + sdo.getObjectName();
                object.setId(new YaddaObjectID(objectID));
                object.setType("FILE");
                object.setStructureType(sdo.getDataStructureType());
                object.addPart("BasicContent", sdo.getObjectMimeType(), (InputStream)new ByteArrayInputStream(sdo.getObjectLocation()));
                object.setTags(new String[]{sdo.getObjectMimeType(), sdo.getDataStructureType()});
                ArchiveObjectFacade sdoProfileObject = this.createSDOProfile(sdo, objectID, objectURI);
                if (sdoProfileObject == null) {
                    log.error((Object)"Object not stored, could not create SDO XML Profile");
                } else {
                    ops.add(this.llsStore.buildSaveOperation(objectURI, object, null, null));
                    sdoProfileURI = protocol + storeDataStructureId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS + "/" + sdo.getObjectName() + "-" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS;
                    ops.add(this.llsStore.buildSaveOperation(sdoProfileURI, sdoProfileObject, null, null));
                }
                Long currentValue = storedObjectTypes.get(sdo.getObjectMimeType());
                currentValue = currentValue == null ? Long.valueOf("1") : Long.valueOf(currentValue + 1L);
                storedObjectTypes.put(sdo.getObjectMimeType(), currentValue);
                ++processedObjects;
            }
            log.debug((Object)"Sending objects to the LLS");
            Collection status = this.llsStore.batch(ops, IStorage.EXECUTION_MODE.TRANSACTIONAL);
            log.debug((Object)(String.valueOf(status.size()) + " objects stored"));
            int storedObjects = status.size() / 2;
            storingResponse.setProcessedObjects(processedObjects);
            storingResponse.setStorredObjects(storedObjects);
            storingResponse.setIgnorredObjects(processedObjects - storedObjects);
            storingResponse.setStoredObjectTypes(storedObjectTypes);
            Iterator iter = status.iterator();
            while (iter.hasNext()) {
                log.debug((Object)("OBID: " + iter.next()));
            }
            return storingResponse;
        }
        catch (ServiceException e) {
            String errMsg = "Problem by storing object '" + objectURI + "' in " + "Store Data Structure " + storeDataStructureId + " ;Exception: " + e.getMessage();
            log.error((Object)errMsg);
            throw new Exception(errMsg, e);
        }
    }

    private ArchiveObjectFacade createSDOProfile(SimpleDigitalObject sdo, String objectID, String objectUri) {
        ArchiveObjectFacade sdoObject = new ArchiveObjectFacade();
        String sdoXml = "TESTTESTTESTTTEST";
        log.debug((Object)sdoXml);
        InputStream sdoXmlIS = null;
        try {
            byte[] buffer = sdoXml.getBytes("UTF-8");
            sdoXmlIS = new ByteArrayInputStream(buffer);
            sdoObject.setId(new YaddaObjectID(UUID.randomUUID().toString()));
            sdoObject.setType("FILE");
            sdoObject.setStructureType(STORE_DATA_STRUCTURE_SUBTYPE_SDOS);
            sdoObject.addPart("BasicContent", "xml", sdoXmlIS);
            sdoObject.setTags(new String[]{"xml", STORE_DATA_STRUCTURE_SUBTYPE_SDOS});
            sdoXmlIS.close();
            ArchiveObjectFacade archiveObjectFacade = sdoObject;
            return archiveObjectFacade;
        }
        catch (IOException e) {
            log.error((Object)("The following problem occured by creating SDO profile " + e.getMessage()));
            return null;
        }
        finally {
            try {
                sdoXmlIS.close();
            }
            catch (IOException e) {
                log.error((Object)("Unable to close input stream for SDO profile!" + e.getMessage()));
            }
        }
    }

    public boolean removeObject(String storeDataStructId, SimpleDigitalObject sdo) throws Exception {
        ArchiveObject2Meta objectToDelete;
        String objectURI;
        block3: {
            objectURI = protocol + storeDataStructId + "/" + sdo.getDataStructureType() + "/" + sdo.getObjectName();
            try {
                objectToDelete = this.llsAccess.queryUniqueObject(objectURI, true);
                if (!objectToDelete.equals(null) || objectToDelete.getId() != null) break block3;
                log.warn((Object)("The Object '" + objectURI + "' can not be deleted. " + "Not found in Store Data Structure " + storeDataStructId));
                return false;
            }
            catch (ServiceException e) {
                log.error((Object)("Problem by removing object '" + objectURI + "' from " + "Store Data Structure " + storeDataStructId + " Exception: " + e.getMessage()));
                throw new Exception("Problem by removing '" + objectURI + "' object from Store Data Structure " + storeDataStructId, e);
            }
        }
        this.llsStore.deleteObject(objectToDelete.getId());
        log.debug((Object)("The Object '" + objectURI + "' deleted from " + "Store Data Structure " + storeDataStructId));
        return true;
    }

    public boolean cleanStoreDataStructure(String storeDataStructureId) throws Exception {
        log.debug((Object)("Cleaning Store Data Structure content: " + storeDataStructureId));
        String objectsURI = protocol + storeDataStructureId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_OBJECTS;
        String sdosURI = protocol + storeDataStructureId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS;
        try {
            ArchiveObject2Meta objectToDelete = this.llsAccess.queryUniqueObject(objectsURI, true);
            if (objectToDelete == null || objectToDelete.getId() == null) {
                log.warn((Object)("Object '" + objectsURI + "' can not be deleted. " + "Not found in Store Data Structure " + storeDataStructureId));
            } else {
                DeleteOperation deleteOperation = new DeleteOperation(objectToDelete.getId(), DeleteOperation.DeletePolicy.CASCADE_DELETE);
                this.llsStore.executeOperation((StorageOperation)deleteOperation);
                log.debug((Object)("Object '" + objectsURI + "' deleted from " + "Store Data Structure " + storeDataStructureId));
                ArchiveObjectFacade stdsObjects = new ArchiveObjectFacade();
                stdsObjects.setId(new YaddaObjectID(STORE_DATA_STRUCTURE_SUBTYPE_OBJECTS));
                stdsObjects.setType("DIRECTORY");
                stdsObjects.setStructureType("objectsDirectory");
                this.llsStore.saveObject(protocol + storeDataStructureId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_OBJECTS, stdsObjects, null, null);
            }
            ArchiveObject2Meta sdosToDelete = this.llsAccess.queryUniqueObject(sdosURI, true);
            if (sdosToDelete == null || sdosToDelete.getId() == null) {
                log.warn((Object)("Object '" + sdosURI + "' can not be deleted. " + "Not found in Store Data Structure " + storeDataStructureId));
            } else {
                DeleteOperation deleteSDOSOperation = new DeleteOperation(sdosToDelete.getId(), DeleteOperation.DeletePolicy.CASCADE_DELETE);
                this.llsStore.executeOperation((StorageOperation)deleteSDOSOperation);
                log.debug((Object)("Object '" + sdosURI + "' deleted from " + "Store Data Structure " + storeDataStructureId));
                ArchiveObjectFacade stdsSDOs = new ArchiveObjectFacade();
                stdsSDOs.setId(new YaddaObjectID(STORE_DATA_STRUCTURE_SUBTYPE_SDOS));
                stdsSDOs.setType("DIRECTORY");
                stdsSDOs.setStructureType("sdosDirectory");
                this.llsStore.saveObject(protocol + storeDataStructureId + "/" + STORE_DATA_STRUCTURE_SUBTYPE_SDOS, stdsSDOs, null, null);
            }
            log.debug((Object)"Empty object containers (sdos,objects) created in the Store Data Structure");
            return true;
        }
        catch (ServiceException e) {
            log.error((Object)("Problem by cleaning Store Data Structure " + storeDataStructureId + " Exception: " + e.getMessage()));
            return false;
        }
    }

    public Iterator<String> performSimpleSearch(String[] searchedTags) throws Exception {
        CountingIterator response = null;
        try {
            response = this.llsAccess.listObjects(null, null, searchedTags, false);
        }
        catch (ServiceException e) {
            throw new Exception("Failed to search storage", e);
        }
        if (response == null) {
            log.warn((Object)"No objects found in the storage!");
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        while (response.hasNext()) {
            ArchiveObject2Meta object = (ArchiveObject2Meta)response.next();
            if (object.getStatus().isDeleted()) continue;
            results.add(object.getId().getId());
        }
        if (results == null) {
            log.warn((Object)"No objects found in the storage!");
            return null;
        }
        return results.iterator();
    }

    public InputStream getSingleObject(String objectName) throws Exception {
        if (!objectName.contains(protocol)) {
            objectName = protocol + objectName;
        }
        log.debug((Object)("Searching for object: " + objectName));
        try {
            ArchiveObject2Meta searchObject = this.llsAccess.queryUniqueObject(objectName, true);
            if (searchObject != null) {
                ArchiveObjectFacade foundObject = this.llsAccess.getObject(searchObject.getId(), new String[]{"BasicContent"}, false);
                ArchiveContentPartFacade contentPartFacade = foundObject.getPart("BasicContent");
                InputStream is = contentPartFacade.getData();
                return is;
            }
            String message = "Object " + objectName + " " + "not found in the storage.";
            log.error((Object)message);
            throw new Exception(message);
        }
        catch (ServiceException e) {
            log.debug((Object)("Problem by getting object " + objectName + " from the storage: " + (Object)((Object)e)));
            return null;
        }
    }

    public IStorageFacade2 getLlsStorageFacade() {
        return this.llsStore;
    }

    public void setLlsStorageFacade(IStorageFacade2 llsStore) {
        this.llsStore = llsStore;
    }

    public IArchiveFacade2 getLlsArchiveFacade() {
        return this.llsAccess;
    }

    public void setLlsArchiveFacade(IArchiveFacade2 llsAccess) {
        this.llsAccess = llsAccess;
    }
}

