/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.sts.lls;

import eu.dnetlib.data.sts.lls.FileUtils;
import eu.dnetlib.data.sts.lls.LLSStorageFacade;
import eu.dnetlib.data.sts.lls.SimpleDigitalObject;
import eu.dnetlib.data.sts.lls.StoringStatusResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import pl.edu.icm.yadda.spring.utils.SpringUtils;

public class LLSStoreFacadeTest {
    ApplicationContext ctx;
    private LLSStorageFacade llsStoreFacade;

    @Before
    public void setUp() {
        this.ctx = SpringUtils.getSpringContext((String)"classpath:/eu/dnetlib/data/sts/lls/ctx.xml");
        this.llsStoreFacade = (LLSStorageFacade)this.ctx.getBean("oss");
    }

    @Test
    public void testCreateDeleteStoreDataStructure() throws Exception {
        String storeDataStructId = "testCreateDeleteStoreDataStructure";
        String newStoreDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
        Assert.assertNotNull((String)"Store Data Structure not created", (Object)newStoreDataStructId);
        boolean status = this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
        Assert.assertTrue((String)"Store Data Structure not deleted", (boolean)status);
    }

    @Test
    public void testStoreObject() throws Exception {
        String dummyObjectPath = "/tmp/dummyObject";
        File file = new File(dummyObjectPath);
        String storeDataStructId = "testStoreObjectStructure";
        String newStoreDataStructId = null;
        try {
            try {
                if (!file.exists()) {
                    Assert.assertTrue((String)("Can not create file required for testing: " + dummyObjectPath), (boolean)file.createNewFile());
                }
                newStoreDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
                Assert.assertNotNull((Object)newStoreDataStructId);
                System.out.println("The Store Data Structure identifier:" + newStoreDataStructId);
                SimpleDigitalObject sdo = new SimpleDigitalObject();
                sdo.setDataStructureType("objects");
                sdo.setObjectLocation(FileUtils.convertStreamToByteArray(new FileInputStream(dummyObjectPath)));
                sdo.setObjectMimeType("application/xml");
                sdo.setObjectName(file.getName());
                sdo.setObjectExtension("xml");
                String objectId = this.llsStoreFacade.storeObject(storeDataStructId, sdo);
                Assert.assertNotNull((Object)objectId);
            }
            catch (Exception e) {
                throw new Exception("Nested Exception: " + e);
            }
        }
        finally {
            file.delete();
            this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
        }
    }

    @Test
    public void testStoreObjectsBatch() throws Exception {
        ArrayList<SimpleDigitalObject> listObjects = new ArrayList<SimpleDigitalObject>();
        String storeDataStructId = "testStoreObjectsBatchStructure";
        String newStoreDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
        Assert.assertNotNull((Object)newStoreDataStructId);
        String dummyObjectPath = "/tmp/dummyObject1a";
        File file = new File(dummyObjectPath);
        file.createNewFile();
        SimpleDigitalObject sdo = new SimpleDigitalObject();
        sdo.setDataStructureType("objects");
        FileInputStream fis = new FileInputStream(dummyObjectPath);
        sdo.setObjectLocation(FileUtils.convertStreamToByteArray(fis));
        sdo.setObjectMimeType("application/xml");
        sdo.setObjectName("34dxfwqeec3lrgw3thuu");
        sdo.setObjectExtension("xml");
        listObjects.add(sdo);
        String dummyObjectPath1 = "/tmp/dummyObject1b";
        File file1 = new File(dummyObjectPath1);
        file1.createNewFile();
        SimpleDigitalObject sdo1 = new SimpleDigitalObject();
        sdo1.setDataStructureType("objects");
        sdo1.setObjectLocation(FileUtils.convertStreamToByteArray(new FileInputStream(dummyObjectPath1)));
        sdo1.setObjectMimeType("application/msword");
        sdo1.setObjectName("ds33e4rffw3rl3");
        sdo.setObjectExtension("doc");
        listObjects.add(sdo1);
        String dummyObjectPath2 = "/tmp/dummyObject1c";
        File file2 = new File(dummyObjectPath2);
        file2.createNewFile();
        SimpleDigitalObject sdo2 = new SimpleDigitalObject();
        sdo2.setDataStructureType("objects");
        sdo2.setObjectLocation(FileUtils.convertStreamToByteArray(new FileInputStream(dummyObjectPath2)));
        sdo2.setObjectMimeType("application/pdf");
        sdo2.setObjectName("dfdffvwvfbeh5l34");
        sdo2.setObjectExtension("pdf");
        listObjects.add(sdo2);
        StoringStatusResponse objectId = this.llsStoreFacade.storeObjectsBatch(newStoreDataStructId, listObjects.iterator());
        Assert.assertNotNull((Object)objectId);
        this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
    }

    @Test
    public void testDeleteObject() throws Exception {
        String dummyObjectPath = "/tmp/dummyObject44";
        File file = new File(dummyObjectPath);
        String storeDataStructId = "testDeleteObjectStructure";
        String newStoreDataStructId = null;
        try {
            try {
                if (!file.exists()) {
                    Assert.assertTrue((String)("Can not create file required for testing: " + dummyObjectPath), (boolean)file.createNewFile());
                }
                newStoreDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
                Assert.assertNotNull((Object)newStoreDataStructId);
                System.out.println("The Store Data Structure identifier:" + newStoreDataStructId);
                SimpleDigitalObject sdo = new SimpleDigitalObject();
                sdo.setDataStructureType("objects");
                sdo.setObjectLocation(FileUtils.convertStreamToByteArray(new FileInputStream(dummyObjectPath)));
                sdo.setObjectMimeType("application/xml");
                sdo.setObjectName(file.getName());
                sdo.setObjectExtension("xml");
                String objectId = this.llsStoreFacade.storeObject(storeDataStructId, sdo);
                Assert.assertNotNull((Object)objectId);
                boolean status = this.llsStoreFacade.removeObject(storeDataStructId, sdo);
                Assert.assertTrue((boolean)status);
            }
            catch (Exception e) {
                throw new Exception("Nested Exception: " + e.getMessage());
            }
        }
        finally {
            file.delete();
            this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
        }
    }

    @Test
    public void cleanStoreDataStructureTest() throws Exception {
        String storeDataStructId = "cleanStoreDataStructureTestStructure";
        String newStoreDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
        Assert.assertNotNull((Object)newStoreDataStructId);
        String dummyObjectPath = "/tmp/dummyObject55";
        File file = new File(dummyObjectPath);
        file.createNewFile();
        SimpleDigitalObject sdo = new SimpleDigitalObject();
        sdo.setDataStructureType("objects");
        sdo.setObjectLocation(FileUtils.convertStreamToByteArray(new FileInputStream(dummyObjectPath)));
        sdo.setObjectMimeType("application/xml");
        sdo.setObjectName(file.getName());
        sdo.setObjectExtension("xml");
        String objectId = this.llsStoreFacade.storeObject(storeDataStructId, sdo);
        Assert.assertNotNull((Object)objectId);
        boolean cleanStatus = this.llsStoreFacade.cleanStoreDataStructure(newStoreDataStructId);
        Assert.assertTrue((boolean)cleanStatus);
        boolean status = this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
        Assert.assertTrue((boolean)status);
    }

    @Test
    public void performSimpleSearchTest() throws Exception {
        String dummyObjectPath = "/tmp/dummyObject1";
        File file = new File(dummyObjectPath);
        if (!file.exists()) {
            Assert.assertTrue((String)("Can not create file required for testing: " + dummyObjectPath), (boolean)file.createNewFile());
        }
        String storeDataStructId = "performSimpleSearchTestStructure";
        String newStoreDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
        Assert.assertNotNull((Object)newStoreDataStructId);
        System.out.println("Searching Store Data Structure objects");
        Iterator<String> results = this.llsStoreFacade.performSimpleSearch(new String[]{"stds"});
        Assert.assertNotNull((String)"No objects found in the storage!", results);
        while (results.hasNext()) {
            System.out.println("Found STDS: " + results.next());
        }
        boolean status = this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
        Assert.assertTrue((boolean)status);
    }

    @Test
    public void getSingleObjectTest() throws Exception {
        String storeDataStructId = "getSingleObjectTestStructure";
        String objectName = "dummyObject77";
        String objecIdForSearching = "yar://" + storeDataStructId + "/" + "objects" + "/" + objectName;
        storeDataStructId = this.llsStoreFacade.createStoreDataStructure(storeDataStructId);
        Assert.assertNotNull((String)"Store Data Structure not created", (Object)storeDataStructId);
        SimpleDigitalObject sdo = new SimpleDigitalObject();
        sdo.setDataStructureType("objects");
        sdo.setObjectLocation("I am a content of dummyObject!".getBytes());
        sdo.setObjectName(objectName);
        sdo.setObjectExtension("xml");
        sdo.setObjectTags(new String[]{"xml", "objects"});
        String objectId = this.llsStoreFacade.storeObject(storeDataStructId, sdo);
        Assert.assertNotNull((Object)objectId);
        InputStream result = this.llsStoreFacade.getSingleObject(objecIdForSearching);
        String resultString = FileUtils.convertStreamToString(result);
        System.out.println("Object content: " + resultString);
        boolean status = this.llsStoreFacade.removeStoreDataStructure(storeDataStructId);
        Assert.assertTrue((boolean)status);
    }

    public boolean deleteDirectory(File directoryToBeRemoved) {
        if (directoryToBeRemoved.isDirectory()) {
            String[] children = directoryToBeRemoved.list();
            int i = 0;
            while (i < children.length) {
                boolean success = this.deleteDirectory(new File(directoryToBeRemoved, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return directoryToBeRemoved.delete();
    }
}

