/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.db;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import pl.edu.icm.yadda.service2.ArchiveContentPart;
import pl.edu.icm.yadda.service2.ArchiveContentPartMeta;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.archive.db.ContentPartDao2;

public class CachedContentPartDao2
extends ContentPartDao2 {
    protected Cache cache;
    protected final String CACHE_CONTENT_PART_META = "ContentPartMeta:";
    protected final String CACHE_CONTENT_PART_META_CHILD = "ContentPartMeta:child:";
    protected final String CACHE_GROUP_CONTENT_PART_META = "ContentPartGroup:";

    @Override
    public ArchiveContentPartMeta getPartOfObject(long ownerPk, String type) {
        try {
            return (ArchiveContentPartMeta)this.cache.getFromCache("ContentPartMeta:child:" + ownerPk + ":" + type);
        }
        catch (NeedsRefreshException e) {
            ArchiveContentPartMeta meta = super.getPartOfObject(ownerPk, type);
            if (meta != null) {
                this.cache.putInCache("ContentPartMeta:child:" + ownerPk + ":" + type, (Object)meta, new String[]{"ContentPartGroup:" + meta.getId()});
            } else {
                this.cache.cancelUpdate("ContentPartMeta:child:" + ownerPk + ":" + type);
            }
            return meta;
        }
    }

    @Override
    public ArchiveContentPart getPart(String id) throws ServiceException {
        try {
            ArchiveContentPartMeta meta = (ArchiveContentPartMeta)this.cache.getFromCache("ContentPartMeta:" + id);
            if (meta != null && !(meta instanceof ArchiveContentPart)) {
                meta = super.getPart(id);
                this.cache.putInCache("ContentPartMeta:" + id, (Object)meta, new String[]{"ContentPartGroup:" + id});
            }
            return (ArchiveContentPart)meta;
        }
        catch (NeedsRefreshException e) {
            ArchiveContentPart meta = super.getPart(id);
            this.cache.putInCache("ContentPartMeta:" + id, (Object)meta, new String[]{"ContentPartGroup:" + id});
            return meta;
        }
    }

    @Override
    public void remove(String id) throws ServiceException {
        super.remove(id);
        this.cache.flushGroup("ContentPartGroup:" + id);
        this.cache.putInCache("ContentPartMeta:" + id, null, new String[]{"ContentPartGroup:" + id});
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

