/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.db;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.SqlLobValue;
import pl.edu.icm.yadda.service2.ArchiveContentPart;
import pl.edu.icm.yadda.service2.ArchiveContentPartMeta;
import pl.edu.icm.yadda.service2.exception.DataAccessException;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.archive.db.IContentDao;
import pl.edu.icm.yadda.service3.archive.db.IContentPartDao2;

public class ContentPartDao2
implements IContentPartDao2 {
    protected static final String TABLE_NAME_PART = "archive_content_part";
    protected static final String COLUMN_ID = "id";
    protected static final String COLUMN_INTERNAL_PARENT_ID = "parent__id";
    protected static final String COLUMN_PATH = "path";
    protected static final String COLUMN_DIRECT_CONTENT = "direct_content";
    protected static final String COLUMN_SIZE = "size";
    protected static final String COLUMN_TYPE = "data_type";
    protected static final String COLUMN_MIME = "mime";
    protected static final String COLUMN_MD5 = "md5";
    protected IContentDao contentDao;
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private String tablePrefix = "";
    private boolean calculateMD5 = true;

    @Override
    public void createDirect(String id, Long ownerPk, String type, byte[] data, String mime) throws ServiceException {
        this.simpleJdbcTemplate.getJdbcOperations().update("INSERT INTO " + this.getTableName() + " (" + COLUMN_ID + ", " + COLUMN_INTERNAL_PARENT_ID + ", " + COLUMN_TYPE + ", " + COLUMN_DIRECT_CONTENT + ", " + COLUMN_SIZE + ", " + COLUMN_MIME + ") " + "VALUES (?, ?, ?, ?, ?, ?)", new Object[]{id, ownerPk, type, new SqlLobValue(data), data.length, mime}, new int[]{12, 4, 12, 2004, 4, 12});
    }

    @Override
    public String create(String id, String type, String mime) throws ServiceException {
        try {
            String fileName = this.contentDao.createFile();
            this.simpleJdbcTemplate.update("INSERT INTO " + this.getTableName() + " (" + COLUMN_ID + ", " + COLUMN_INTERNAL_PARENT_ID + ", " + COLUMN_TYPE + ", " + COLUMN_PATH + ", " + COLUMN_MIME + ") " + "VALUES (?, ?, ?, ?, ?)", new Object[]{id, null, type, fileName, mime});
            ArchiveContentPartMeta meta = new ArchiveContentPartMeta();
            meta.setId(id);
            meta.setType(type);
            meta.setMime(mime);
            meta.setPath(fileName);
            return fileName;
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public void commit(String handler) throws ServiceException {
        try {
            if (this.calculateMD5) {
                IContentDao.CommitResult result = this.contentDao.commitFileWithMD5(handler);
                this.simpleJdbcTemplate.update("UPDATE " + this.getTableName() + " SET " + COLUMN_SIZE + " = ?, " + COLUMN_MD5 + " = ? " + "WHERE " + COLUMN_PATH + " = ?", new Object[]{result.size, result.md5, handler});
            } else {
                long size = this.contentDao.commitFile(handler);
                this.simpleJdbcTemplate.update("UPDATE " + this.getTableName() + " SET " + COLUMN_SIZE + " = ? " + "WHERE " + COLUMN_PATH + " = ?", new Object[]{size, handler});
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void bindPart(String id, Long ownerPk) throws ServiceException {
        long count = this.simpleJdbcTemplate.update("UPDATE " + this.getTableName() + " SET " + COLUMN_INTERNAL_PARENT_ID + " = ? " + "WHERE " + COLUMN_ID + " = ? AND " + COLUMN_SIZE + " NOTNULL", new Object[]{ownerPk, id});
        if (count == 0L) {
            throw new ServiceException("Part with id" + id + "is not found or is not yet committed");
        }
    }

    public List<ArchiveContentPartMeta> fetchOrphanContentParts() throws ServiceException {
        return this.simpleJdbcTemplate.query("SELECT id, size, data_type, mime FROM " + this.getTableName() + " " + " WHERE " + COLUMN_INTERNAL_PARENT_ID + " IS NULL", (ParameterizedRowMapper)new ContentPartMetaMapper(false), new Object[0]);
    }

    @Override
    public List<ArchiveContentPartMeta> getPartsOfObject(long ownerPk) throws ServiceException {
        return this.simpleJdbcTemplate.query("SELECT id, path, size, data_type, md5, mime FROM " + this.getTableName() + " " + " WHERE " + COLUMN_INTERNAL_PARENT_ID + " = ?", (ParameterizedRowMapper)new ContentPartMetaMapper(false), new Object[]{ownerPk});
    }

    public ArchiveContentPart getPart(String id) throws ServiceException {
        try {
            return (ArchiveContentPart)this.simpleJdbcTemplate.queryForObject("SELECT id, path, size, direct_content, md5, data_type, mime FROM " + this.getTableName() + " " + " WHERE " + COLUMN_ID + " = ?", (ParameterizedRowMapper)new ContentPartMetaMapper(true), new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public ArchiveContentPartMeta getPartOfObject(long ownerPk, String type) {
        try {
            return (ArchiveContentPartMeta)this.simpleJdbcTemplate.queryForObject("SELECT id, path, size, data_type, md5, mime FROM " + this.getTableName() + " " + " WHERE " + COLUMN_INTERNAL_PARENT_ID + " = ? AND " + COLUMN_TYPE + " = ?", (ParameterizedRowMapper)new ContentPartMetaMapper(false), new Object[]{ownerPk, type});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public int read(String id, long start, int count, byte[] buf) throws ServiceException {
        ArchiveContentPart meta = this.getPart(id);
        if (meta.getData() != null) {
            if (start + (long)count > (long)meta.getData().length) {
                count = (int)((long)meta.getData().length - start);
            }
            if (count <= 0) {
                return -1;
            }
            System.arraycopy(meta.getData(), (int)start, buf, 0, count);
            return count;
        }
        if (meta == null) {
            throw new RuntimeException();
        }
        try {
            return this.contentDao.readFile(meta.getPath(), start, count, buf);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public byte[] readAll(String id) throws ServiceException {
        ArchiveContentPart meta = this.getPart(id);
        if (meta == null) {
            throw new RuntimeException();
        }
        if (meta.getData() != null) {
            return meta.getData();
        }
        try {
            return this.contentDao.readAll(meta.getPath());
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public void remove(String id) throws ServiceException {
        ArchiveContentPart meta = this.getPart(id);
        if (meta == null) {
            throw new ServiceException("Part with id " + id + " not found");
        }
        this.simpleJdbcTemplate.update("DELETE FROM " + this.getTableName() + " WHERE " + COLUMN_ID + " = ?", new Object[]{id});
        if (meta.getData() == null) {
            try {
                this.contentDao.remove(meta.getPath());
            }
            catch (IOException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    @Override
    public void write(String id, long start, byte[] buf, int bufOff, int bufLen) throws ServiceException {
        try {
            this.contentDao.writeFile(id, start, buf, bufOff, bufLen);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTableName() {
        return String.valueOf(this.tablePrefix) + TABLE_NAME_PART;
    }

    @Required
    public void setSimpleJdbcTemplate(SimpleJdbcTemplate simpleJdbcTemplate) {
        this.simpleJdbcTemplate = simpleJdbcTemplate;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setContentDao(IContentDao contentDao) {
        this.contentDao = contentDao;
    }

    public boolean isCalculateMD5() {
        return this.calculateMD5;
    }

    public void setCalculateMD5(boolean calculateMD5) {
        this.calculateMD5 = calculateMD5;
    }

    protected final class ContentPartMetaMapper
    implements ParameterizedRowMapper<ArchiveContentPartMeta> {
        protected boolean fetchDirectContent;

        public ContentPartMetaMapper(boolean fetchDirectContent) {
            this.fetchDirectContent = fetchDirectContent;
        }

        public ArchiveContentPart mapRow(ResultSet rs, int rowNum) throws SQLException {
            ArchiveContentPart part = new ArchiveContentPart();
            part.setId(rs.getString(ContentPartDao2.COLUMN_ID));
            part.setSize((long)rs.getInt(ContentPartDao2.COLUMN_SIZE));
            part.setType(rs.getString(ContentPartDao2.COLUMN_TYPE));
            part.setPath(rs.getString(ContentPartDao2.COLUMN_PATH));
            part.setMime(rs.getString(ContentPartDao2.COLUMN_MIME));
            part.setMd5(rs.getString(ContentPartDao2.COLUMN_MD5));
            if (this.fetchDirectContent) {
                part.setData(rs.getBytes(ContentPartDao2.COLUMN_DIRECT_CONTENT));
            }
            return part;
        }
    }
}

