/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.archive.db.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Test;
import org.springframework.test.annotation.AbstractAnnotationAwareTransactionalTests;
import pl.edu.icm.yadda.bean.Configurable;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.YaddaObjectMeta;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.archive.db.DbArchiveObject2Meta;
import pl.edu.icm.yadda.service3.archive.db.IArchiveDao2;

public class PostgresArchiveDao2Test
extends AbstractAnnotationAwareTransactionalTests {
    protected IArchiveDao2 archiveDao2;
    protected Configurable initializer;

    public PostgresArchiveDao2Test() {
        this.setAutowireMode(1);
    }

    protected void onSetUpInTransaction() throws Exception {
        if (this.initializer.isPrepared() != null) {
            this.initializer.prepare();
        }
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:pl/edu/icm/yadda/service3/archive/db/dao/archive-service-beans-postgresql.xml"};
    }

    @Test
    public void testCreateRootObject() throws Exception {
        ArchiveObject2Meta rootObject = new ArchiveObject2Meta();
        rootObject.setId(new YaddaObjectID("A", "B", "C"));
        rootObject.setAlternativeId(new YaddaObjectID("D", "E", "F"));
        rootObject.setStatus(YaddaObjectMeta.STATUS.DELETED);
        rootObject.setType("TYPE1");
        rootObject.setTimestamp(new Date());
        long pk = this.archiveDao2.createRootObject(rootObject);
        Map map = this.jdbcTemplate.queryForMap("SELECT * from oss_archive_object WHERE _pk = ?", new Object[]{pk});
        for (Map.Entry entry : map.entrySet()) {
            System.out.println(String.valueOf((String)entry.getKey()) + " = " + entry.getValue());
        }
    }

    @Test
    public void testCreateObject() throws Exception {
        long parent = this.createSampleParent(new YaddaObjectID("P1", "P2", "P3"));
        ArchiveObject2Meta object = new ArchiveObject2Meta();
        object.setId(new YaddaObjectID("A", "B", "C"));
        object.setAlternativeId(new YaddaObjectID("D", "E", "F"));
        object.setStatus(YaddaObjectMeta.STATUS.DELETED);
        object.setType("TYPE1");
        object.setTimestamp(new Date());
        long pk = this.archiveDao2.createObject(parent, object);
        Map map = this.jdbcTemplate.queryForMap("SELECT * from oss_archive_object WHERE _pk = ?", new Object[]{pk});
        for (Map.Entry entry : map.entrySet()) {
            System.out.println(String.valueOf((String)entry.getKey()) + " = " + entry.getValue());
        }
    }

    @Test
    public void testAddTags() throws Exception {
        long owner = this.createSampleParent(new YaddaObjectID("P1", "P2", "P3"));
        this.archiveDao2.addTags(owner, new String[]{"TAG1", "TAG2"});
        List tags = this.jdbcTemplate.queryForList("SELECT tag_value FROM oss_archive_tag WHERE owner__pk = ?", new Object[]{owner}, String.class);
        PostgresArchiveDao2Test.assertTrue((boolean)tags.contains("TAG1"));
        PostgresArchiveDao2Test.assertTrue((boolean)tags.contains("TAG2"));
        PostgresArchiveDao2Test.assertEquals((int)2, (int)tags.size());
    }

    @Test
    public void testDropTags() throws Exception {
        long owner = this.createSampleParent(new YaddaObjectID("P1", "P2", "P3"));
        this.archiveDao2.addTags(owner, new String[]{"TAG1", "TAG2", "TAG3"});
        this.archiveDao2.dropTags(owner, new String[]{"TAG1", "TAG3"});
        List tags = this.jdbcTemplate.queryForList("SELECT tag_value FROM oss_archive_tag WHERE owner__pk = ?", new Object[]{owner}, String.class);
        PostgresArchiveDao2Test.assertFalse((boolean)tags.contains("TAG1"));
        PostgresArchiveDao2Test.assertTrue((boolean)tags.contains("TAG2"));
        PostgresArchiveDao2Test.assertFalse((boolean)tags.contains("TAG3"));
        PostgresArchiveDao2Test.assertEquals((int)1, (int)tags.size());
    }

    @Test
    public void testReadTags() throws Exception {
        long owner = this.createSampleParent(new YaddaObjectID("P1", "P2", "P3"));
        this.archiveDao2.addTags(owner, new String[]{"TAG1", "TAG2"});
        Object[] tags = this.archiveDao2.readTags(owner);
        PostgresArchiveDao2Test.assertTrue((boolean)ArrayUtils.contains((Object[])tags, (Object)"TAG1"));
        PostgresArchiveDao2Test.assertTrue((boolean)ArrayUtils.contains((Object[])tags, (Object)"TAG2"));
        PostgresArchiveDao2Test.assertEquals((int)2, (int)tags.length);
    }

    @Test
    public void testReadObjectByYaddaObjectId() throws Exception {
        this.createSampleObject();
        DbArchiveObject2Meta meta = this.archiveDao2.readObject(new YaddaObjectID("A", "B", "C"), false);
        this.verifySampleObject(meta);
    }

    @Test
    public void testReadObjectByPk() throws Exception {
        long pk = this.createSampleObject();
        DbArchiveObject2Meta meta = this.archiveDao2.readObject(pk, true, false);
        this.verifySampleObject(meta);
    }

    @Test
    public void testReadObjectById() throws Exception {
        this.createSampleObject();
        DbArchiveObject2Meta meta = this.archiveDao2.readObject("A", true, false);
        this.verifySampleObject(meta);
    }

    @Test
    public void testUpdateMeta() throws Exception {
        long pk = this.createSampleObject();
        ArchiveObject2Meta changedMeta = new ArchiveObject2Meta();
        changedMeta.setId(new YaddaObjectID("P", "Q", "R"));
        changedMeta.setAlternativeId(new YaddaObjectID("S", "T", "U"));
        changedMeta.setStatus(YaddaObjectMeta.STATUS.MERGED);
        changedMeta.setStructureType("STT");
        changedMeta.setType("SXX");
        changedMeta.setTimestamp(new Date());
        this.archiveDao2.updateMeta(pk, changedMeta);
        DbArchiveObject2Meta readMeta = this.archiveDao2.readObject(pk, true, false);
        PostgresArchiveDao2Test.assertEquals((Object)changedMeta.getId(), (Object)readMeta.getId());
        PostgresArchiveDao2Test.assertEquals((Object)changedMeta.getAlternativeId(), (Object)readMeta.getAlternativeId());
        PostgresArchiveDao2Test.assertEquals((Object)changedMeta.getStatus(), (Object)readMeta.getStatus());
        PostgresArchiveDao2Test.assertEquals((String)changedMeta.getStructureType(), (String)readMeta.getStructureType());
        PostgresArchiveDao2Test.assertEquals((String)changedMeta.getType(), (String)readMeta.getType());
    }

    @Test
    public void testListObjects() throws Exception {
        this.createListedObject(1950, new String[]{"T1", "T2", "T3"});
        this.createListedObject(1960, new String[]{"T2", "T3"});
        this.createListedObject(1961, new String[]{"T1"});
        this.createListedObject(1970, new String[]{"T1", "T2"});
        IArchiveDao2.Page<DbArchiveObject2Meta> result1 = this.archiveDao2.listObjects(new Date(1955, 1, 1), null, null, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)3, (int)result1.size());
        IArchiveDao2.Page<DbArchiveObject2Meta> result2 = this.archiveDao2.listObjects(new Date(1955, 1, 1), new Date(1965, 1, 1), null, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)2, (int)result2.size());
        IArchiveDao2.Page<DbArchiveObject2Meta> result3 = this.archiveDao2.listObjects(new Date(1955, 1, 1), new Date(1975, 1, 1), new String[][]{{"T1"}}, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)2, (int)result3.size());
        IArchiveDao2.Page<DbArchiveObject2Meta> result4 = this.archiveDao2.listObjects(new Date(1945, 1, 1), new Date(1975, 1, 1), new String[][]{{"T1", "T2"}}, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)4, (int)result4.size());
        IArchiveDao2.Page<DbArchiveObject2Meta> result5 = this.archiveDao2.listObjects(new Date(1945, 1, 1), new Date(1975, 1, 1), new String[][]{{"T1"}, {"T2"}}, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)2, (int)result5.size());
        IArchiveDao2.Page<DbArchiveObject2Meta> result6 = this.archiveDao2.listObjects(new Date(1945, 1, 1), new Date(1975, 1, 1), new String[][]{{"T1"}, {"T2", "T3"}}, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)2, (int)result6.size());
    }

    @Test
    public void testListObjectsByToken() throws Exception {
        int i = 0;
        while (i < 350) {
            this.createListedObject(i, new String[]{"T1", "T2"});
            ++i;
        }
        IArchiveDao2.Page<DbArchiveObject2Meta> result1 = this.archiveDao2.listObjects(new Date(99, 5, 5), null, null, false, IArchiveDao2.HistoricalSelection.ALL);
        PostgresArchiveDao2Test.assertEquals((int)100, (int)result1.size());
        System.out.println(result1.getResumptionToken());
        IArchiveDao2.Page<DbArchiveObject2Meta> result2 = this.archiveDao2.listObjects(result1.getResumptionToken());
        PostgresArchiveDao2Test.assertEquals((int)100, (int)result2.size());
        IArchiveDao2.Page<DbArchiveObject2Meta> result3 = this.archiveDao2.listObjects(result2.getResumptionToken());
        PostgresArchiveDao2Test.assertEquals((int)50, (int)result3.size());
    }

    protected long createSampleParent(YaddaObjectID id) throws Exception {
        ArchiveObject2Meta rootObject = new ArchiveObject2Meta();
        rootObject.setId(id);
        rootObject.setAlternativeId(new YaddaObjectID("D", "E", "F"));
        rootObject.setStatus(YaddaObjectMeta.STATUS.DELETED);
        rootObject.setType("TYPE1");
        rootObject.setTimestamp(new Date());
        long pk = this.archiveDao2.createRootObject(rootObject);
        return pk;
    }

    protected long createSampleObject() throws Exception {
        long parentPk = this.createSampleParent(new YaddaObjectID("P1", "P2", "P3"));
        ArchiveObject2Meta rootObject = new ArchiveObject2Meta();
        rootObject.setId(new YaddaObjectID("A", "B", "C"));
        rootObject.setAlternativeId(new YaddaObjectID("D", "E", "F"));
        rootObject.setStatus(YaddaObjectMeta.STATUS.DELETED);
        rootObject.setType("TYPE1");
        rootObject.setTimestamp(new Date());
        long pk = this.archiveDao2.createObject(parentPk, rootObject);
        return pk;
    }

    protected long createListedObject(int year, String[] tags) throws Exception {
        Date date = new Date(year, 1, 1);
        ArchiveObject2Meta rootObject = new ArchiveObject2Meta();
        rootObject.setId(new YaddaObjectID("A" + year, "B", "C"));
        rootObject.setAlternativeId(new YaddaObjectID("D", "E", "F"));
        rootObject.setStatus(YaddaObjectMeta.STATUS.DELETED);
        rootObject.setType("TYPE1");
        rootObject.setTimestamp(date);
        long pk = this.archiveDao2.createRootObject(rootObject);
        this.archiveDao2.addTags(pk, tags);
        return pk;
    }

    protected void verifySampleObject(ArchiveObject2Meta meta) {
        PostgresArchiveDao2Test.assertEquals((Object)new YaddaObjectID("P1", "P2", "P3"), (Object)meta.getParentId());
        PostgresArchiveDao2Test.assertEquals((Object)new YaddaObjectID("A", "B", "C"), (Object)meta.getId());
        PostgresArchiveDao2Test.assertEquals((Object)new YaddaObjectID("D", "E", "F"), (Object)meta.getAlternativeId());
        PostgresArchiveDao2Test.assertEquals((Object)YaddaObjectMeta.STATUS.DELETED, (Object)meta.getStatus());
        PostgresArchiveDao2Test.assertEquals((String)"TYPE1", (String)meta.getType());
    }

    public void setArchiveDao2(IArchiveDao2 archiveDao2) {
        this.archiveDao2 = archiveDao2;
    }

    public void setInitializer(Configurable initializer) {
        this.initializer = initializer;
    }
}

