/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.springframework.test.annotation.AbstractAnnotationAwareTransactionalTests;
import pl.edu.icm.yadda.service2.ArchiveContentPartFacade;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.archive.impl.ArchiveFacade2;
import pl.edu.icm.yadda.service3.storage.impl.StorageFacade2;

public class ContentPartSupportTest
extends AbstractAnnotationAwareTransactionalTests {
    protected StorageFacade2 storageFacade;
    protected ArchiveFacade2 archiveFacade;

    public ContentPartSupportTest() {
        this.setAutowireMode(1);
    }

    public void testStoreAndReadContentPart() throws Exception {
        byte[] inputContent = new byte[1000000];
        new Random().nextBytes(inputContent);
        ArchiveObjectFacade object = this.createSampleRoot(inputContent);
        ArchiveObjectFacade objectFacade = this.archiveFacade.getObject(object.getId(), new String[]{"TEST"}, false);
        ContentPartSupportTest.assertEquals((int)1, (int)objectFacade.getParts().size());
        ContentPartSupportTest.assertNotNull((Object)objectFacade.getPart("TEST"));
        ArchiveContentPartFacade cp = objectFacade.getPart("TEST");
        ContentPartSupportTest.assertNotNull((Object)cp.getId());
        ContentPartSupportTest.assertEquals((String)"TEST", (String)cp.getType());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)cp.getData(), (OutputStream)os);
        byte[] outputContent = os.toByteArray();
        ContentPartSupportTest.assertTrue((boolean)Arrays.equals(inputContent, outputContent));
    }

    public void testDropContentPart() throws Exception {
        byte[] inputContent = new byte[1000000];
        new Random().nextBytes(inputContent);
        ArchiveObjectFacade object = this.createSampleRoot(inputContent);
        ArchiveObjectFacade facade = new ArchiveObjectFacade((ArchiveObject2Meta)object);
        YaddaObjectID updatedId = this.storageFacade.saveObject(null, facade, new String[]{"TEST"}, null);
        ArchiveObjectFacade objectFacade = this.archiveFacade.getObject(updatedId, new String[]{"TEST"}, false);
        ContentPartSupportTest.assertEquals((int)0, (int)objectFacade.getParts().size());
    }

    protected ArchiveObjectFacade createSampleRoot(byte[] inputContent) throws ServiceException {
        YaddaObjectID id = new YaddaObjectID(UUID.randomUUID().toString(), "DisplayName");
        ArchiveObjectFacade meta = new ArchiveObjectFacade();
        meta.setId(id);
        meta.setStructureType(UUID.randomUUID().toString());
        meta.setType(UUID.randomUUID().toString());
        meta.setTags(new String[]{UUID.randomUUID().toString(), "SAMPLE2"});
        ByteArrayInputStream is = new ByteArrayInputStream(inputContent);
        ArchiveContentPartFacade contentPart = new ArchiveContentPartFacade(null, "TEST", "unknown", (InputStream)is);
        meta.addPart(contentPart);
        id = this.storageFacade.saveObject(null, meta, null, null);
        meta.setId(id);
        return meta;
    }

    protected void onSetUpInTransaction() throws Exception {
        StorageFacade2 cf = this.storageFacade;
        if (cf.isPrepared() != null) {
            cf.prepare();
        }
        super.onSetUpInTransaction();
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:pl/edu/icm/yadda/service3/archive/db/dao/archive-service-beans-postgresql.xml"};
    }

    public void setStorageFacade(StorageFacade2 storageFacade) {
        this.storageFacade = storageFacade;
    }

    public void setArchiveFacade(ArchiveFacade2 archiveFacade) {
        this.archiveFacade = archiveFacade;
    }
}

