/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import pl.edu.icm.yadda.bean.Configurable;
import pl.edu.icm.yadda.bean.ConfigurableUtitlities;
import pl.edu.icm.yadda.bean.Problem;
import pl.edu.icm.yadda.service2.ArchiveContentPartMeta;
import pl.edu.icm.yadda.service2.GenericRequest;
import pl.edu.icm.yadda.service2.GetFeaturesRequest;
import pl.edu.icm.yadda.service2.GetFeaturesResponse;
import pl.edu.icm.yadda.service2.GetVersionResponse;
import pl.edu.icm.yadda.service2.VersionHelper;
import pl.edu.icm.yadda.service2.YaddaError;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.storage.IStorage;
import pl.edu.icm.yadda.service2.storage.StorageBatchRequest;
import pl.edu.icm.yadda.service2.storage.StorageBatchResponse;
import pl.edu.icm.yadda.service2.storage.StorageExecuteRequest;
import pl.edu.icm.yadda.service2.storage.StorageExecuteResponse;
import pl.edu.icm.yadda.service2.storage.operation.StorageOperation;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectPath;
import pl.edu.icm.yadda.service3.storage.CommitContentPartRequest;
import pl.edu.icm.yadda.service3.storage.CommitContentPartResponse;
import pl.edu.icm.yadda.service3.storage.CreateContentPartRequest;
import pl.edu.icm.yadda.service3.storage.CreateContentPartResponse;
import pl.edu.icm.yadda.service3.storage.IStorage2;
import pl.edu.icm.yadda.service3.storage.SendChunkRequest;
import pl.edu.icm.yadda.service3.storage.SendChunkResponse;
import pl.edu.icm.yadda.service3.storage.db.IStorageBackend;
import pl.edu.icm.yadda.service3.storage.operation.Save2Operation;
import pl.edu.icm.yadda.service3.storage.operation.SavePolicy;
import pl.edu.icm.yadda.tools.id.UUIDGenerator;

public class DBStorage
implements IStorage2,
Configurable {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final Set<String> FEATURES = new HashSet<String>();
    protected IStorageBackend backend;
    protected Configurable[] dbInitializers = new Configurable[0];

    public StorageExecuteResponse execute(StorageExecuteRequest request) {
        return this.internalExecute(request.getOperation());
    }

    public StorageBatchResponse batch(StorageBatchRequest request) {
        StorageBatchResponse resp = new StorageBatchResponse();
        StorageOperation[] ops = request.getOperations();
        if (request.getMode() == IStorage.EXECUTION_MODE.SEQUENTIAL) {
            StorageExecuteResponse[] rs = new StorageExecuteResponse[ops.length];
            int i = 0;
            while (i < ops.length) {
                rs[i] = this.internalExecute(ops[i]);
                ++i;
            }
            resp.setResults(rs);
        } else {
            try {
                YaddaObjectID[] ids = this.backend.batch(ops);
                StorageExecuteResponse[] results = new StorageExecuteResponse[ids.length];
                int i = 0;
                while (i < ids.length) {
                    results[i] = new StorageExecuteResponse(ops[i].getName(), ids[i]);
                    ++i;
                }
                resp.setResults(results);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception caught", (Throwable)e);
                resp.setError(new YaddaError("", e.getMessage(), e));
            }
        }
        return resp;
    }

    public CreateContentPartResponse createContentPart(CreateContentPartRequest request) {
        CreateContentPartResponse resp = new CreateContentPartResponse();
        try {
            String id = new UUIDGenerator().generate(null);
            String handler = this.backend.createContentPart(id, request.getType(), request.getMime());
            ArchiveContentPartMeta partMeta = new ArchiveContentPartMeta(id, request.getType(), request.getMime());
            resp.setMeta(partMeta);
            resp.setHandler(handler);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception caught", (Throwable)e);
            resp.setError(new YaddaError("", e.getMessage(), e));
        }
        return resp;
    }

    public CommitContentPartResponse commitContentPart(CommitContentPartRequest request) {
        CommitContentPartResponse resp = new CommitContentPartResponse();
        try {
            this.backend.commitContentPart(request.getHandler());
        }
        catch (Exception e) {
            this.log.error((Object)"Exception caught", (Throwable)e);
            resp.setError(new YaddaError("", e.getMessage(), e));
        }
        return resp;
    }

    public SendChunkResponse sendChunk(SendChunkRequest request) {
        SendChunkResponse resp = new SendChunkResponse();
        try {
            String crc = this.backend.sendChunk(request.getHandler(), request.getOffset(), request.getData(), request.getSize());
            resp.setCrc(crc);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception caught", (Throwable)e);
            resp.setError(new YaddaError("", e.getMessage(), e));
        }
        return resp;
    }

    protected StorageExecuteResponse internalExecute(StorageOperation op) {
        try {
            YaddaObjectID resultId = this.backend.execute(op);
            return new StorageExecuteResponse(op.getName(), resultId);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception caught", (Throwable)e);
            YaddaError error = new YaddaError("", e.getMessage(), e);
            return new StorageExecuteResponse(op.getName(), error);
        }
    }

    protected void createUUID() {
        ArchiveObject2Meta meta = new ArchiveObject2Meta();
        meta.setId(new YaddaObjectID("pl.edu.icm.yadda.service3.archive.meta"));
        meta.setTags(new String[]{"archiveId:" + UUID.randomUUID().toString()});
        meta.setType("UUID");
        ArchiveObjectPath path = new ArchiveObjectPath(meta.getId());
        Save2Operation op = new Save2Operation(path, meta, null, null, SavePolicy.FAIL_IF_EXISTS);
        this.internalExecute((StorageOperation)op);
    }

    public void prepare() throws Exception {
        ConfigurableUtitlities.prepare((Object[])this.dbInitializers);
        this.createUUID();
    }

    public Problem[] isPrepared() {
        return ConfigurableUtitlities.arePrepared((Object[])this.dbInitializers);
    }

    public void destroy() throws Exception {
        ConfigurableUtitlities.destroy((Object[])this.dbInitializers);
    }

    @Required
    public void setBackend(IStorageBackend backend) {
        this.backend = backend;
    }

    public void setDbInitializers(Configurable[] dbInitializers) {
        this.dbInitializers = dbInitializers;
    }

    public GetFeaturesResponse getFeatures(GetFeaturesRequest request) {
        GetFeaturesResponse resp = new GetFeaturesResponse();
        resp.setFeatures(new HashSet<String>(this.FEATURES));
        return resp;
    }

    public GetVersionResponse getVersionResponse(GenericRequest request) {
        return new GetVersionResponse(VersionHelper.currentAPIVersion());
    }
}

