/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db;

import java.util.LinkedList;
import java.util.List;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.storage.operation.StorageOperation;
import pl.edu.icm.yadda.service3.archive.db.IContentPartDao2;
import pl.edu.icm.yadda.service3.storage.db.IOperationHandler;
import pl.edu.icm.yadda.service3.storage.db.IStorageBackend;
import pl.edu.icm.yadda.service3.storage.db.operation.TransactionContext;

public class DBStorageBackend
implements IStorageBackend {
    protected IContentPartDao2 contentPartDao;
    protected List<IOperationHandler> operationHandlers = new LinkedList<IOperationHandler>();

    @Override
    public String createContentPart(String id, String type, String mime) throws Exception {
        String handler = this.contentPartDao.create(id, type, mime);
        return handler;
    }

    @Override
    public void commitContentPart(String handler) throws Exception {
        this.contentPartDao.commit(handler);
    }

    @Override
    public String sendChunk(String handler, long offset, byte[] data, int size) throws Exception {
        this.contentPartDao.write(handler, offset, data, 0, size);
        return null;
    }

    @Override
    public YaddaObjectID execute(StorageOperation operation) throws Exception {
        TransactionContext tc = new TransactionContext();
        YaddaObjectID result = this.getProperOperationHandler(operation).run(tc, operation);
        return result;
    }

    protected YaddaObjectID execute(TransactionContext tc, StorageOperation operation) throws Exception {
        return this.getProperOperationHandler(operation).run(tc, operation);
    }

    @Override
    public YaddaObjectID[] batch(StorageOperation[] operations) throws Exception {
        YaddaObjectID[] metas = new YaddaObjectID[operations.length];
        TransactionContext tc = new TransactionContext();
        int i = 0;
        while (i < operations.length) {
            metas[i] = this.execute(tc, operations[i]);
            ++i;
        }
        return metas;
    }

    protected IOperationHandler getProperOperationHandler(StorageOperation operation) {
        for (IOperationHandler o : this.operationHandlers) {
            if (!o.isSupported(operation)) continue;
            return o;
        }
        throw new UnsupportedOperationException();
    }

    public void setOperationHandlers(List<IOperationHandler> operationHandlers) {
        this.operationHandlers = operationHandlers;
    }

    public IContentPartDao2 getContentPartDao() {
        return this.contentPartDao;
    }

    public void setContentPartDao(IContentPartDao2 contentPartDao) {
        this.contentPartDao = contentPartDao;
    }
}

