/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.storage.db;

import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service3.storage.db.IVersionNumberGenerator;
import pl.edu.icm.yadda.tools.id.UUIDGenerator;

public class SimpleVersionNumberGenerator
implements IVersionNumberGenerator {
    private final UUIDGenerator ID_GEN = new UUIDGenerator();
    protected String startVersion = "1";
    protected String prefix = "branch.";

    @Override
    public YaddaObjectID generateNew(String id, String displayName) {
        return new YaddaObjectID(id, this.startVersion, this.newBranch(), displayName);
    }

    @Override
    public YaddaObjectID generateNew(YaddaObjectID otherBranchId) {
        return this.generateNew(otherBranchId.getId(), otherBranchId.getDisplayName());
    }

    @Override
    public YaddaObjectID generateNext(YaddaObjectID oldId) {
        return new YaddaObjectID(oldId.getId(), Integer.toString(Integer.parseInt(oldId.getVersion()) + 1), oldId.getBranch(), oldId.getDisplayName());
    }

    protected String newBranch() {
        return String.valueOf(this.prefix) + this.ID_GEN.generate(null);
    }

    public void setStartVersion(String startVersion) {
        this.startVersion = startVersion;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

