/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools;

import org.springframework.context.support.FileSystemXmlApplicationContext;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;
import pl.edu.icm.yadda.service3.storage.IStorageFacade2;
import pl.edu.icm.yadda.service3.storage.IStorageSynchronizer;
import pl.edu.icm.yadda.service3.storage.impl.StorageSynchronizer;

public class CLISynchronizer {
    public static void main(String[] args) throws Exception {
        String treeId = "import";
        FileSystemXmlApplicationContext sourceCtx = new FileSystemXmlApplicationContext("classpath:pl/edu/icm/yadda/service3/tools/oss-cli-context.xml");
        try {
            IArchiveFacade2 sourceArchive = (IArchiveFacade2)sourceCtx.getBean("archiveFacade3");
            FileSystemXmlApplicationContext targetCtx = new FileSystemXmlApplicationContext("classpath:pl/edu/icm/yadda/service3/tools/oss-cli-context2.xml");
            try {
                IArchiveFacade2 targetArchive = (IArchiveFacade2)targetCtx.getBean("archiveFacade3");
                IStorageFacade2 targetStorage = (IStorageFacade2)targetCtx.getBean("storageFacade3");
                StorageSynchronizer storageSynchronizer = new StorageSynchronizer(sourceArchive, targetArchive, targetStorage);
                IStorageSynchronizer.ArchiveNode rootNode = storageSynchronizer.compareSubtrees(treeId);
                CLISynchronizer.list("", rootNode);
                CLISynchronizer.markForce(rootNode);
                storageSynchronizer.synchronizeHistory(null, null, null);
                storageSynchronizer.performSynchronization(rootNode);
            }
            finally {
                targetCtx.close();
            }
        }
        finally {
            sourceCtx.close();
        }
    }

    protected static void list(String prefix, IStorageSynchronizer.ArchiveNode node) {
        System.out.println(String.valueOf(prefix) + "/" + node.getName() + ":" + node.getState());
        for (IStorageSynchronizer.ArchiveNode child : node.getChildren()) {
            CLISynchronizer.list(String.valueOf(prefix) + "/" + node.getName(), child);
        }
    }

    protected static void markForce(IStorageSynchronizer.ArchiveNode node) {
        node.setPolicy(IStorageSynchronizer.Policy.OVERWRITE);
        for (IStorageSynchronizer.ArchiveNode child : node.getChildren()) {
            CLISynchronizer.markForce(child);
        }
    }
}

